/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.FormatIdentifier;
import org.dspace.content.InstallItem;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.handle.HandleManager;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowManager;

public class PackageUtils {
    private static final Logger log = Logger.getLogger(PackageUtils.class);
    private static final String[] ccMetadataMap = new String[]{"name", "dc.title", "introductory_text", "dc.description", "short_description", "dc.description.abstract", "side_bar_text", "dc.description.tableofcontents", "copyright_text", "dc.rights", "provenance_description", "dc.provenance", "license", "dc.rights.license"};
    private static final Map<String, String> ccMetadataToDC = new HashMap<String, String>();
    private static final Map<String, String> ccDCToMetadata = new HashMap<String, String>();
    private static final Pattern groupAnalyzer;
    private static final Map<String, String> orphanGroups;

    public static String dcToContainerMetadata(String dcField) {
        return ccDCToMetadata.get(dcField);
    }

    public static String containerMetadataToDC(String databaseField) {
        return ccMetadataToDC.get(databaseField);
    }

    public static void checkItemMetadata(Item item) throws PackageValidationException {
        DCValue[] t = item.getDC("title", null, "*");
        if (t == null || t.length == 0) {
            throw new PackageValidationException("Item cannot be created without the required \"title\" DC metadata.");
        }
    }

    public static void addDepositLicense(Context context, String license, Item item, Collection collection) throws SQLException, IOException, AuthorizeException {
        if (license == null) {
            license = collection.getLicense();
        }
        ByteArrayInputStream lis = new ByteArrayInputStream(license.getBytes());
        Bundle[] bundles = item.getBundles("LICENSE");
        Bundle lb = bundles == null || bundles.length == 0 ? item.createBundle("LICENSE") : bundles[0];
        Bitstream lbs = lb.createBitstream(lis);
        ((InputStream)lis).close();
        BitstreamFormat bf = BitstreamFormat.findByShortDescription(context, "License");
        if (bf == null) {
            bf = FormatIdentifier.guessFormat(context, lbs);
        }
        lbs.setFormat(bf);
        lbs.setName("license.txt");
        lbs.setSource("license.txt");
        lbs.update();
    }

    public static Bitstream getBitstreamByName(Item item, String name) throws SQLException {
        return PackageUtils.getBitstreamByName(item, name, null);
    }

    public static Bitstream getBitstreamByName(Item item, String bsName, String bnName) throws SQLException {
        Bundle[] bundles = bnName == null ? item.getBundles() : item.getBundles(bnName);
        for (int i = 0; i < bundles.length; ++i) {
            Bitstream[] bitstreams = bundles[i].getBitstreams();
            for (int k = 0; k < bitstreams.length; ++k) {
                if (!bsName.equals(bitstreams[k].getName())) continue;
                return bitstreams[k];
            }
        }
        return null;
    }

    public static Bitstream getBitstreamByFormat(Item item, BitstreamFormat bsf, String bnName) throws SQLException {
        int fid = bsf.getID();
        Bundle[] bundles = bnName == null ? item.getBundles() : item.getBundles(bnName);
        for (int i = 0; i < bundles.length; ++i) {
            Bitstream[] bitstreams = bundles[i].getBitstreams();
            for (int k = 0; k < bitstreams.length; ++k) {
                if (bitstreams[k].getFormat().getID() != fid) continue;
                return bitstreams[k];
            }
        }
        return null;
    }

    public static boolean isMetaInfoBundle(Bundle bn) {
        return bn.getName().equals("LICENSE") || bn.getName().equals("CC-LICENSE") || bn.getName().equals("METADATA");
    }

    public static BitstreamFormat findOrCreateBitstreamFormat(Context context, String shortDesc, String MIMEType, String desc) throws SQLException, AuthorizeException {
        return PackageUtils.findOrCreateBitstreamFormat(context, shortDesc, MIMEType, desc, 1, false);
    }

    public static BitstreamFormat findOrCreateBitstreamFormat(Context context, String shortDesc, String MIMEType, String desc, int supportLevel, boolean internal) throws SQLException, AuthorizeException {
        BitstreamFormat bsf = BitstreamFormat.findByShortDescription(context, shortDesc);
        if (bsf == null) {
            bsf = BitstreamFormat.create(context);
            bsf.setShortDescription(shortDesc);
            bsf.setMIMEType(MIMEType);
            bsf.setDescription(desc);
            bsf.setSupportLevel(supportLevel);
            bsf.setInternal(internal);
            bsf.update();
        }
        return bsf;
    }

    public static Bitstream findDepositLicense(Context context, Item item) throws SQLException, IOException, AuthorizeException {
        int licenseFormatId = -1;
        BitstreamFormat bf = BitstreamFormat.findByShortDescription(context, "License");
        if (bf != null) {
            licenseFormatId = bf.getID();
        }
        Bundle[] bundles = item.getBundles("LICENSE");
        for (int i = 0; i < bundles.length; ++i) {
            Bitstream[] bitstreams = bundles[i].getBitstreams();
            for (int j = 0; j < bitstreams.length; ++j) {
                if (bitstreams[j].getFormat().getID() != licenseFormatId) continue;
                return bitstreams[j];
            }
            if (bitstreams.length <= 0) continue;
            return bitstreams[0];
        }
        return null;
    }

    public static DSpaceObject createDSpaceObject(Context context, DSpaceObject parent, int type, String handle, PackageParameters params) throws AuthorizeException, SQLException, IOException {
        DSpaceObject dso = null;
        switch (type) {
            case 3: {
                dso = ((Community)parent).createCollection(handle);
                return dso;
            }
            case 4: {
                dso = parent == null || parent.getType() == 5 ? Community.create(null, context, handle) : ((Community)parent).createSubcommunity(handle);
                return dso;
            }
            case 2: {
                WorkspaceItem wsi = WorkspaceItem.create(context, (Collection)parent, params.useCollectionTemplate());
                dso = PackageUtils.finishCreateItem(context, wsi, handle, params);
                return dso;
            }
            case 5: {
                return Site.find(context, 0);
            }
        }
        return null;
    }

    public static Item finishCreateItem(Context context, WorkspaceItem wsi, String handle, PackageParameters params) throws IOException, SQLException, AuthorizeException {
        if (params.restoreModeEnabled()) {
            InstallItem.restoreItem(context, wsi, handle);
            return wsi.getItem();
        }
        if (params.workflowEnabled()) {
            WorkflowItem wfi = WorkflowManager.startWithoutNotify(context, wsi);
            return wfi.getItem();
        }
        InstallItem.installItem(context, wsi, handle);
        return wsi.getItem();
    }

    public static void updateDSpaceObject(DSpaceObject dso) throws AuthorizeException, SQLException, IOException {
        if (dso != null) {
            switch (dso.getType()) {
                case 0: {
                    ((Bitstream)dso).update();
                    break;
                }
                case 2: {
                    ((Item)dso).update();
                    break;
                }
                case 3: {
                    ((Collection)dso).update();
                    break;
                }
                case 4: {
                    ((Community)dso).update();
                }
            }
        }
    }

    public static String getFileExtension(String filename) {
        String extension = filename;
        int lastDot = filename.lastIndexOf(46);
        if (lastDot != -1) {
            extension = filename.substring(lastDot + 1);
        }
        return extension;
    }

    public static String getPackageName(DSpaceObject dso, String fileExtension) {
        String handle = dso.getHandle();
        handle = handle == null || handle.isEmpty() ? "internal-id-" + dso.getID() : handle.replace("/", "-");
        int typeID = dso.getType();
        String type = Constants.typeText[typeID];
        if (!fileExtension.startsWith(".")) {
            fileExtension = "." + fileExtension;
        }
        return type + "@" + handle + fileExtension;
    }

    public static boolean createFile(File file) throws IOException {
        boolean success = false;
        if (!file.exists()) {
            File parentFile = file.getCanonicalFile().getParentFile();
            if (null != parentFile && !parentFile.exists() && !parentFile.mkdirs()) {
                log.error((Object)"Unable to create parent directory");
            }
            success = file.createNewFile();
        }
        return success;
    }

    public static void removeAllBitstreams(DSpaceObject dso) throws SQLException, IOException, AuthorizeException {
        if (dso.getType() == 2) {
            Item item = (Item)dso;
            Bundle[] bunds = item.getBundles();
            for (int i = 0; i < bunds.length; ++i) {
                item.removeBundle(bunds[i]);
            }
        } else if (dso.getType() == 3) {
            Collection collection = (Collection)dso;
            collection.setLogo(null);
        } else if (dso.getType() == 4) {
            Community community = (Community)dso;
            community.setLogo(null);
        }
    }

    public static void clearAllMetadata(DSpaceObject dso) throws SQLException, IOException, AuthorizeException {
        block7: {
            block8: {
                block6: {
                    if (dso.getType() != 2) break block6;
                    Item item = (Item)dso;
                    item.clearMetadata("*", "*", "*", "*");
                    break block7;
                }
                if (dso.getType() != 3) break block8;
                Collection collection = (Collection)dso;
                for (String dbField : ccMetadataToDC.keySet()) {
                    try {
                        collection.setMetadata(dbField, null);
                    }
                    catch (IllegalArgumentException ie) {}
                }
                break block7;
            }
            if (dso.getType() != 4) break block7;
            Community community = (Community)dso;
            for (String dbField : ccMetadataToDC.keySet()) {
                try {
                    community.setMetadata(dbField, null);
                }
                catch (IllegalArgumentException ie) {}
            }
        }
    }

    public static String translateGroupNameForExport(Context context, String groupName) throws PackageException {
        Matcher matched = groupAnalyzer.matcher(groupName);
        if (!matched.matches()) {
            return groupName;
        }
        String objType = matched.group(1);
        String objID = matched.group(2);
        String groupType = matched.group(3);
        try {
            DSpaceObject dso = DSpaceObject.find(context, Constants.getTypeID(objType), Integer.parseInt(objID));
            if (dso == null) {
                String newName;
                if (orphanGroups.containsKey(groupName)) {
                    newName = orphanGroups.get(groupName);
                } else {
                    newName = "GROUP_" + Utils.generateHexKey() + "_" + objType + "_" + groupType;
                    orphanGroups.put(groupName, newName);
                }
                log.warn((Object)("DSpace Object (ID='" + objID + "', type ='" + objType + "') no longer exists -- translating " + groupName + " to " + newName + "."));
                return newName;
            }
            return objType + "_" + "hdl:" + dso.getHandle() + "_" + groupType;
        }
        catch (SQLException sqle) {
            throw new PackageException("Database error while attempting to translate group name ('" + groupName + "') for export.", sqle);
        }
    }

    public static String translateGroupNameForImport(Context context, String groupName) throws PackageException {
        if (!groupName.matches("^.+_.+_.+$")) {
            return groupName;
        }
        String objType = groupName.substring(0, groupName.indexOf(95));
        String tmpEndString = groupName.substring(groupName.indexOf(95) + 1);
        String objID = tmpEndString.substring(0, tmpEndString.indexOf(95));
        String groupType = tmpEndString.substring(tmpEndString.indexOf(95) + 1);
        try {
            if (objID.startsWith("hdl:")) {
                DSpaceObject dso = HandleManager.resolveToObject(context, objID.substring(4));
                if (dso == null) {
                    throw new PackageException("Unable to translate Handle to Internal ID in group named '" + groupName + "' as DSpace Object (Handle='" + objID + "') does not exist.");
                }
                if (Constants.getTypeID(objType) != dso.getType()) {
                    throw new PackageValidationException("DSpace Object referenced by handle '" + objID + "' does not correspond to the object type specified by Group named '" + groupName + "'.  This Group doesn't seem to correspond to this DSpace Object!");
                }
                return objType + "_" + dso.getID() + "_" + groupType;
            }
            return groupName;
        }
        catch (SQLException sqle) {
            throw new PackageException("Database error while attempting to translate group name ('" + groupName + "') for import.", sqle);
        }
    }

    static {
        for (int i = 0; i < ccMetadataMap.length; i += 2) {
            ccMetadataToDC.put(ccMetadataMap[i], ccMetadataMap[i + 1]);
            ccDCToMetadata.put(ccMetadataMap[i + 1], ccMetadataMap[i]);
        }
        groupAnalyzer = Pattern.compile("^(COMMUNITY|COLLECTION)_([0-9]+)_(.+)");
        orphanGroups = new HashMap<String, String>();
    }

    public static class UnclosableInputStream
    extends FilterInputStream {
        public UnclosableInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }
}

