/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.bitstore;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileOutputStream;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.checker.BitstreamInfoDAO;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;

public class BitstreamStorageManager {
    private static Logger log = Logger.getLogger(BitstreamStorageManager.class);
    private static GeneralFile[] assetStores;
    private static int incoming;
    private static final int digitsPerLevel = 2;
    private static final int directoryLevels = 3;
    private static final String REGISTERED_FLAG = "-R";

    public static int store(Context context, InputStream is) throws SQLException, IOException {
        TableRow bitstream;
        String id = Utils.generateKey();
        Context tempContext = null;
        try {
            tempContext = new Context();
            bitstream = DatabaseManager.row("Bitstream");
            bitstream.setColumn("deleted", true);
            bitstream.setColumn("internal_id", id);
            bitstream.setColumn("store_number", incoming);
            DatabaseManager.insert(tempContext, bitstream);
            tempContext.complete();
        }
        catch (SQLException sqle) {
            if (tempContext != null) {
                tempContext.abort();
            }
            throw sqle;
        }
        GeneralFile file = BitstreamStorageManager.getFile(bitstream);
        GeneralFile parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        file.createNewFile();
        GeneralFileOutputStream fos = FileFactory.newFileOutputStream((GeneralFile)file);
        DigestInputStream dis = null;
        try {
            dis = new DigestInputStream(is, MessageDigest.getInstance("MD5"));
        }
        catch (NoSuchAlgorithmException nsae) {
            log.warn((Object)"Caught NoSuchAlgorithmException", (Throwable)nsae);
        }
        Utils.bufferedCopy(dis, (OutputStream)fos);
        fos.close();
        is.close();
        bitstream.setColumn("size_bytes", file.length());
        if (dis != null) {
            bitstream.setColumn("checksum", Utils.toHex(dis.getMessageDigest().digest()));
            bitstream.setColumn("checksum_algorithm", "MD5");
        }
        bitstream.setColumn("deleted", false);
        DatabaseManager.update(context, bitstream);
        int bitstreamId = bitstream.getIntColumn("bitstream_id");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stored bitstream " + bitstreamId + " in file " + file.getAbsolutePath()));
        }
        return bitstreamId;
    }

    public static int register(Context context, int assetstore, String bitstreamPath) throws SQLException, IOException {
        TableRow bitstream;
        String sInternalId = REGISTERED_FLAG + bitstreamPath;
        Context tempContext = null;
        try {
            tempContext = new Context();
            bitstream = DatabaseManager.row("Bitstream");
            bitstream.setColumn("deleted", true);
            bitstream.setColumn("internal_id", sInternalId);
            bitstream.setColumn("store_number", assetstore);
            DatabaseManager.insert(tempContext, bitstream);
            tempContext.complete();
        }
        catch (SQLException sqle) {
            if (tempContext != null) {
                tempContext.abort();
            }
            throw sqle;
        }
        GeneralFile file = BitstreamStorageManager.getFile(bitstream);
        if (file instanceof LocalFile) {
            int count;
            DigestInputStream dis = null;
            try {
                dis = new DigestInputStream((InputStream)FileFactory.newFileInputStream((GeneralFile)file), MessageDigest.getInstance("MD5"));
            }
            catch (NoSuchAlgorithmException e) {
                log.warn((Object)"Caught NoSuchAlgorithmException", (Throwable)e);
                throw new IOException("Invalid checksum algorithm", e);
            }
            catch (IOException e) {
                log.error((Object)("File: " + file.getAbsolutePath() + " to be registered cannot be opened - is it " + "really there?"));
                throw e;
            }
            int BUFFER_SIZE = 4096;
            byte[] buffer = new byte[4096];
            while ((count = dis.read(buffer, 0, 4096)) != -1) {
            }
            bitstream.setColumn("checksum", Utils.toHex(dis.getMessageDigest().digest()));
            dis.close();
        } else if (file instanceof SRBFile) {
            if (!file.exists()) {
                log.error((Object)("File: " + file.getAbsolutePath() + " is not in SRB MCAT"));
                throw new IOException("File is not in SRB MCAT");
            }
            int iLastSlash = bitstreamPath.lastIndexOf(47);
            String sFilename = bitstreamPath.substring(iLastSlash + 1);
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)"Caught NoSuchAlgorithmException", (Throwable)e);
                throw new IOException("Invalid checksum algorithm", e);
            }
            bitstream.setColumn("checksum", Utils.toHex(md.digest(sFilename.getBytes())));
        } else {
            throw new IOException("Unrecognized file type - not local, not SRB");
        }
        bitstream.setColumn("checksum_algorithm", "MD5");
        bitstream.setColumn("size_bytes", file.length());
        bitstream.setColumn("deleted", false);
        DatabaseManager.update(context, bitstream);
        int bitstreamId = bitstream.getIntColumn("bitstream_id");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stored bitstream " + bitstreamId + " in file " + file.getAbsolutePath()));
        }
        return bitstreamId;
    }

    public static boolean isRegisteredBitstream(String internalId) {
        return internalId.substring(0, REGISTERED_FLAG.length()).equals(REGISTERED_FLAG);
    }

    public static InputStream retrieve(Context context, int id) throws SQLException, IOException {
        TableRow bitstream = DatabaseManager.find(context, "bitstream", id);
        GeneralFile file = BitstreamStorageManager.getFile(bitstream);
        return file != null ? FileFactory.newFileInputStream((GeneralFile)file) : null;
    }

    public static void delete(Context context, int id) throws SQLException {
        DatabaseManager.updateQuery(context, "update Bundle set primary_bitstream_id=null where primary_bitstream_id = ? ", id);
        DatabaseManager.updateQuery(context, "update Bitstream set deleted = '1' where bitstream_id = ? ", id);
    }

    public static void cleanup(boolean deleteDbRecords, boolean verbose) throws SQLException, IOException {
        Context context = null;
        BitstreamInfoDAO bitstreamInfoDAO = new BitstreamInfoDAO();
        int commitCounter = 0;
        try {
            context = new Context();
            String myQuery = "select * from Bitstream where deleted = '1'";
            List<TableRow> storage = DatabaseManager.queryTable(context, "Bitstream", myQuery, new Object[0]).toList();
            for (TableRow row : storage) {
                int bid = row.getIntColumn("bitstream_id");
                GeneralFile file = BitstreamStorageManager.getFile(row);
                if (file == null || !file.exists()) {
                    log.debug((Object)"file is null");
                    if (!deleteDbRecords) continue;
                    log.debug((Object)"deleting record");
                    if (verbose) {
                        System.out.println(" - Deleting bitstream information (ID: " + bid + ")");
                    }
                    bitstreamInfoDAO.deleteBitstreamInfoWithHistory(bid);
                    if (verbose) {
                        System.out.println(" - Deleting bitstream record from database (ID: " + bid + ")");
                    }
                    DatabaseManager.delete(context, "Bitstream", bid);
                    continue;
                }
                if (BitstreamStorageManager.isRecent(file)) {
                    log.debug((Object)"file is recent");
                    continue;
                }
                if (deleteDbRecords) {
                    log.debug((Object)"deleting db record");
                    if (verbose) {
                        System.out.println(" - Deleting bitstream information (ID: " + bid + ")");
                    }
                    bitstreamInfoDAO.deleteBitstreamInfoWithHistory(bid);
                    if (verbose) {
                        System.out.println(" - Deleting bitstream record from database (ID: " + bid + ")");
                    }
                    DatabaseManager.delete(context, "Bitstream", bid);
                }
                if (BitstreamStorageManager.isRegisteredBitstream(row.getStringColumn("internal_id"))) continue;
                boolean success = file.delete();
                String message = "Deleted bitstream " + bid + " (file " + file.getAbsolutePath() + ") with result " + success;
                if (log.isDebugEnabled()) {
                    log.debug((Object)message);
                }
                if (verbose) {
                    System.out.println(message);
                }
                if (success) {
                    BitstreamStorageManager.deleteParents(file);
                }
                if (++commitCounter % 100 != 0) continue;
                System.out.print("Committing changes to the database...");
                context.commit();
                System.out.println(" Done!");
            }
            context.complete();
        }
        catch (SQLException sqle) {
            if (verbose) {
                System.err.println("Error: " + sqle.getMessage());
            }
            context.abort();
            throw sqle;
        }
        catch (IOException ioe) {
            if (verbose) {
                System.err.println("Error: " + ioe.getMessage());
            }
            context.abort();
            throw ioe;
        }
    }

    private static boolean isRecent(GeneralFile file) {
        long now;
        long lastmod = file.lastModified();
        if (lastmod >= (now = new Date().getTime())) {
            return true;
        }
        return now - lastmod < 60000L;
    }

    private static synchronized void deleteParents(GeneralFile file) {
        GeneralFile directory;
        GeneralFile[] files;
        if (file == null) {
            return;
        }
        GeneralFile tmp = file;
        for (int i = 0; i < 3 && (files = (directory = tmp.getParentFile()).listFiles()).length == 0; ++i) {
            directory.delete();
            tmp = directory;
        }
    }

    private static GeneralFile getFile(TableRow bitstream) throws IOException {
        if (bitstream == null) {
            return null;
        }
        int storeNumber = bitstream.getIntColumn("store_number");
        if (storeNumber == -1) {
            storeNumber = 0;
        }
        GeneralFile assetstore = assetStores[storeNumber];
        String sInternalId = bitstream.getStringColumn("internal_id");
        String sIntermediatePath = null;
        if (BitstreamStorageManager.isRegisteredBitstream(sInternalId)) {
            sInternalId = sInternalId.substring(REGISTERED_FLAG.length());
            sIntermediatePath = "";
        } else {
            if (sInternalId.indexOf(File.separator) != -1) {
                sInternalId = sInternalId.substring(sInternalId.lastIndexOf(File.separator) + 1);
            }
            sIntermediatePath = BitstreamStorageManager.getIntermediatePath(sInternalId);
        }
        StringBuffer bufFilename = new StringBuffer();
        if (assetstore instanceof LocalFile) {
            bufFilename.append(assetstore.getCanonicalPath());
            bufFilename.append(File.separator);
            bufFilename.append(sIntermediatePath);
            bufFilename.append(sInternalId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Local filename for " + sInternalId + " is " + bufFilename.toString()));
            }
            return new LocalFile(bufFilename.toString());
        }
        if (assetstore instanceof SRBFile) {
            bufFilename.append(sIntermediatePath);
            bufFilename.append(sInternalId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("SRB filename for " + sInternalId + " is " + ((SRBFile)assetstore).toString() + bufFilename.toString()));
            }
            return new SRBFile((SRBFile)assetstore, bufFilename.toString());
        }
        return null;
    }

    private static String getIntermediatePath(String iInternalId) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 3; ++i) {
            int digits = i * 2;
            if (i > 0) {
                buf.append(File.separator);
            }
            buf.append(iInternalId.substring(digits, digits + 2));
        }
        buf.append(File.separator);
        return buf.toString();
    }

    static {
        ArrayList<String> stores = new ArrayList<String>();
        String sAssetstoreDir = ConfigurationManager.getProperty("assetstore.dir");
        if (sAssetstoreDir != null) {
            stores.add(sAssetstoreDir);
        } else if (ConfigurationManager.getProperty("srb.host") != null) {
            stores.add((String)new SRBAccount(ConfigurationManager.getProperty("srb.host"), ConfigurationManager.getIntProperty("srb.port"), ConfigurationManager.getProperty("srb.username"), ConfigurationManager.getProperty("srb.password"), ConfigurationManager.getProperty("srb.homedirectory"), ConfigurationManager.getProperty("srb.mdasdomainname"), ConfigurationManager.getProperty("srb.defaultstorageresource"), ConfigurationManager.getProperty("srb.mcatzone")));
        } else {
            log.error((Object)"No default assetstore");
        }
        int i = 1;
        while (true) {
            if ((sAssetstoreDir = ConfigurationManager.getProperty("assetstore.dir." + i)) != null) {
                stores.add(sAssetstoreDir);
            } else {
                if (ConfigurationManager.getProperty("srb.host." + i) == null) break;
                stores.add((String)new SRBAccount(ConfigurationManager.getProperty("srb.host." + i), ConfigurationManager.getIntProperty("srb.port." + i), ConfigurationManager.getProperty("srb.username." + i), ConfigurationManager.getProperty("srb.password." + i), ConfigurationManager.getProperty("srb.homedirectory." + i), ConfigurationManager.getProperty("srb.mdasdomainname." + i), ConfigurationManager.getProperty("srb.defaultstorageresource." + i), ConfigurationManager.getProperty("srb.mcatzone." + i)));
            }
            ++i;
        }
        assetStores = new GeneralFile[stores.size()];
        for (i = 0; i < stores.size(); ++i) {
            Object o = stores.get(i);
            if (o == null) {
                log.error((Object)("Problem with assetstore " + i));
            }
            if (o instanceof String) {
                BitstreamStorageManager.assetStores[i] = new LocalFile((String)o);
                continue;
            }
            if (o instanceof SRBAccount) {
                SRBFileSystem srbFileSystem = null;
                try {
                    srbFileSystem = new SRBFileSystem((SRBAccount)o);
                }
                catch (NullPointerException e) {
                    log.error((Object)("No SRBAccount for assetstore " + i));
                }
                catch (IOException e) {
                    log.error((Object)("Problem getting SRBFileSystem for assetstore" + i));
                }
                if (srbFileSystem == null) {
                    log.error((Object)("SRB FileSystem is null for assetstore " + i));
                }
                String sSRBAssetstore = null;
                sSRBAssetstore = i == 0 ? ConfigurationManager.getProperty("srb.parentdir") : ConfigurationManager.getProperty("srb.parentdir." + i);
                if (sSRBAssetstore == null) {
                    log.error((Object)("srb.parentdir is undefined for assetstore " + i));
                }
                BitstreamStorageManager.assetStores[i] = new SRBFile(srbFileSystem, sSRBAssetstore);
                continue;
            }
            log.error((Object)("Unexpected " + o.getClass().toString() + " with assetstore " + i));
        }
        incoming = ConfigurationManager.getIntProperty("assetstore.incoming");
    }
}

