/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.embargo;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DCDate;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.embargo.EmbargoManager;
import org.dspace.embargo.EmbargoSetter;

public class DefaultEmbargoSetter
implements EmbargoSetter {
    protected String termsOpen = ConfigurationManager.getProperty("embargo.terms.open");

    @Override
    public DCDate parseTerms(Context context, Item item, String terms) throws SQLException, AuthorizeException, IOException {
        if (terms != null && terms.length() > 0) {
            if (this.termsOpen.equals(terms)) {
                return EmbargoManager.FOREVER;
            }
            return new DCDate(terms);
        }
        return null;
    }

    @Override
    public void setEmbargo(Context context, Item item) throws SQLException, AuthorizeException, IOException {
        for (Bundle bn : item.getBundles()) {
            String bnn = bn.getName();
            if (bnn.equals("LICENSE") || bnn.equals("METADATA")) continue;
            AuthorizeManager.removePoliciesActionFilter(context, bn, 0);
            for (Bitstream bs : bn.getBitstreams()) {
                AuthorizeManager.removePoliciesActionFilter(context, bs, 0);
            }
        }
    }

    @Override
    public void checkEmbargo(Context context, Item item) throws SQLException, AuthorizeException, IOException {
        for (Bundle bn : item.getBundles()) {
            String bnn = bn.getName();
            if (bnn.equals("LICENSE") || bnn.equals("METADATA")) continue;
            if (!bnn.equals("TEXT") && !bnn.equals("THUMBNAIL")) {
                for (ResourcePolicy rp : AuthorizeManager.getPoliciesActionFilter(context, bn, 0)) {
                    System.out.println("CHECK WARNING: Item " + item.getHandle() + ", Bundle " + bn.getName() + " allows READ by " + (rp.getEPersonID() < 0 ? "Group " + rp.getGroup().getName() : "EPerson " + rp.getEPerson().getFullName()));
                }
            }
            for (Bitstream bs : bn.getBitstreams()) {
                for (ResourcePolicy rp : AuthorizeManager.getPoliciesActionFilter(context, bs, 0)) {
                    System.out.println("CHECK WARNING: Item " + item.getHandle() + ", Bitstream " + bs.getName() + " (in Bundle " + bn.getName() + ") allows READ by " + (rp.getEPersonID() < 0 ? "Group " + rp.getGroup().getName() : "EPerson " + rp.getEPerson().getFullName()));
                }
            }
        }
    }
}

