/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.administer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.xpath.XPathAPI;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StructBuilder {
    private static Document xmlOutput = new Document(new Element("imported_structure"));
    private static Map<String, String> collectionMap = new HashMap<String, String>();
    private static Map<String, String> communityMap = new HashMap<String, String>();

    public static void main(String[] argv) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("f", "file", true, "file");
        options.addOption("e", "eperson", true, "eperson");
        options.addOption("o", "output", true, "output");
        CommandLine line = parser.parse(options, argv);
        String file = null;
        String eperson = null;
        String output = null;
        if (line.hasOption('f')) {
            file = line.getOptionValue('f');
        }
        if (line.hasOption('e')) {
            eperson = line.getOptionValue('e');
        }
        if (line.hasOption('o')) {
            output = line.getOptionValue('o');
        }
        if (output == null || eperson == null || file == null) {
            StructBuilder.usage();
            System.exit(0);
        }
        Context context = new Context();
        context.setCurrentUser(EPerson.findByEmail(context, eperson));
        org.w3c.dom.Document document = StructBuilder.loadXML(file);
        StructBuilder.validate(document);
        communityMap.put("name", "name");
        communityMap.put("description", "short_description");
        communityMap.put("intro", "introductory_text");
        communityMap.put("copyright", "copyright_text");
        communityMap.put("sidebar", "side_bar_text");
        collectionMap.put("name", "name");
        collectionMap.put("description", "short_description");
        collectionMap.put("intro", "introductory_text");
        collectionMap.put("copyright", "copyright_text");
        collectionMap.put("sidebar", "side_bar_text");
        collectionMap.put("license", "license");
        collectionMap.put("provenance", "provenance_description");
        NodeList first = XPathAPI.selectNodeList((Node)document, (String)"/import_structure/community");
        Element[] elements = StructBuilder.handleCommunities(context, first, null);
        Element root = xmlOutput.getRootElement();
        for (int i = 0; i < elements.length; ++i) {
            root.addContent((Content)elements[i]);
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(output));
            out.write(new XMLOutputter().outputString(xmlOutput));
            out.close();
        }
        catch (IOException e) {
            System.out.println("Unable to write to output file " + output);
            System.exit(0);
        }
        context.complete();
    }

    private static void usage() {
        System.out.println("Usage: java StructBuilder -f <source XML file> -o <output file> -e <eperson email>");
        System.out.println("Communities will be created from the top level, and a map of communities to handles will be returned in the output file");
    }

    private static void validate(org.w3c.dom.Document document) throws TransformerException {
        String errs;
        StringBuffer err = new StringBuffer();
        boolean trip = false;
        err.append("The following errors were encountered parsing the source XML\n");
        err.append("No changes have been made to the DSpace instance\n\n");
        NodeList first = XPathAPI.selectNodeList((Node)document, (String)"/import_structure/community");
        if (first.getLength() == 0) {
            err.append("-There are no top level communities in the source document");
            System.out.println(err.toString());
            System.exit(0);
        }
        if ((errs = StructBuilder.validateCommunities(first, 1)) != null) {
            err.append(errs);
            trip = true;
        }
        if (trip) {
            System.out.println(err.toString());
            System.exit(0);
        }
    }

    private static String validateCommunities(NodeList communities, int level) throws TransformerException {
        StringBuffer err = new StringBuffer();
        boolean trip = false;
        String errs = null;
        for (int i = 0; i < communities.getLength(); ++i) {
            NodeList collections;
            String colErrs;
            NodeList subCommunities;
            String comErrs;
            Node n = communities.item(i);
            NodeList name = XPathAPI.selectNodeList((Node)n, (String)"name");
            if (name.getLength() != 1) {
                String pos = Integer.toString(i + 1);
                err.append("-The level " + level + " community in position " + pos);
                err.append(" does not contain exactly one name field\n");
                trip = true;
            }
            if ((comErrs = StructBuilder.validateCommunities(subCommunities = XPathAPI.selectNodeList((Node)n, (String)"community"), level + 1)) != null) {
                err.append(comErrs);
                trip = true;
            }
            if ((colErrs = StructBuilder.validateCollections(collections = XPathAPI.selectNodeList((Node)n, (String)"collection"), level + 1)) == null) continue;
            err.append(colErrs);
            trip = true;
        }
        if (trip) {
            errs = err.toString();
        }
        return errs;
    }

    private static String validateCollections(NodeList collections, int level) throws TransformerException {
        StringBuffer err = new StringBuffer();
        boolean trip = false;
        String errs = null;
        for (int i = 0; i < collections.getLength(); ++i) {
            Node n = collections.item(i);
            NodeList name = XPathAPI.selectNodeList((Node)n, (String)"name");
            if (name.getLength() == 1) continue;
            String pos = Integer.toString(i + 1);
            err.append("-The level " + level + " collection in position " + pos);
            err.append(" does not contain exactly one name field\n");
            trip = true;
        }
        if (trip) {
            errs = err.toString();
        }
        return errs;
    }

    private static org.w3c.dom.Document loadXML(String filename) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        org.w3c.dom.Document document = builder.parse(new File(filename));
        return document;
    }

    public static String getStringValue(Node node) {
        Node first;
        String value = node.getNodeValue();
        if (node.hasChildNodes() && (first = node.getFirstChild()).getNodeType() == 3) {
            return first.getNodeValue().trim();
        }
        return value;
    }

    private static Element[] handleCommunities(Context context, NodeList communities, Community parent) throws TransformerException, SQLException, Exception {
        Element[] elements = new Element[communities.getLength()];
        for (int i = 0; i < communities.getLength(); ++i) {
            int j;
            Element element = new Element("community");
            Community community = parent != null ? parent.createSubcommunity() : Community.create(null, context);
            community.setMetadata("short_description", " ");
            Node tn = communities.item(i);
            for (Map.Entry<String, String> entry : communityMap.entrySet()) {
                NodeList nl = XPathAPI.selectNodeList((Node)tn, (String)entry.getKey());
                if (nl.getLength() != 1) continue;
                community.setMetadata(entry.getValue(), StructBuilder.getStringValue(nl.item(0)));
            }
            community.update();
            element.setAttribute("identifier", community.getHandle());
            Element nameElement = new Element("name");
            nameElement.setText(community.getMetadata("name"));
            element.addContent((Content)nameElement);
            if (community.getMetadata("short_description") != null) {
                Element descriptionElement = new Element("description");
                descriptionElement.setText(community.getMetadata("short_description"));
                element.addContent((Content)descriptionElement);
            }
            if (community.getMetadata("introductory_text") != null) {
                Element introElement = new Element("intro");
                introElement.setText(community.getMetadata("introductory_text"));
                element.addContent((Content)introElement);
            }
            if (community.getMetadata("copyright_text") != null) {
                Element copyrightElement = new Element("copyright");
                copyrightElement.setText(community.getMetadata("copyright_text"));
                element.addContent((Content)copyrightElement);
            }
            if (community.getMetadata("side_bar_text") != null) {
                Element sidebarElement = new Element("sidebar");
                sidebarElement.setText(community.getMetadata("side_bar_text"));
                element.addContent((Content)sidebarElement);
            }
            NodeList subCommunities = XPathAPI.selectNodeList((Node)tn, (String)"community");
            Element[] subCommunityElements = StructBuilder.handleCommunities(context, subCommunities, community);
            NodeList collections = XPathAPI.selectNodeList((Node)tn, (String)"collection");
            Element[] collectionElements = StructBuilder.handleCollections(context, collections, community);
            for (j = 0; j < subCommunityElements.length; ++j) {
                element.addContent((Content)subCommunityElements[j]);
            }
            for (j = 0; j < collectionElements.length; ++j) {
                element.addContent((Content)collectionElements[j]);
            }
            elements[i] = element;
        }
        return elements;
    }

    private static Element[] handleCollections(Context context, NodeList collections, Community parent) throws TransformerException, SQLException, AuthorizeException, IOException, Exception {
        Element[] elements = new Element[collections.getLength()];
        for (int i = 0; i < collections.getLength(); ++i) {
            Element sidebarElement;
            Element element = new Element("collection");
            Collection collection = parent.createCollection();
            collection.setMetadata("short_description", " ");
            Node tn = collections.item(i);
            for (Map.Entry<String, String> entry : collectionMap.entrySet()) {
                NodeList nl = XPathAPI.selectNodeList((Node)tn, (String)entry.getKey());
                if (nl.getLength() != 1) continue;
                collection.setMetadata(entry.getValue(), StructBuilder.getStringValue(nl.item(0)));
            }
            collection.update();
            element.setAttribute("identifier", collection.getHandle());
            Element nameElement = new Element("name");
            nameElement.setText(collection.getMetadata("name"));
            element.addContent((Content)nameElement);
            if (collection.getMetadata("short_description") != null) {
                Element descriptionElement = new Element("description");
                descriptionElement.setText(collection.getMetadata("short_description"));
                element.addContent((Content)descriptionElement);
            }
            if (collection.getMetadata("introductory_text") != null) {
                Element introElement = new Element("intro");
                introElement.setText(collection.getMetadata("introductory_text"));
                element.addContent((Content)introElement);
            }
            if (collection.getMetadata("copyright_text") != null) {
                Element copyrightElement = new Element("copyright");
                copyrightElement.setText(collection.getMetadata("copyright_text"));
                element.addContent((Content)copyrightElement);
            }
            if (collection.getMetadata("side_bar_text") != null) {
                sidebarElement = new Element("sidebar");
                sidebarElement.setText(collection.getMetadata("side_bar_text"));
                element.addContent((Content)sidebarElement);
            }
            if (collection.getMetadata("license") != null) {
                sidebarElement = new Element("license");
                sidebarElement.setText(collection.getMetadata("license"));
                element.addContent((Content)sidebarElement);
            }
            if (collection.getMetadata("provenance_description") != null) {
                sidebarElement = new Element("provenance");
                sidebarElement.setText(collection.getMetadata("provenance_description"));
                element.addContent((Content)sidebarElement);
            }
            elements[i] = element;
        }
        return elements;
    }
}

