/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Category;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggerRepository;
import org.dspace.core.Email;

public class ConfigurationManager {
    private static Logger log = Logger.getLogger(ConfigurationManager.class);
    private static Properties properties = null;
    private static Map<String, Properties> moduleProps = null;
    private static String license;
    private static final int RECURSION_LIMIT = 9;
    private static File loadedFile;

    protected ConfigurationManager() {
    }

    public static boolean isConfigured() {
        return properties != null;
    }

    public static boolean isConfigured(String module) {
        return moduleProps.get(module) != null;
    }

    public static Properties getProperties() {
        Properties props = ConfigurationManager.getMutableProperties();
        return props == null ? null : (Properties)props.clone();
    }

    private static Properties getMutableProperties() {
        if (properties == null) {
            ConfigurationManager.loadConfig(null);
        }
        return properties;
    }

    public static Properties getProperties(String module) {
        Properties props = ConfigurationManager.getMutableProperties(module);
        return props == null ? null : (Properties)props.clone();
    }

    private static Properties getMutableProperties(String module) {
        Properties retProps;
        Properties properties = retProps = module != null ? moduleProps.get(module) : ConfigurationManager.properties;
        if (retProps == null) {
            ConfigurationManager.loadModuleConfig(module);
            retProps = moduleProps.get(module);
        }
        return retProps;
    }

    public static String getProperty(String property) {
        Properties props = ConfigurationManager.getMutableProperties();
        String value = props == null ? null : props.getProperty(property);
        return value != null ? value.trim() : null;
    }

    public static String getProperty(String module, String property) {
        if (module == null) {
            return ConfigurationManager.getProperty(property);
        }
        String value = null;
        Properties modProps = ConfigurationManager.getMutableProperties(module);
        if (modProps != null) {
            value = modProps.getProperty(property);
        }
        if (value == null) {
            value = ConfigurationManager.getProperty(module + "." + property);
        }
        return value != null ? value.trim() : null;
    }

    public static int getIntProperty(String property) {
        return ConfigurationManager.getIntProperty(property, 0);
    }

    public static int getIntProperty(String module, String property) {
        return ConfigurationManager.getIntProperty(module, property, 0);
    }

    public static int getIntProperty(String property, int defaultValue) {
        return ConfigurationManager.getIntProperty(null, property, defaultValue);
    }

    public static int getIntProperty(String module, String property, int defaultValue) {
        String stringValue = ConfigurationManager.getProperty(module, property);
        int intValue = defaultValue;
        if (stringValue != null) {
            try {
                intValue = Integer.parseInt(stringValue.trim());
            }
            catch (NumberFormatException e) {
                ConfigurationManager.warn("Warning: Number format error in property: " + property);
            }
        }
        return intValue;
    }

    public static long getLongProperty(String property) {
        return ConfigurationManager.getLongProperty(property, 0);
    }

    public static long getLongProperty(String module, String property) {
        return ConfigurationManager.getLongProperty(module, property, 0);
    }

    public static long getLongProperty(String property, int defaultValue) {
        return ConfigurationManager.getLongProperty(null, property, defaultValue);
    }

    public static long getLongProperty(String module, String property, int defaultValue) {
        String stringValue = ConfigurationManager.getProperty(module, property);
        long longValue = defaultValue;
        if (stringValue != null) {
            try {
                longValue = Long.parseLong(stringValue.trim());
            }
            catch (NumberFormatException e) {
                ConfigurationManager.warn("Warning: Number format error in property: " + property);
            }
        }
        return longValue;
    }

    public static String getLicenseText(String licenseFile) {
        FileReader fr = null;
        BufferedReader br = null;
        try {
            String lineIn;
            fr = new FileReader(licenseFile);
            br = new BufferedReader(fr);
            license = "";
            while ((lineIn = br.readLine()) != null) {
                license = license + lineIn + '\n';
            }
        }
        catch (IOException e) {
            ConfigurationManager.fatal("Can't load configuration", e);
            throw new IllegalStateException("Failed to read default license.", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {}
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException ioe) {}
            }
        }
        return license;
    }

    public static boolean getBooleanProperty(String property) {
        return ConfigurationManager.getBooleanProperty(property, false);
    }

    public static boolean getBooleanProperty(String module, String property) {
        return ConfigurationManager.getBooleanProperty(module, property, false);
    }

    public static boolean getBooleanProperty(String property, boolean defaultValue) {
        return ConfigurationManager.getBooleanProperty(null, property, defaultValue);
    }

    public static boolean getBooleanProperty(String module, String property, boolean defaultValue) {
        String stringValue = ConfigurationManager.getProperty(module, property);
        if (stringValue != null) {
            return (stringValue = stringValue.trim()).equalsIgnoreCase("true") || stringValue.equalsIgnoreCase("yes");
        }
        return defaultValue;
    }

    public static Enumeration<?> propertyNames() {
        return ConfigurationManager.propertyNames(null);
    }

    public static Enumeration<?> propertyNames(String module) {
        Properties props = ConfigurationManager.getProperties(module);
        return props == null ? null : props.propertyNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Email getEmail(String emailFile) throws IOException {
        String charset = null;
        String subject = "";
        StringBuffer contentBuffer = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(emailFile));
            boolean more = true;
            while (more) {
                String line = reader.readLine();
                if (line == null) {
                    more = false;
                    continue;
                }
                if (line.toLowerCase().startsWith("subject:")) {
                    subject = line.substring(8).trim();
                    continue;
                }
                if (line.toLowerCase().startsWith("charset:")) {
                    charset = line.substring(8).trim();
                    continue;
                }
                if (line.startsWith("#")) continue;
                contentBuffer.append(line);
                contentBuffer.append("\n");
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        Email email = new Email();
        email.setSubject(subject);
        email.setContent(contentBuffer.toString());
        if (charset != null) {
            email.setCharset(charset);
        }
        return email;
    }

    public static String getDefaultSubmissionLicense() {
        if (properties == null) {
            ConfigurationManager.loadConfig(null);
        }
        return license;
    }

    public static String getNewsFilePath() {
        String filePath = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator;
        return filePath;
    }

    public static String readNewsFile(String newsFile) {
        String fileName = ConfigurationManager.getNewsFilePath();
        fileName = fileName + newsFile;
        StringBuilder text = new StringBuilder();
        try {
            String lineIn;
            FileInputStream fir = new FileInputStream(fileName);
            InputStreamReader ir = new InputStreamReader((InputStream)fir, "UTF-8");
            BufferedReader br = new BufferedReader(ir);
            while ((lineIn = br.readLine()) != null) {
                text.append(lineIn);
            }
            br.close();
        }
        catch (IOException e) {
            ConfigurationManager.warn("news_read: " + e.getLocalizedMessage());
        }
        return text.toString();
    }

    public static String writeNewsFile(String newsFile, String news) {
        String fileName = ConfigurationManager.getNewsFilePath();
        fileName = fileName + newsFile;
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            OutputStreamWriter osr = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            PrintWriter out = new PrintWriter(osr);
            out.print(news);
            out.close();
        }
        catch (IOException e) {
            ConfigurationManager.warn("news_write: " + e.getLocalizedMessage());
        }
        return news;
    }

    public static void writeLicenseFile(String licenseFile, String newLicense) {
        try {
            FileOutputStream fos = new FileOutputStream(licenseFile);
            OutputStreamWriter osr = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            PrintWriter out = new PrintWriter(osr);
            out.print(newLicense);
            out.close();
        }
        catch (IOException e) {
            ConfigurationManager.warn("license_write: " + e.getLocalizedMessage());
        }
        license = newLicense;
    }

    protected static File getConfigurationFile() {
        if (loadedFile == null) {
            ConfigurationManager.loadConfig(null);
        }
        return loadedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadModuleConfig(String module) {
        block9: {
            File modFile = null;
            try {
                modFile = new File(ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator + "modules" + File.separator + module + ".cfg");
                if (modFile.exists()) {
                    Properties modProps = new Properties();
                    FileInputStream modIS = null;
                    try {
                        modIS = new FileInputStream(modFile);
                        modProps.load(modIS);
                    }
                    finally {
                        if (modIS != null) {
                            ((InputStream)modIS).close();
                        }
                    }
                    Enumeration<?> pe = modProps.propertyNames();
                    while (pe.hasMoreElements()) {
                        String key = (String)pe.nextElement();
                        String ival = ConfigurationManager.interpolate(key, modProps.getProperty(key), 1);
                        if (ival == null) continue;
                        modProps.setProperty(key, ival);
                    }
                    moduleProps.put(module, modProps);
                    break block9;
                }
                ConfigurationManager.warn("Requested configuration module: " + module + " not found");
            }
            catch (IOException ioE) {
                ConfigurationManager.fatal("Can't load configuration: " + (modFile == null ? "<unknown>" : modFile.getAbsolutePath()), ioE);
            }
        }
    }

    public static synchronized void loadConfig(String configFile) {
        if (properties != null) {
            return;
        }
        URL url = null;
        InputStream is = null;
        try {
            String configProperty = null;
            try {
                configProperty = System.getProperty("dspace.configuration");
            }
            catch (SecurityException se) {
                log.warn((Object)"Unable to access system properties, ignoring.", (Throwable)se);
            }
            if (loadedFile != null) {
                ConfigurationManager.info("Reloading current config file: " + loadedFile.getAbsolutePath());
                url = loadedFile.toURI().toURL();
            } else if (configFile != null) {
                ConfigurationManager.info("Loading provided config file: " + configFile);
                loadedFile = new File(configFile);
                url = loadedFile.toURI().toURL();
            } else if (configProperty != null) {
                ConfigurationManager.info("Loading system provided config property (-Ddspace.configuration): " + configProperty);
                loadedFile = new File(configProperty);
                url = loadedFile.toURI().toURL();
            } else {
                url = ConfigurationManager.class.getResource("/dspace.cfg");
                if (url != null) {
                    ConfigurationManager.info("Loading from classloader: " + url);
                    loadedFile = new File(url.getPath());
                }
            }
            if (url == null) {
                ConfigurationManager.fatal("Cannot find dspace.cfg");
                throw new IllegalStateException("Cannot find dspace.cfg");
            }
            properties = new Properties();
            moduleProps = new HashMap<String, Properties>();
            is = url.openStream();
            properties.load(is);
            Enumeration<?> pe = properties.propertyNames();
            while (pe.hasMoreElements()) {
                String key = (String)pe.nextElement();
                String value = ConfigurationManager.interpolate(key, properties.getProperty(key), 1);
                if (value == null) continue;
                properties.setProperty(key, value);
            }
        }
        catch (IOException e) {
            ConfigurationManager.fatal("Can't load configuration: " + url, e);
            throw new IllegalStateException("Cannot load configuration: " + url, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
        File licenseFile = new File(ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator + "default.license");
        FileInputStream fir = null;
        InputStreamReader ir = null;
        BufferedReader br = null;
        try {
            String lineIn;
            fir = new FileInputStream(licenseFile);
            ir = new InputStreamReader((InputStream)fir, "UTF-8");
            br = new BufferedReader(ir);
            license = "";
            while ((lineIn = br.readLine()) != null) {
                license = license + lineIn + '\n';
            }
            br.close();
        }
        catch (IOException e) {
            ConfigurationManager.fatal("Can't load license: " + licenseFile.toString(), e);
            throw new IllegalStateException("Cannot load license: " + licenseFile.toString(), e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {}
            }
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (IOException ioe) {}
            }
            if (fir != null) {
                try {
                    fir.close();
                }
                catch (IOException ioe) {}
            }
        }
        try {
            String dsLogConfiguration = ConfigurationManager.getProperty("log.init.config");
            if (dsLogConfiguration == null || System.getProperty("dspace.log.init.disable") != null) {
                ConfigurationManager.info("Using default log4j provided log configuration,if unintended, check your dspace.cfg for (log.init.config)");
            } else {
                ConfigurationManager.info("Using dspace provided log configuration (log.init.config)");
                File logConfigFile = new File(dsLogConfiguration);
                if (logConfigFile.exists()) {
                    ConfigurationManager.info("Loading: " + dsLogConfiguration);
                    OptionConverter.selectAndConfigure((URL)logConfigFile.toURI().toURL(), null, (LoggerRepository)LogManager.getLoggerRepository());
                } else {
                    ConfigurationManager.info("File does not exist: " + dsLogConfiguration);
                }
            }
        }
        catch (MalformedURLException e) {
            ConfigurationManager.fatal("Can't load dspace provided log4j configuration", e);
            throw new IllegalStateException("Cannot load dspace provided log4j configuration", e);
        }
    }

    private static String interpolate(String key, String value, int level) {
        int end;
        int start;
        if (level > 9) {
            throw new IllegalArgumentException("ConfigurationManager: Too many levels of recursion in configuration property variable interpolation, property=" + key);
        }
        int from = 0;
        StringBuffer result = null;
        while (from < value.length() && (start = value.indexOf("${", from)) >= 0 && (end = value.indexOf(125, start)) >= 0) {
            String var = value.substring(start + 2, end);
            if (result == null) {
                result = new StringBuffer(value.substring(from, start));
            } else {
                result.append(value.substring(from, start));
            }
            if (properties.containsKey(var)) {
                String ivalue = ConfigurationManager.interpolate(var, properties.getProperty(var), level + 1);
                if (ivalue != null) {
                    result.append(ivalue);
                    properties.setProperty(var, ivalue);
                } else {
                    result.append(properties.getProperty(var));
                }
            } else {
                log.warn((Object)("Interpolation failed in value of property \"" + key + "\", there is no property named \"" + var + "\""));
            }
            from = end + 1;
        }
        if (result != null && from < value.length()) {
            result.append(value.substring(from));
        }
        return result == null ? null : result.toString();
    }

    public static void main(String[] argv) {
        if (argv.length == 2 && argv[0].equals("-property")) {
            String val = ConfigurationManager.getProperty(argv[1]);
            if (val != null) {
                System.out.println(val);
            } else {
                System.out.println("");
            }
            System.exit(0);
        } else if (argv.length == 4 && argv[0].equals("-module") && argv[2].equals("-property")) {
            String val = ConfigurationManager.getProperty(argv[1], argv[3]);
            if (val != null) {
                System.out.println(val);
            } else {
                System.out.println("");
            }
            System.exit(0);
        } else {
            System.err.println("Usage: ConfigurationManager OPTION\n  [-module mod.name] -property prop.name  get value of prop.name from module or dspace.cfg");
        }
        System.exit(1);
    }

    private static void info(String string) {
        if (!ConfigurationManager.isLog4jConfigured()) {
            System.out.println("INFO: " + string);
        } else {
            log.info((Object)string);
        }
    }

    private static void warn(String string) {
        if (!ConfigurationManager.isLog4jConfigured()) {
            System.out.println("WARN: " + string);
        } else {
            log.warn((Object)string);
        }
    }

    private static void fatal(String string, Exception e) {
        if (!ConfigurationManager.isLog4jConfigured()) {
            System.out.println("FATAL: " + string);
            e.printStackTrace();
        } else {
            log.fatal((Object)string, (Throwable)e);
        }
    }

    private static void fatal(String string) {
        if (!ConfigurationManager.isLog4jConfigured()) {
            System.out.println("FATAL: " + string);
        } else {
            log.fatal((Object)string);
        }
    }

    private static boolean isLog4jConfigured() {
        Enumeration en = LogManager.getRootLogger().getAllAppenders();
        if (!(en instanceof NullEnumeration)) {
            return true;
        }
        Enumeration cats = Category.getCurrentCategories();
        while (cats.hasMoreElements()) {
            Category c = (Category)cats.nextElement();
            if (c.getAllAppenders() instanceof NullEnumeration) continue;
            return true;
        }
        return false;
    }

    static {
        loadedFile = null;
    }
}

