/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.ItemIterator;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.curate.CurationTask;
import org.dspace.curate.Distributive;
import org.dspace.curate.Suspendable;
import org.dspace.curate.TaskQueue;
import org.dspace.curate.TaskQueueEntry;
import org.dspace.handle.HandleManager;

public class Curator {
    public static final int CURATE_NOTASK = -3;
    public static final int CURATE_UNSET = -2;
    public static final int CURATE_ERROR = -1;
    public static final int CURATE_SUCCESS = 0;
    public static final int CURATE_FAIL = 1;
    public static final int CURATE_SKIP = 2;
    private static Logger log = Logger.getLogger(Curator.class);
    private Map<String, TaskRunner> trMap = new HashMap<String, TaskRunner>();
    private List<String> perfList = new ArrayList<String>();
    private TaskQueue taskQ = null;
    private String reporter = null;
    private Invoked iMode = null;

    public Curator addTask(String taskName) {
        CurationTask task = (CurationTask)PluginManager.getNamedPlugin("curate", CurationTask.class, taskName);
        if (task != null) {
            try {
                task.init(this, taskName);
                this.trMap.put(taskName, new TaskRunner(task, taskName));
                this.perfList.add(taskName);
            }
            catch (IOException ioE) {
                log.error((Object)("Task: '" + taskName + "' initialization failure: " + ioE.getMessage()));
            }
        } else {
            log.error((Object)("Task: '" + taskName + "' does not resolve"));
        }
        return this;
    }

    public boolean hasTask(String taskName) {
        return this.perfList.contains(taskName);
    }

    public Curator removeTask(String taskName) {
        this.trMap.remove(taskName);
        this.perfList.remove(taskName);
        return this;
    }

    public Curator setInvoked(Invoked mode) {
        this.iMode = mode;
        return this;
    }

    public Curator setReporter(String reporter) {
        this.reporter = reporter;
        return this;
    }

    public void curate(Context c, String id) throws IOException {
        if (id == null) {
            log.error((Object)"curate - null id");
            return;
        }
        try {
            DSpaceObject dso = HandleManager.resolveToObject(c, id);
            if (dso != null) {
                this.curate(dso);
            } else {
                for (String taskName : this.perfList) {
                    this.trMap.get(taskName).run(c, id);
                }
            }
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE.getMessage(), sqlE);
        }
    }

    public void curate(DSpaceObject dso) throws IOException {
        if (dso == null) {
            log.error((Object)"curate - null dso");
            return;
        }
        int type = dso.getType();
        for (String taskName : this.perfList) {
            TaskRunner tr = this.trMap.get(taskName);
            if (type == 2 || tr.task.getClass().isAnnotationPresent(Distributive.class)) {
                tr.run(dso);
                continue;
            }
            if (type == 3) {
                this.doCollection(tr, (Collection)dso);
                continue;
            }
            if (type != 4) continue;
            this.doCommunity(tr, (Community)dso);
        }
    }

    public void queue(Context c, String id, String queueId) throws IOException {
        if (this.taskQ == null) {
            this.taskQ = (TaskQueue)PluginManager.getSinglePlugin("curate", TaskQueue.class);
        }
        if (this.taskQ != null) {
            this.taskQ.enqueue(queueId, new TaskQueueEntry(c.getCurrentUser().getName(), System.currentTimeMillis(), this.perfList, id));
        } else {
            log.error((Object)"curate - no TaskQueue implemented");
        }
    }

    public void clear() {
        this.trMap.clear();
        this.perfList.clear();
    }

    public void report(String message) {
        if ("-".equals(this.reporter)) {
            System.out.println(message);
        }
    }

    public int getStatus(String taskName) {
        TaskRunner tr = this.trMap.get(taskName);
        return tr != null ? tr.statusCode : -3;
    }

    public String getResult(String taskName) {
        TaskRunner tr = this.trMap.get(taskName);
        return tr != null ? tr.result : null;
    }

    public void setResult(String taskName, String result) {
        TaskRunner tr = this.trMap.get(taskName);
        if (tr != null) {
            tr.setResult(result);
        }
    }

    public static boolean isContainer(DSpaceObject dso) {
        return dso.getType() == 4 || dso.getType() == 3;
    }

    private boolean doCommunity(TaskRunner tr, Community comm) throws IOException {
        try {
            if (!tr.run(comm)) {
                return false;
            }
            for (Community community : comm.getSubcommunities()) {
                if (this.doCommunity(tr, community)) continue;
                return false;
            }
            for (DSpaceObject dSpaceObject : comm.getCollections()) {
                if (this.doCollection(tr, (Collection)dSpaceObject)) continue;
                return false;
            }
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE.getMessage(), sqlE);
        }
        return true;
    }

    private boolean doCollection(TaskRunner tr, Collection coll) throws IOException {
        try {
            if (!tr.run(coll)) {
                return false;
            }
            ItemIterator iter = coll.getItems();
            while (iter.hasNext()) {
                if (tr.run(iter.next())) continue;
                return false;
            }
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE.getMessage(), sqlE);
        }
        return true;
    }

    private class TaskRunner {
        CurationTask task = null;
        String taskName = null;
        int statusCode = -2;
        String result = null;
        Invoked mode = null;
        int[] codes = null;

        public TaskRunner(CurationTask task, String name) {
            this.task = task;
            this.taskName = name;
            this.parseAnnotations(task.getClass());
        }

        public boolean run(DSpaceObject dso) throws IOException {
            if (dso == null) {
                throw new IOException("DSpaceObject is null");
            }
            this.statusCode = this.task.perform(dso);
            return !this.suspend(this.statusCode);
        }

        public boolean run(Context c, String id) throws IOException {
            if (c == null || id == null) {
                throw new IOException("Context or identifier is null");
            }
            this.statusCode = this.task.perform(c, id);
            return !this.suspend(this.statusCode);
        }

        public void setResult(String result) {
            this.result = result;
        }

        private void parseAnnotations(Class tClass) {
            Suspendable suspendAnn = tClass.getAnnotation(Suspendable.class);
            if (suspendAnn != null) {
                this.mode = suspendAnn.invoked();
                this.codes = suspendAnn.statusCodes();
            }
        }

        private boolean suspend(int code) {
            if (this.mode != null && (this.mode.equals((Object)Invoked.ANY) || this.mode.equals((Object)Curator.this.iMode))) {
                for (int i : this.codes) {
                    if (code != i) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static enum Invoked {
        INTERACTIVE,
        BATCH,
        ANY;

    }
}

