/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.dspace.browse.BrowseException;
import org.dspace.browse.IndexBrowse;
import org.dspace.core.ConfigurationManager;
import org.dspace.storage.rdbms.DatabaseManager;

public class InitializeDatabase {
    private static Logger log = Logger.getLogger(InitializeDatabase.class);

    public static void main(String[] argv) {
        if (argv.length != 1) {
            log.warn((Object)"Schema file not specified");
            System.exit(1);
        }
        ConfigurationManager.loadConfig(null);
        log.info((Object)"Initializing Database");
        try {
            if ("clean-database.sql".equals(argv[0])) {
                try {
                    IndexBrowse browse = new IndexBrowse();
                    browse.setDelete(true);
                    browse.setExecute(true);
                    browse.clearDatabase();
                }
                catch (BrowseException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new IllegalStateException(e.getMessage(), e);
                }
                DatabaseManager.loadSql(InitializeDatabase.getScript(argv[0]));
            } else {
                DatabaseManager.loadSql(InitializeDatabase.getScript(argv[0]));
                try {
                    IndexBrowse browse = new IndexBrowse();
                    browse.setRebuild(true);
                    browse.setExecute(true);
                    browse.initBrowse();
                }
                catch (BrowseException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
            System.exit(0);
        }
        catch (Exception e) {
            log.fatal((Object)"Caught exception:", (Throwable)e);
            System.exit(1);
        }
    }

    private static FileReader getScript(String name) throws FileNotFoundException, IOException {
        String dbName = ConfigurationManager.getProperty("db.name");
        File myFile = null;
        if (dbName != null && (myFile = new File("etc/" + dbName + "/" + name)).exists()) {
            return new FileReader(myFile.getCanonicalPath());
        }
        myFile = new File("etc/" + name);
        if (myFile.exists()) {
            return new FileReader(myFile.getCanonicalPath());
        }
        return new FileReader(name);
    }
}

