/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.eperson.Group;
import org.dspace.xmlworkflow.Role;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.WorkflowFactory;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.storedcomponents.CollectionRole;

public class WorkflowUtils
extends Util {
    public static Logger log = Logger.getLogger(WorkflowUtils.class);

    public static String getRequestLogInfo(HttpServletRequest request) {
        String report = "-- URL Was: " + WorkflowUtils.getOriginalURL(request) + "\n";
        report = report + "-- Method: " + request.getMethod() + "\n";
        report = report + "-- Parameters were:\n";
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("login_password")) {
                report = report + "-- " + name + ": *not logged*\n";
                continue;
            }
            report = report + "-- " + name + ": \"" + request.getParameter(name) + "\"\n";
        }
        return report;
    }

    public static String getOriginalURL(HttpServletRequest request) {
        WorkflowUtils.storeOriginalURL(request);
        return (String)request.getAttribute("dspace.original.url");
    }

    public static void storeOriginalURL(HttpServletRequest request) {
        String orig = (String)request.getAttribute("dspace.original.url");
        if (orig == null) {
            String fullURL = request.getRequestURL().toString();
            if (request.getQueryString() != null) {
                fullURL = fullURL + "?" + request.getQueryString();
            }
            request.setAttribute("dspace.original.url", (Object)fullURL);
        }
    }

    public static void sendAlert(HttpServletRequest request, Exception exception) {
        String logInfo = WorkflowUtils.getRequestLogInfo(request);
        Context c = (Context)request.getAttribute("dspace.context");
        try {
            String recipient = ConfigurationManager.getProperty("alert.recipient");
            if (recipient != null) {
                String stackTrace;
                Email email = ConfigurationManager.getEmail(I18nUtil.getEmailFilename(c.getCurrentLocale(), "internal_error"));
                email.addRecipient(recipient);
                email.addArgument(ConfigurationManager.getProperty("dspace.url"));
                email.addArgument(new Date());
                email.addArgument(request.getSession().getId());
                email.addArgument(logInfo);
                if (exception != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exception.printStackTrace(pw);
                    pw.flush();
                    stackTrace = sw.toString();
                } else {
                    stackTrace = "No exception";
                }
                email.addArgument(stackTrace);
                email.send();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unable to send email alert", (Throwable)e);
        }
    }

    public static void createCollectionWorkflowRole(Context context, int collectionId, String roleId, Group group) throws AuthorizeException, SQLException {
        CollectionRole ass = CollectionRole.create(context);
        ass.setCollectionId(collectionId);
        ass.setRoleId(roleId);
        ass.setGroupId(group);
        ass.update();
    }

    public static void deleteRoleGroup(Context context, int collectionID, String roleID) throws SQLException {
        CollectionRole ass = CollectionRole.find(context, collectionID, roleID);
        ass.delete();
    }

    public static HashMap<String, Role> getCollectionRoles(Collection thisCollection) throws IOException, WorkflowConfigurationException {
        Workflow workflow = WorkflowFactory.getWorkflow(thisCollection);
        LinkedHashMap<String, Role> result = new LinkedHashMap<String, Role>();
        if (workflow != null) {
            HashMap<String, Role> allRoles = workflow.getRoles();
            for (String roleId : allRoles.keySet()) {
                Role role = allRoles.get(roleId);
                if (role.getScope() != Role.Scope.COLLECTION || role.isInternal()) continue;
                result.put(roleId, role);
            }
        }
        return result;
    }

    public static Group getRoleGroup(Context context, int collectionId, Role role) throws SQLException {
        if (role.getScope() == Role.Scope.REPOSITORY) {
            return Group.findByName(context, role.getName());
        }
        if (role.getScope() == Role.Scope.COLLECTION) {
            CollectionRole collectionRole = CollectionRole.find(context, collectionId, role.getId());
            if (collectionRole == null) {
                return null;
            }
            return collectionRole.getGroup();
        }
        if (role.getScope() == Role.Scope.ITEM) {
            // empty if block
        }
        return null;
    }
}

