/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.apache.poi.POITextExtractor;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.app.mediafilter.MediaFilterManager;

public class PowerPointFilter
extends MediaFilter {
    private static Logger log = Logger.getLogger(PowerPointFilter.class);

    @Override
    public String getFilteredName(String oldFilename) {
        return oldFilename + ".txt";
    }

    @Override
    public String getBundleName() {
        return "TEXT";
    }

    @Override
    public String getFormatString() {
        return "Text";
    }

    @Override
    public String getDescription() {
        return "Extracted text";
    }

    @Override
    public InputStream getDestinationStream(InputStream source) throws Exception {
        try {
            String extractedText = null;
            new ExtractorFactory();
            POITextExtractor pptExtractor = ExtractorFactory.createExtractor((InputStream)source);
            if (pptExtractor instanceof XSLFPowerPointExtractor) {
                extractedText = ((XSLFPowerPointExtractor)pptExtractor).getText(true, true);
            } else if (pptExtractor instanceof PowerPointExtractor) {
                extractedText = ((PowerPointExtractor)pptExtractor).getText() + " " + ((PowerPointExtractor)pptExtractor).getNotes();
            }
            if (extractedText != null) {
                if (MediaFilterManager.isVerbose) {
                    System.out.println(extractedText);
                }
                byte[] textBytes = extractedText.getBytes();
                ByteArrayInputStream bais = new ByteArrayInputStream(textBytes);
                return bais;
            }
        }
        catch (Exception e) {
            log.error((Object)("Error filtering bitstream: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        return null;
    }
}

