/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkInternalException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Utils;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class OREDisseminationCrosswalk
implements DisseminationCrosswalk {
    public static final String ATOM_RNG = "http://tweety.lanl.gov/public/schemas/2008-06/atom-tron.sch";
    public static final Namespace ATOM_NS = Namespace.getNamespace((String)"atom", (String)"http://www.w3.org/2005/Atom");
    private static final Namespace ORE_NS = Namespace.getNamespace((String)"ore", (String)"http://www.openarchives.org/ore/terms/");
    private static final Namespace ORE_ATOM = Namespace.getNamespace((String)"oreatom", (String)"http://www.openarchives.org/ore/atom/");
    private static final Namespace RDF_NS = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    private static final Namespace DCTERMS_NS = Namespace.getNamespace((String)"dcterms", (String)"http://purl.org/dc/terms/");
    private static final Namespace DS_NS = Namespace.getNamespace((String)"ds", (String)"http://www.dspace.org/objectModel/");
    private static final Namespace[] namespaces = new Namespace[]{ATOM_NS, ORE_NS, ORE_ATOM, RDF_NS, DCTERMS_NS, DS_NS};

    @Override
    public Namespace[] getNamespaces() {
        return (Namespace[])ArrayUtils.clone((Object[])namespaces);
    }

    @Override
    public String getSchemaLocation() {
        return ATOM_NS.getURI() + " " + ATOM_RNG;
    }

    private Element disseminateItem(Item item) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        Bundle[] bundles;
        DCValue[] authors;
        DCValue[] uris;
        String oaiUrl = null;
        String dsUrl = ConfigurationManager.getProperty("dspace.url");
        String remSource = ConfigurationManager.getProperty("oai", "ore.authoritative.source");
        if (remSource == null || remSource.equalsIgnoreCase("oai")) {
            oaiUrl = ConfigurationManager.getProperty("oai", "dspace.oai.url");
        } else if (remSource.equalsIgnoreCase("xmlui") || remSource.equalsIgnoreCase("manakin")) {
            oaiUrl = dsUrl;
        }
        if (oaiUrl == null) {
            throw new CrosswalkInternalException("Base uri for the ore generator has not been set. Check the ore.authoritative.source setting.");
        }
        String uriA = oaiUrl + "/metadata/handle/" + item.getHandle() + "/ore.xml";
        Element aggregation = new Element("entry", ATOM_NS);
        aggregation.addNamespaceDeclaration(ATOM_NS);
        aggregation.addNamespaceDeclaration(ORE_NS);
        aggregation.addNamespaceDeclaration(ORE_ATOM);
        aggregation.addNamespaceDeclaration(DCTERMS_NS);
        Element atomId = new Element("id", ATOM_NS);
        atomId.addContent(uriA);
        aggregation.addContent((Content)atomId);
        for (DCValue uri : uris = item.getMetadata("dc", "identifier", "uri", "*")) {
            Element aggLink = new Element("link", ATOM_NS);
            aggLink.setAttribute("rel", "alternate");
            aggLink.setAttribute("href", uri.value);
            aggregation.addContent((Content)aggLink);
        }
        Element uriALink = new Element("link", ATOM_NS);
        uriALink.setAttribute("rel", "http://www.openarchives.org/ore/terms/describes");
        uriALink.setAttribute("href", uriA);
        Element uriRLink = new Element("link", ATOM_NS);
        uriRLink.setAttribute("rel", "self");
        uriRLink.setAttribute("href", uriA + "#atom");
        uriRLink.setAttribute("type", "application/atom+xml");
        Element remPublished = new Element("published", ATOM_NS);
        remPublished.addContent(Utils.formatISO8601Date(new Date()));
        Element remUpdated = new Element("updated", ATOM_NS);
        remUpdated.addContent(Utils.formatISO8601Date(new Date()));
        Element remCreator = new Element("source", ATOM_NS);
        Element remGenerator = new Element("generator", ATOM_NS);
        remGenerator.addContent(ConfigurationManager.getProperty("dspace.name"));
        remGenerator.setAttribute("uri", oaiUrl);
        remCreator.addContent((Content)remGenerator);
        aggregation.addContent((Content)uriALink);
        aggregation.addContent((Content)uriRLink);
        aggregation.addContent((Content)remPublished);
        aggregation.addContent((Content)remUpdated);
        aggregation.addContent((Content)remCreator);
        Element aggTitle = new Element("title", ATOM_NS);
        DCValue[] titles = item.getMetadata("dc", "title", null, "*");
        if (titles != null && titles.length > 0) {
            aggTitle.addContent(titles[0].value);
        } else {
            aggTitle.addContent("");
        }
        aggregation.addContent((Content)aggTitle);
        for (DCValue author : authors = item.getMetadata("dc", "contributor", "author", "*")) {
            Element aggAuthor = new Element("author", ATOM_NS);
            Element aggAuthorName = new Element("name", ATOM_NS);
            aggAuthorName.addContent(author.value);
            aggAuthor.addContent((Content)aggAuthorName);
            aggregation.addContent((Content)aggAuthor);
        }
        Element oreCategory = new Element("category", ATOM_NS);
        oreCategory.setAttribute("scheme", ORE_NS.getURI());
        oreCategory.setAttribute("term", ORE_NS.getURI() + "Aggregation");
        oreCategory.setAttribute("label", "Aggregation");
        Element updateCategory = new Element("category", ATOM_NS);
        updateCategory.setAttribute("scheme", ORE_ATOM.getURI() + "modified");
        updateCategory.setAttribute("term", Utils.formatISO8601Date(item.getLastModified()));
        Element dsCategory = new Element("category", ATOM_NS);
        dsCategory.setAttribute("scheme", DS_NS.getURI());
        dsCategory.setAttribute("term", "DSpaceItem");
        dsCategory.setAttribute("label", "DSpace Item");
        aggregation.addContent((Content)oreCategory);
        aggregation.addContent((Content)updateCategory);
        aggregation.addContent((Content)dsCategory);
        Element triples = new Element("triples", ORE_ATOM);
        Element rdfDescription = new Element("Description", RDF_NS);
        rdfDescription.setAttribute("about", uriA, RDF_NS);
        Element rdfType = new Element("type", RDF_NS);
        rdfType.setAttribute("resource", DS_NS.getURI() + "DSpaceItem", RDF_NS);
        Element dcModified = new Element("modified", DCTERMS_NS);
        dcModified.addContent(Utils.formatISO8601Date(item.getLastModified()));
        rdfDescription.addContent((Content)rdfType);
        rdfDescription.addContent((Content)dcModified);
        triples.addContent((Content)rdfDescription);
        for (Bundle bundle : bundles = item.getBundles()) {
            Bitstream[] bitstreams;
            if (bundle.getName().equals("ORE")) continue;
            for (Bitstream bs : bitstreams = bundle.getBitstreams()) {
                Element arLink = new Element("link", ATOM_NS);
                arLink.setAttribute("rel", ORE_NS.getURI() + "aggregates");
                arLink.setAttribute("href", dsUrl + "/bitstream/handle/" + item.getHandle() + "/" + this.encodeForURL(bs.getName()) + "?sequence=" + bs.getSequenceID());
                arLink.setAttribute("title", bs.getName());
                arLink.setAttribute("type", bs.getFormat().getMIMEType());
                arLink.setAttribute("length", Long.toString(bs.getSize()));
                aggregation.addContent((Content)arLink);
                rdfDescription = new Element("Description", RDF_NS);
                rdfDescription.setAttribute("about", dsUrl + "/bitstream/handle/" + item.getHandle() + "/" + this.encodeForURL(bs.getName()) + "?sequence=" + bs.getSequenceID(), RDF_NS);
                rdfType = new Element("type", RDF_NS);
                rdfType.setAttribute("resource", DS_NS.getURI() + "DSpaceBitstream", RDF_NS);
                Element dcDesc = new Element("description", DCTERMS_NS);
                dcDesc.addContent(bundle.getName());
                rdfDescription.addContent((Content)rdfType);
                rdfDescription.addContent((Content)dcDesc);
                triples.addContent((Content)rdfDescription);
            }
        }
        aggregation.addContent((Content)triples);
        return aggregation;
    }

    @Override
    public Element disseminateElement(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        switch (dso.getType()) {
            case 2: {
                return this.disseminateItem((Item)dso);
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw new CrosswalkObjectNotSupported("ORE implementation unable to disseminate unknown DSpace object.");
            }
        }
        return null;
    }

    private String encodeForURL(String sourceString) {
        Character[] lowalpha = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z')};
        Character[] upalpha = new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')};
        Character[] digit = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9')};
        Character[] mark = new Character[]{Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('.'), Character.valueOf('!'), Character.valueOf('~'), Character.valueOf('*'), Character.valueOf('\''), Character.valueOf('/'), Character.valueOf('('), Character.valueOf(')')};
        HashSet<Character> URLcharsSet = new HashSet<Character>();
        URLcharsSet.addAll(Arrays.asList(lowalpha));
        URLcharsSet.addAll(Arrays.asList(upalpha));
        URLcharsSet.addAll(Arrays.asList(digit));
        URLcharsSet.addAll(Arrays.asList(mark));
        StringBuilder processedString = new StringBuilder();
        for (int i = 0; i < sourceString.length(); ++i) {
            char ch = sourceString.charAt(i);
            if (URLcharsSet.contains(Character.valueOf(ch))) {
                processedString.append(ch);
                continue;
            }
            processedString.append("%").append(Integer.toHexString(ch));
        }
        return processedString.toString();
    }

    @Override
    public List<Element> disseminateList(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        ArrayList<Element> result = new ArrayList<Element>(1);
        result.add(this.disseminateElement(dso));
        return result;
    }

    @Override
    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() == 2 || dso.getType() == 3 || dso.getType() == 4;
    }

    @Override
    public boolean preferList() {
        return false;
    }
}

