/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.content.authority.Choices;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkInternalException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.XSLTCrosswalk;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Constants;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Verifier;
import org.jdom.transform.XSLTransformException;
import org.jdom.transform.XSLTransformer;

public class XSLTDisseminationCrosswalk
extends XSLTCrosswalk
implements DisseminationCrosswalk {
    private static Logger log = Logger.getLogger(XSLTDisseminationCrosswalk.class);
    private static final String DIRECTION = "dissemination";
    private static String[] aliases = XSLTDisseminationCrosswalk.makeAliases("dissemination");
    private String schemaLocation = null;
    private Namespace[] namespaces = null;
    private boolean preferList = false;

    public static String[] getPluginNames() {
        return (String[])ArrayUtils.clone((Object[])aliases);
    }

    private void init() throws CrosswalkInternalException {
        if (this.namespaces != null || this.schemaLocation != null) {
            return;
        }
        String myAlias = this.getPluginInstanceName();
        if (myAlias == null) {
            log.error((Object)"Must use PluginManager to instantiate XSLTDisseminationCrosswalk so the class knows its name.");
            throw new CrosswalkInternalException("Must use PluginManager to instantiate XSLTDisseminationCrosswalk so the class knows its name.");
        }
        String prefix = "crosswalk.dissemination." + myAlias + ".";
        this.schemaLocation = ConfigurationManager.getProperty(prefix + "schemaLocation");
        if (this.schemaLocation == null) {
            log.warn((Object)("No schemaLocation for crosswalk=" + myAlias + ", key=" + prefix + "schemaLocation"));
        } else if (this.schemaLocation.length() > 0 && this.schemaLocation.indexOf(32) < 0) {
            log.warn((Object)("Possible INVALID schemaLocation (no space found) for crosswalk=" + myAlias + ", key=" + prefix + "schemaLocation" + "\n\tCorrect format is \"{namespace} {schema-URL}\""));
        }
        String nsPrefix = prefix + "namespace.";
        Enumeration<?> pe = ConfigurationManager.propertyNames();
        ArrayList<Namespace> nsList = new ArrayList<Namespace>();
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            if (!key.startsWith(nsPrefix)) continue;
            nsList.add(Namespace.getNamespace((String)key.substring(nsPrefix.length()), (String)ConfigurationManager.getProperty(key)));
        }
        this.namespaces = nsList.toArray(new Namespace[nsList.size()]);
        this.preferList = ConfigurationManager.getBooleanProperty(prefix + "preferList", false);
    }

    @Override
    public Namespace[] getNamespaces() {
        try {
            this.init();
        }
        catch (CrosswalkInternalException e) {
            log.error((Object)e.toString());
        }
        return (Namespace[])ArrayUtils.clone((Object[])this.namespaces);
    }

    @Override
    public String getSchemaLocation() {
        try {
            this.init();
        }
        catch (CrosswalkInternalException e) {
            log.error((Object)e.toString());
        }
        return this.schemaLocation;
    }

    @Override
    public Element disseminateElement(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        int type = dso.getType();
        if (type != 2 && type != 3 && type != 4) {
            throw new CrosswalkObjectNotSupported("XSLTDisseminationCrosswalk can only crosswalk items, collections, and communities.");
        }
        this.init();
        XSLTransformer xform = this.getTransformer(DIRECTION);
        if (xform == null) {
            throw new CrosswalkInternalException("Failed to initialize transformer, probably error loading stylesheet.");
        }
        try {
            Document ddim = new Document(XSLTDisseminationCrosswalk.createDIM(dso));
            Document result = xform.transform(ddim);
            Element root = result.getRootElement();
            root.detach();
            return root;
        }
        catch (XSLTransformException e) {
            log.error((Object)("Got error: " + e.toString()));
            throw new CrosswalkInternalException("XSL translation failed: " + e.toString(), e);
        }
    }

    @Override
    public List<Element> disseminateList(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        int type = dso.getType();
        if (type != 2 && type != 3 && type != 4) {
            throw new CrosswalkObjectNotSupported("XSLTDisseminationCrosswalk can only crosswalk a items, collections, and communities.");
        }
        this.init();
        XSLTransformer xform = this.getTransformer(DIRECTION);
        if (xform == null) {
            throw new CrosswalkInternalException("Failed to initialize transformer, probably error loading stylesheet.");
        }
        try {
            return xform.transform(XSLTDisseminationCrosswalk.createDIM(dso).getChildren());
        }
        catch (XSLTransformException e) {
            log.error((Object)("Got error: " + e.toString()));
            throw new CrosswalkInternalException("XSL translation failed: " + e.toString(), e);
        }
    }

    @Override
    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() == 2;
    }

    @Override
    public boolean preferList() {
        try {
            this.init();
        }
        catch (CrosswalkInternalException e) {
            log.error((Object)e.toString());
        }
        return this.preferList;
    }

    public static Element createDIM(DSpaceObject dso, DCValue[] dcvs) {
        Element dim = new Element("dim", DIM_NS);
        String type = Constants.typeText[dso.getType()];
        dim.setAttribute("dspaceType", type);
        for (int i = 0; i < dcvs.length; ++i) {
            DCValue dcv = dcvs[i];
            Element field = XSLTDisseminationCrosswalk.createField(dcv.schema, dcv.element, dcv.qualifier, dcv.language, dcv.value, dcv.authority, dcv.confidence);
            dim.addContent((Content)field);
        }
        return dim;
    }

    public static Element createDIM(DSpaceObject dso) {
        if (dso.getType() == 2) {
            Item item = (Item)dso;
            return XSLTDisseminationCrosswalk.createDIM(dso, item.getMetadata("*", "*", "*", "*"));
        }
        Element dim = new Element("dim", DIM_NS);
        String type = Constants.typeText[dso.getType()];
        dim.setAttribute("dspaceType", type);
        if (dso.getType() == 3) {
            Collection collection = (Collection)dso;
            String description = collection.getMetadata("introductory_text");
            String description_abstract = collection.getMetadata("short_description");
            String description_table = collection.getMetadata("side_bar_text");
            String identifier_uri = "hdl:" + collection.getHandle();
            String provenance = collection.getMetadata("provenance_description");
            String rights = collection.getMetadata("copyright_text");
            String rights_license = collection.getMetadata("license");
            String title = collection.getMetadata("name");
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", null, null, description));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", "abstract", null, description_abstract));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", "tableofcontents", null, description_table));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "identifier", "uri", null, identifier_uri));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "provenance", null, null, provenance));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "rights", null, null, rights));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "rights", "license", null, rights_license));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "title", null, null, title));
        } else if (dso.getType() == 4) {
            Community community = (Community)dso;
            String description = community.getMetadata("introductory_text");
            String description_abstract = community.getMetadata("short_description");
            String description_table = community.getMetadata("side_bar_text");
            String identifier_uri = "hdl:" + community.getHandle();
            String rights = community.getMetadata("copyright_text");
            String title = community.getMetadata("name");
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", null, null, description));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", "abstract", null, description_abstract));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "description", "tableofcontents", null, description_table));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "identifier", "uri", null, identifier_uri));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "rights", null, null, rights));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "title", null, null, title));
        } else if (dso.getType() == 5) {
            Site site = (Site)dso;
            String identifier_uri = "hdl:" + site.getHandle();
            String title = site.getName();
            String url = site.getURL();
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "identifier", "uri", null, identifier_uri));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "identifier", "uri", null, url));
            dim.addContent((Content)XSLTDisseminationCrosswalk.createField("dc", "title", null, null, title));
        }
        return dim;
    }

    private static Element createField(String schema, String element, String qualifier, String language, String value) {
        return XSLTDisseminationCrosswalk.createField(schema, element, qualifier, language, value, null, -1);
    }

    private static Element createField(String schema, String element, String qualifier, String language, String value, String authority, int confidence) {
        Element field = new Element("field", DIM_NS);
        field.setAttribute("mdschema", schema);
        field.setAttribute("element", element);
        if (qualifier != null) {
            field.setAttribute("qualifier", qualifier);
        }
        if (language != null) {
            field.setAttribute("lang", language);
        }
        field.setText(XSLTDisseminationCrosswalk.checkedString(value));
        if (authority != null) {
            field.setAttribute("authority", authority);
            field.setAttribute("confidence", Choices.getConfidenceText(confidence));
        }
        return field;
    }

    private static String checkedString(String value) {
        if (value == null) {
            return null;
        }
        String reason = Verifier.checkCharacterData((String)value);
        if (reason == null) {
            return value;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Filtering out non-XML characters in string, reason=" + reason));
        }
        StringBuffer result = new StringBuffer(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!Verifier.isXMLCharacter((int)c)) continue;
            result.append(c);
        }
        return result.toString();
    }
}

