/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.ItemIterator;
import org.dspace.content.Site;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.curate.ResolvedTask;
import org.dspace.curate.TaskQueue;
import org.dspace.curate.TaskQueueEntry;
import org.dspace.curate.TaskResolver;
import org.dspace.handle.HandleManager;

public class Curator {
    public static final int CURATE_NOTASK = -3;
    public static final int CURATE_UNSET = -2;
    public static final int CURATE_ERROR = -1;
    public static final int CURATE_SUCCESS = 0;
    public static final int CURATE_FAIL = 1;
    public static final int CURATE_SKIP = 2;
    private static Logger log = Logger.getLogger(Curator.class);
    private static final ThreadLocal<Context> curationCtx = new ThreadLocal();
    private Map<String, TaskRunner> trMap = new HashMap<String, TaskRunner>();
    private List<String> perfList = new ArrayList<String>();
    private TaskQueue taskQ = null;
    private String reporter = null;
    private Invoked iMode = null;
    private TaskResolver resolver = new TaskResolver();
    private int cacheLimit = Integer.MAX_VALUE;
    private TxScope txScope = TxScope.OPEN;

    public Curator addTask(String taskName) {
        ResolvedTask task = this.resolver.resolveTask(taskName);
        if (task != null) {
            try {
                task.init(this);
                this.trMap.put(taskName, new TaskRunner(task));
                this.perfList.add(taskName);
            }
            catch (IOException ioE) {
                log.error((Object)("Task: '" + taskName + "' initialization failure: " + ioE.getMessage()));
            }
        } else {
            log.error((Object)("Task: '" + taskName + "' does not resolve"));
        }
        return this;
    }

    public boolean hasTask(String taskName) {
        return this.perfList.contains(taskName);
    }

    public Curator removeTask(String taskName) {
        this.trMap.remove(taskName);
        this.perfList.remove(taskName);
        return this;
    }

    public Curator setInvoked(Invoked mode) {
        this.iMode = mode;
        return this;
    }

    public Curator setReporter(String reporter) {
        this.reporter = reporter;
        return this;
    }

    public Curator setCacheLimit(int limit) {
        this.cacheLimit = limit;
        return this;
    }

    public Curator setTransactionScope(TxScope scope) {
        this.txScope = scope;
        return this;
    }

    public void curate(Context c, String id) throws IOException {
        if (id == null) {
            throw new IOException("Cannot perform curation task(s) on a null object identifier!");
        }
        try {
            Context ctx;
            curationCtx.set(c);
            DSpaceObject dso = HandleManager.resolveToObject(c, id);
            if (dso != null) {
                this.curate(dso);
            } else {
                for (String taskName : this.perfList) {
                    this.trMap.get(taskName).run(c, id);
                }
            }
            if (this.txScope.equals((Object)TxScope.CURATION) && (ctx = curationCtx.get()) != null) {
                ctx.commit();
            }
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE.getMessage(), sqlE);
        }
        finally {
            curationCtx.remove();
        }
    }

    public void curate(DSpaceObject dso) throws IOException {
        if (dso == null) {
            throw new IOException("Cannot perform curation task(s) on a null DSpaceObject!");
        }
        int type = dso.getType();
        for (String taskName : this.perfList) {
            TaskRunner tr = this.trMap.get(taskName);
            if (type == 2 || tr.task.isDistributive()) {
                tr.run(dso);
                continue;
            }
            if (type == 3) {
                this.doCollection(tr, (Collection)dso);
                continue;
            }
            if (type == 4) {
                this.doCommunity(tr, (Community)dso);
                continue;
            }
            if (type != 5) continue;
            this.doSite(tr, (Site)dso);
        }
    }

    public void queue(Context c, String id, String queueId) throws IOException {
        if (this.taskQ == null) {
            this.taskQ = (TaskQueue)PluginManager.getSinglePlugin("curate", TaskQueue.class);
        }
        if (this.taskQ != null) {
            this.taskQ.enqueue(queueId, new TaskQueueEntry(c.getCurrentUser().getName(), System.currentTimeMillis(), this.perfList, id));
        } else {
            log.error((Object)"curate - no TaskQueue implemented");
        }
    }

    public void clear() {
        this.trMap.clear();
        this.perfList.clear();
    }

    public void report(String message) {
        if ("-".equals(this.reporter)) {
            System.out.println(message);
        }
    }

    public int getStatus(String taskName) {
        TaskRunner tr = this.trMap.get(taskName);
        return tr != null ? tr.statusCode : -3;
    }

    public String getResult(String taskName) {
        TaskRunner tr = this.trMap.get(taskName);
        return tr != null ? tr.result : null;
    }

    public void setResult(String taskName, String result) {
        TaskRunner tr = this.trMap.get(taskName);
        if (tr != null) {
            tr.setResult(result);
        }
    }

    public static Context curationContext() throws SQLException {
        Context curCtx = curationCtx.get();
        return curCtx != null ? curCtx : new Context();
    }

    public static boolean isContainer(DSpaceObject dso) {
        return dso.getType() == 4 || dso.getType() == 3;
    }

    private boolean doSite(TaskRunner tr, Site site) throws IOException {
        Context ctx = null;
        try {
            ctx = Curator.curationContext();
            if (ctx.getCurrentUser() == null) {
                log.warn((Object)"You are running one or more Site-Wide curation tasks in ANONYMOUS USER mode, as there is no EPerson 'performer' associated with this task. To associate an EPerson 'performer'  you should ensure tasks are called via the Curator.curate(Context, ID) method.");
            }
            if (!tr.run(site)) {
                return false;
            }
            for (Community subcomm : Community.findAllTop(ctx)) {
                if (this.doCommunity(tr, subcomm)) continue;
                return false;
            }
            ctx.complete();
        }
        catch (SQLException sqlE) {
            if (ctx != null) {
                ctx.abort();
            }
            throw new IOException(sqlE);
        }
        return true;
    }

    private boolean doCommunity(TaskRunner tr, Community comm) throws IOException {
        try {
            if (!tr.run(comm)) {
                return false;
            }
            for (Community community : comm.getSubcommunities()) {
                if (this.doCommunity(tr, community)) continue;
                return false;
            }
            for (DSpaceObject dSpaceObject : comm.getCollections()) {
                if (this.doCollection(tr, (Collection)dSpaceObject)) continue;
                return false;
            }
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE.getMessage(), sqlE);
        }
        return true;
    }

    private boolean doCollection(TaskRunner tr, Collection coll) throws IOException {
        try {
            if (!tr.run(coll)) {
                return false;
            }
            ItemIterator iter = coll.getItems();
            while (iter.hasNext()) {
                if (tr.run(iter.next())) continue;
                return false;
            }
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE.getMessage(), sqlE);
        }
        return true;
    }

    private void visit(DSpaceObject dso) throws IOException {
        Context curCtx = curationCtx.get();
        if (curCtx != null) {
            try {
                if (this.txScope.equals((Object)TxScope.OBJECT)) {
                    curCtx.commit();
                }
                if (curCtx.getCacheSize() % this.cacheLimit == 0) {
                    curCtx.clearCache();
                }
            }
            catch (SQLException sqlE) {
                throw new IOException(sqlE.getMessage());
            }
        }
    }

    private class TaskRunner {
        ResolvedTask task = null;
        int statusCode = -2;
        String result = null;

        public TaskRunner(ResolvedTask task) {
            this.task = task;
        }

        public boolean run(DSpaceObject dso) throws IOException {
            try {
                if (dso == null) {
                    throw new IOException("DSpaceObject is null");
                }
                this.statusCode = this.task.perform(dso);
                String id = dso.getHandle() != null ? dso.getHandle() : "workflow item: " + dso.getID();
                log.info((Object)this.logMessage(id));
                Curator.this.visit(dso);
                return !this.suspend(this.statusCode);
            }
            catch (IOException ioe) {
                log.error((Object)("Error executing curation task '" + this.task.getName() + "'"), (Throwable)ioe);
                throw ioe;
            }
        }

        public boolean run(Context c, String id) throws IOException {
            try {
                if (c == null || id == null) {
                    throw new IOException("Context or identifier is null");
                }
                this.statusCode = this.task.perform(c, id);
                log.info((Object)this.logMessage(id));
                Curator.this.visit(null);
                return !this.suspend(this.statusCode);
            }
            catch (IOException ioe) {
                log.error((Object)("Error executing curation task '" + this.task.getName() + "'"), (Throwable)ioe);
                throw ioe;
            }
        }

        public void setResult(String result) {
            this.result = result;
        }

        private boolean suspend(int code) {
            Invoked mode = this.task.getMode();
            if (mode != null && (mode.equals((Object)Invoked.ANY) || mode.equals((Object)Curator.this.iMode))) {
                for (int i : this.task.getCodes()) {
                    if (code != i) continue;
                    return true;
                }
            }
            return false;
        }

        private String logMessage(String id) {
            StringBuilder mb = new StringBuilder();
            mb.append("Curation task: ").append(this.task.getName()).append(" performed on: ").append(id).append(" with status: ").append(this.statusCode);
            if (this.result != null) {
                mb.append(". Result: '").append(this.result).append("'");
            }
            return mb.toString();
        }
    }

    public static enum TxScope {
        OBJECT,
        CURATION,
        OPEN;

    }

    public static enum Invoked {
        INTERACTIVE,
        BATCH,
        ANY;

    }
}

