/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.ColumnInfo;
import org.dspace.storage.rdbms.DataSourceInit;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class DatabaseManager {
    private static Logger log = Logger.getLogger(DatabaseManager.class);
    private static boolean initialized = false;
    private static Map<String, String> insertSQL = new HashMap<String, String>();
    private static boolean isOracle = false;
    private static boolean isPostgres = false;
    private static DataSource dataSource;
    private static String sqlOnBorrow;
    private static String poolName;
    private static final Pattern DB_SAFE_NAME;
    private static Map<String, Map<String, ColumnInfo>> info;

    protected DatabaseManager() {
    }

    public static boolean isOracle() {
        return isOracle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConstraintDeferred(Context context, String constraintName) throws SQLException {
        Statement statement = null;
        try {
            statement = context.getDBConnection().createStatement();
            statement.execute("SET CONSTRAINTS " + constraintName + " DEFERRED");
            statement.close();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConstraintImmediate(Context context, String constraintName) throws SQLException {
        Statement statement = null;
        try {
            statement = context.getDBConnection().createStatement();
            statement.execute("SET CONSTRAINTS " + constraintName + " IMMEDIATE");
            statement.close();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static TableRowIterator queryTable(Context context, String table, String query, Object ... parameters) throws SQLException {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Running query \"").append(query).append("\"  with parameters: ");
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(parameters[i].toString());
            }
            log.debug((Object)sb.toString());
        }
        PreparedStatement statement = context.getDBConnection().prepareStatement(query);
        try {
            DatabaseManager.loadParameters(statement, parameters);
            TableRowIterator retTRI = new TableRowIterator(statement.executeQuery(), DatabaseManager.canonicalize(table));
            retTRI.setStatement(statement);
            return retTRI;
        }
        catch (SQLException sqle) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException s) {
                    // empty catch block
                }
            }
            throw sqle;
        }
    }

    public static TableRowIterator query(Context context, String query, Object ... parameters) throws SQLException {
        if (log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(parameters[i].toString());
            }
            log.debug((Object)("Running query \"" + query + "\"  with parameters: " + sb.toString()));
        }
        PreparedStatement statement = context.getDBConnection().prepareStatement(query);
        try {
            DatabaseManager.loadParameters(statement, parameters);
            TableRowIterator retTRI = new TableRowIterator(statement.executeQuery());
            retTRI.setStatement(statement);
            return retTRI;
        }
        catch (SQLException sqle) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException s) {
                    // empty catch block
                }
            }
            throw sqle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableRow querySingle(Context context, String query, Object ... parameters) throws SQLException {
        TableRow retRow = null;
        TableRowIterator iterator = null;
        try {
            iterator = DatabaseManager.query(context, query, parameters);
            retRow = !iterator.hasNext() ? null : iterator.next();
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        return retRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableRow querySingleTable(Context context, String table, String query, Object ... parameters) throws SQLException {
        TableRow retRow = null;
        TableRowIterator iterator = DatabaseManager.queryTable(context, DatabaseManager.canonicalize(table), query, parameters);
        try {
            retRow = !iterator.hasNext() ? null : iterator.next();
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        return retRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int updateQuery(Context context, String query, Object ... parameters) throws SQLException {
        PreparedStatement statement = null;
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Running query \"").append(query).append("\"  with parameters: ");
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(parameters[i].toString());
            }
            log.debug((Object)sb.toString());
        }
        try {
            statement = context.getDBConnection().prepareStatement(query);
            DatabaseManager.loadParameters(statement, parameters);
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {}
            }
        }
    }

    public static TableRow create(Context context, String table) throws SQLException {
        TableRow row = new TableRow(DatabaseManager.canonicalize(table), DatabaseManager.getColumnNames(table));
        DatabaseManager.insert(context, row);
        return row;
    }

    public static TableRow find(Context context, String table, int id) throws SQLException {
        String ctable = DatabaseManager.canonicalize(table);
        return DatabaseManager.findByUnique(context, ctable, DatabaseManager.getPrimaryKeyColumn(ctable), id);
    }

    public static TableRow findByUnique(Context context, String table, String column, Object value) throws SQLException {
        String ctable = DatabaseManager.canonicalize(table);
        if (!DB_SAFE_NAME.matcher(ctable).matches()) {
            throw new SQLException("Unable to execute select query because table name (" + ctable + ") contains non alphanumeric characters.");
        }
        if (!DB_SAFE_NAME.matcher(column).matches()) {
            throw new SQLException("Unable to execute select query because column name (" + column + ") contains non alphanumeric characters.");
        }
        StringBuilder sql = new StringBuilder("select * from ").append(ctable).append(" where ").append(column).append(" = ? ");
        return DatabaseManager.querySingleTable(context, ctable, sql.toString(), value);
    }

    public static int delete(Context context, String table, int id) throws SQLException {
        String ctable = DatabaseManager.canonicalize(table);
        return DatabaseManager.deleteByValue(context, ctable, DatabaseManager.getPrimaryKeyColumn(ctable), id);
    }

    public static int deleteByValue(Context context, String table, String column, Object value) throws SQLException {
        String ctable = DatabaseManager.canonicalize(table);
        if (!DB_SAFE_NAME.matcher(ctable).matches()) {
            throw new SQLException("Unable to execute delete query because table name (" + ctable + ") contains non alphanumeric characters.");
        }
        if (!DB_SAFE_NAME.matcher(column).matches()) {
            throw new SQLException("Unable to execute delete query because column name (" + column + ") contains non alphanumeric characters.");
        }
        StringBuilder sql = new StringBuilder("delete from ").append(ctable).append(" where ").append(column).append(" = ? ");
        return DatabaseManager.updateQuery(context, sql.toString(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection() throws SQLException {
        DatabaseManager.initialize();
        if (dataSource != null) {
            Connection conn = dataSource.getConnection();
            if (!StringUtils.isEmpty((String)sqlOnBorrow)) {
                PreparedStatement pstmt = conn.prepareStatement(sqlOnBorrow);
                try {
                    pstmt.execute();
                }
                finally {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
            }
            return conn;
        }
        return null;
    }

    public static DataSource getDataSource() {
        try {
            DatabaseManager.initialize();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return dataSource;
    }

    public static void freeConnection(Connection c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static TableRow row(String table) throws SQLException {
        return new TableRow(DatabaseManager.canonicalize(table), DatabaseManager.getColumnNames(table));
    }

    public static void insert(Context context, TableRow row) throws SQLException {
        int newID = isPostgres ? DatabaseManager.doInsertPostgres(context, row) : DatabaseManager.doInsertGeneric(context, row);
        row.setColumn(DatabaseManager.getPrimaryKeyColumn(row), newID);
    }

    public static int update(Context context, TableRow row) throws SQLException {
        String table = row.getTable();
        StringBuilder sql = new StringBuilder().append("update ").append(table).append(" set ");
        ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        ColumnInfo pk = DatabaseManager.getPrimaryKeyColumnInfo(table);
        Collection<ColumnInfo> info = DatabaseManager.getColumnInfo(table);
        String separator = "";
        for (ColumnInfo col : info) {
            if (col.isPrimaryKey() || !row.hasColumnChanged(col.getName())) continue;
            sql.append(separator).append(col.getName()).append(" = ?");
            columns.add(col);
            separator = ", ";
        }
        if (columns.size() > 0) {
            sql.append(" where ").append(pk.getName()).append(" = ?");
            columns.add(pk);
            return DatabaseManager.executeUpdate(context.getDBConnection(), sql.toString(), columns, row);
        }
        return 1;
    }

    public static int delete(Context context, TableRow row) throws SQLException {
        if (null == row.getTable()) {
            throw new IllegalArgumentException("Row not associated with a table");
        }
        String pk = DatabaseManager.getPrimaryKeyColumn(row);
        if (row.isColumnNull(pk)) {
            throw new IllegalArgumentException("Primary key value is null");
        }
        return DatabaseManager.delete(context, row.getTable(), row.getIntColumn(pk));
    }

    static Collection<ColumnInfo> getColumnInfo(String table) throws SQLException {
        Map<String, ColumnInfo> cinfo = DatabaseManager.getColumnInfoInternal(table);
        return cinfo == null ? null : cinfo.values();
    }

    static ColumnInfo getColumnInfo(String table, String column) throws SQLException {
        Map<String, ColumnInfo> info = DatabaseManager.getColumnInfoInternal(table);
        return info == null ? null : info.get(column);
    }

    static List<String> getColumnNames(String table) throws SQLException {
        ArrayList<String> results = new ArrayList<String>();
        Collection<ColumnInfo> info = DatabaseManager.getColumnInfo(table);
        for (ColumnInfo col : info) {
            results.add(col.getName());
        }
        return results;
    }

    static List<String> getColumnNames(ResultSetMetaData meta) throws SQLException {
        ArrayList<String> results = new ArrayList<String>();
        int columns = meta.getColumnCount();
        for (int i = 0; i < columns; ++i) {
            results.add(meta.getColumnLabel(i + 1));
        }
        return results;
    }

    static String canonicalize(String table) {
        if (isOracle) {
            return table == null ? null : table.toUpperCase();
        }
        return table == null ? null : table.toLowerCase();
    }

    public static void loadSql(String sql) throws SQLException {
        try {
            DatabaseManager.loadSql(new StringReader(sql));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSql(Reader r) throws SQLException, IOException {
        BufferedReader reader = new BufferedReader(r);
        StringBuilder sqlBuilder = new StringBuilder();
        String sql = null;
        String line = null;
        Connection connection = null;
        Statement statement = null;
        try {
            connection = DatabaseManager.getConnection();
            connection.setAutoCommit(true);
            statement = connection.createStatement();
            boolean inquote = false;
            while ((line = reader.readLine()) != null) {
                block14: {
                    int endMarker;
                    String input;
                    int commentStart = line.indexOf("--");
                    String string = input = commentStart != -1 ? line.substring(0, commentStart) : line;
                    if (input.trim().equals("")) continue;
                    sqlBuilder.append(input.replace(';', ' '));
                    sqlBuilder.append(" ");
                    int index = 0;
                    int count = 0;
                    int inputlen = input.length();
                    while ((index = input.indexOf(39, count)) != -1) {
                        boolean bl = inquote = !inquote;
                        count = index + 1;
                        if (count < inputlen) continue;
                    }
                    if (inquote || (endMarker = input.indexOf(59, index)) == -1) continue;
                    sql = sqlBuilder.toString();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Running database query \"" + sql + "\""));
                    }
                    try {
                        statement.execute(sql);
                    }
                    catch (SQLWarning sqlw) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Got SQL Warning: " + sqlw), (Throwable)sqlw);
                        }
                    }
                    catch (SQLException sqle) {
                        boolean isNoResults;
                        String msg = "Got SQL Exception: " + sqle;
                        String sqlmessage = sqle.getMessage();
                        boolean isDrop = sql != null && sqlmessage != null && sql.toUpperCase().startsWith("DROP") && sqlmessage.indexOf("does not exist") != -1;
                        boolean bl = isNoResults = sql != null && sqlmessage != null && (sql.toUpperCase().startsWith("CREATE VIEW") || sql.toUpperCase().startsWith("CREATE FUNCTION")) && sqlmessage.indexOf("No results were returned") != -1;
                        if (isDrop || isNoResults) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)msg, (Throwable)sqle);
                            }
                        }
                        if (!log.isEnabledFor((Priority)Level.WARN)) break block14;
                        log.warn((Object)msg, (Throwable)sqle);
                    }
                }
                sqlBuilder = new StringBuilder();
                sql = null;
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    static TableRow process(ResultSet results, String table) throws SQLException {
        return DatabaseManager.process(results, table, null);
    }

    static TableRow process(ResultSet results, String table, List<String> pColumnNames) throws SQLException {
        ResultSetMetaData meta = results.getMetaData();
        int columns = meta.getColumnCount() + 1;
        List<String> columnNames = pColumnNames != null ? pColumnNames : (table == null ? DatabaseManager.getColumnNames(meta) : DatabaseManager.getColumnNames(table));
        TableRow row = new TableRow(DatabaseManager.canonicalize(table), columnNames);
        for (int i = 1; i < columns; ++i) {
            String name = meta.getColumnName(i);
            int jdbctype = meta.getColumnType(i);
            switch (jdbctype) {
                case -7: {
                    row.setColumn(name, results.getBoolean(i));
                    break;
                }
                case 2: 
                case 4: {
                    if (isOracle) {
                        long longValue = results.getLong(i);
                        if (longValue <= Integer.MAX_VALUE) {
                            row.setColumn(name, (int)longValue);
                            break;
                        }
                        row.setColumn(name, longValue);
                        break;
                    }
                    row.setColumn(name, results.getInt(i));
                    break;
                }
                case -5: 
                case 3: {
                    row.setColumn(name, results.getLong(i));
                    break;
                }
                case 8: {
                    row.setColumn(name, results.getDouble(i));
                    break;
                }
                case 2005: {
                    if (isOracle) {
                        row.setColumn(name, results.getString(i));
                        break;
                    }
                    throw new IllegalArgumentException("Unsupported JDBC type: " + jdbctype);
                }
                case 12: {
                    try {
                        byte[] bytes = results.getBytes(i);
                        if (bytes != null) {
                            String mystring = new String(results.getBytes(i), "UTF-8");
                            row.setColumn(name, mystring);
                            break;
                        }
                        row.setColumn(name, results.getString(i));
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error((Object)"Unable to parse text from database", (Throwable)e);
                    }
                    break;
                }
                case 91: {
                    row.setColumn(name, results.getDate(i));
                    break;
                }
                case 92: {
                    row.setColumn(name, results.getTime(i));
                    break;
                }
                case 93: {
                    row.setColumn(name, results.getTimestamp(i));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported JDBC type: " + jdbctype);
                }
            }
            if (!results.wasNull()) continue;
            row.setColumnNull(name);
        }
        row.resetChanged();
        return row;
    }

    public static String getPrimaryKeyColumn(TableRow row) throws SQLException {
        return DatabaseManager.getPrimaryKeyColumn(row.getTable());
    }

    protected static String getPrimaryKeyColumn(String table) throws SQLException {
        ColumnInfo info = DatabaseManager.getPrimaryKeyColumnInfo(table);
        return info == null ? null : info.getName();
    }

    static ColumnInfo getPrimaryKeyColumnInfo(String table) throws SQLException {
        Collection<ColumnInfo> cinfo = DatabaseManager.getColumnInfo(DatabaseManager.canonicalize(table));
        for (ColumnInfo info : cinfo) {
            if (!info.isPrimaryKey()) continue;
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void execute(Connection connection, String sql, Collection<ColumnInfo> columns, TableRow row) throws SQLException {
        PreparedStatement statement = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running query \"" + sql + "\""));
        }
        try {
            statement = connection.prepareStatement(sql);
            DatabaseManager.loadParameters(statement, columns, row);
            statement.execute();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int executeUpdate(Connection connection, String sql, Collection<ColumnInfo> columns, TableRow row) throws SQLException {
        PreparedStatement statement = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running query \"" + sql + "\""));
        }
        try {
            statement = connection.prepareStatement(sql);
            DatabaseManager.loadParameters(statement, columns, row);
            int n = statement.executeUpdate();
            return n;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {}
            }
        }
    }

    private static Map<String, ColumnInfo> getColumnInfoInternal(String table) throws SQLException {
        String ctable = DatabaseManager.canonicalize(table);
        Map<String, ColumnInfo> results = info.get(ctable);
        if (results != null) {
            return results;
        }
        results = DatabaseManager.retrieveColumnInfo(ctable);
        info.put(ctable, results);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, ColumnInfo> retrieveColumnInfo(String table) throws SQLException {
        Connection connection = null;
        ResultSet pkcolumns = null;
        ResultSet columns = null;
        try {
            String schema = ConfigurationManager.getProperty("db.schema");
            String catalog = null;
            int dotIndex = table.indexOf(46);
            if (dotIndex > 0) {
                catalog = table.substring(0, dotIndex);
                table = table.substring(dotIndex + 1, table.length());
                log.warn((Object)("catalog: " + catalog));
                log.warn((Object)("table: " + table));
            }
            connection = DatabaseManager.getConnection();
            DatabaseMetaData metadata = connection.getMetaData();
            HashMap<String, ColumnInfo> results = new HashMap<String, ColumnInfo>();
            int max = metadata.getMaxTableNameLength();
            String tname = max > 0 && table.length() >= max ? table.substring(0, max - 1) : table;
            pkcolumns = metadata.getPrimaryKeys(catalog, schema, tname);
            HashSet<String> pks = new HashSet<String>();
            while (pkcolumns.next()) {
                pks.add(pkcolumns.getString(4));
            }
            columns = metadata.getColumns(catalog, schema, tname, null);
            while (columns.next()) {
                String column = columns.getString(4);
                ColumnInfo cinfo = new ColumnInfo();
                cinfo.setName(column);
                cinfo.setType(columns.getShort(5));
                if (pks.contains(column)) {
                    cinfo.setIsPrimaryKey(true);
                }
                results.put(column, cinfo);
            }
            Map<String, ColumnInfo> map = Collections.unmodifiableMap(results);
            return map;
        }
        finally {
            if (pkcolumns != null) {
                try {
                    pkcolumns.close();
                }
                catch (SQLException sqle) {}
            }
            if (columns != null) {
                try {
                    columns.close();
                }
                catch (SQLException sqle) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {}
            }
        }
    }

    public static synchronized void shutdown() throws SQLException {
        if (initialized) {
            dataSource = null;
            initialized = false;
        }
    }

    private static synchronized void initialize() throws SQLException {
        if (initialized) {
            return;
        }
        try {
            String jndiName = ConfigurationManager.getProperty("db.jndi");
            if (!StringUtils.isEmpty((String)jndiName)) {
                try {
                    InitialContext ctx = new InitialContext();
                    javax.naming.Context env = ctx == null ? null : (javax.naming.Context)ctx.lookup("java:/comp/env");
                    dataSource = (DataSource)(env == null ? null : env.lookup(jndiName));
                }
                catch (Exception e) {
                    log.error((Object)("Error retrieving JNDI context: " + jndiName), (Throwable)e);
                }
                if (dataSource != null) {
                    if (isOracle) {
                        sqlOnBorrow = "ALTER SESSION SET current_schema=" + ConfigurationManager.getProperty("db.username").trim().toUpperCase();
                    }
                    log.debug((Object)("Using JNDI dataSource: " + jndiName));
                } else {
                    log.info((Object)("Unable to locate JNDI dataSource: " + jndiName));
                }
            }
            if (isOracle && !StringUtils.isEmpty((String)ConfigurationManager.getProperty("db.postgres.schema"))) {
                sqlOnBorrow = "SET SEARCH_PATH TO " + ConfigurationManager.getProperty("db.postgres.schema").trim();
            }
            if (dataSource == null) {
                if (!StringUtils.isEmpty((String)jndiName)) {
                    log.info((Object)"Falling back to creating own Database pool");
                }
                dataSource = DataSourceInit.getDatasource();
            }
            initialized = true;
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            log.warn((Object)"Exception initializing DB pool", (Throwable)e);
            throw new SQLException(e.toString(), e);
        }
    }

    protected static void loadParameters(PreparedStatement statement, Object[] parameters) throws SQLException {
        statement.clearParameters();
        int idx = 1;
        for (Object parameter : parameters) {
            if (parameter instanceof String) {
                statement.setString(idx, (String)parameter);
            } else if (parameter instanceof Long) {
                statement.setLong(idx, (Long)parameter);
            } else if (parameter instanceof Integer) {
                statement.setInt(idx, (Integer)parameter);
            } else if (parameter instanceof Short) {
                statement.setShort(idx, (Short)parameter);
            } else if (parameter instanceof Date) {
                statement.setDate(idx, (Date)parameter);
            } else if (parameter instanceof Time) {
                statement.setTime(idx, (Time)parameter);
            } else if (parameter instanceof Timestamp) {
                statement.setTimestamp(idx, (Timestamp)parameter);
            } else if (parameter instanceof Double) {
                statement.setDouble(idx, (Double)parameter);
            } else if (parameter instanceof Float) {
                statement.setFloat(idx, ((Float)parameter).floatValue());
            } else {
                if (parameter == null) {
                    throw new SQLException("Attempting to insert null value into SQL query.");
                }
                throw new SQLException("Attempting to insert unknown datatype (" + parameter.getClass().getName() + ") into SQL statement.");
            }
            ++idx;
        }
    }

    private static void loadParameters(PreparedStatement statement, Collection<ColumnInfo> columns, TableRow row) throws SQLException {
        int count = 0;
        block11: for (ColumnInfo info : columns) {
            ++count;
            String column = info.getCanonicalizedName();
            int jdbctype = info.getType();
            if (row.isColumnNull(column)) {
                statement.setNull(count, jdbctype);
                continue;
            }
            switch (jdbctype) {
                case -7: {
                    statement.setBoolean(count, row.getBooleanColumn(column));
                    continue block11;
                }
                case 4: {
                    if (isOracle) {
                        statement.setLong(count, row.getLongColumn(column));
                        continue block11;
                    }
                    statement.setInt(count, row.getIntColumn(column));
                    continue block11;
                }
                case 2: 
                case 3: {
                    statement.setLong(count, row.getLongColumn(column));
                    continue block11;
                }
                case -5: {
                    statement.setLong(count, row.getLongColumn(column));
                    continue block11;
                }
                case 2005: {
                    if (isOracle) {
                        statement.setString(count, row.getStringColumn(column));
                        continue block11;
                    }
                    throw new IllegalArgumentException("Unsupported JDBC type: " + jdbctype);
                }
                case 12: {
                    statement.setString(count, row.getStringColumn(column));
                    continue block11;
                }
                case 91: {
                    statement.setDate(count, new Date(row.getDateColumn(column).getTime()));
                    continue block11;
                }
                case 92: {
                    statement.setTime(count, new Time(row.getDateColumn(column).getTime()));
                    continue block11;
                }
                case 93: {
                    statement.setTimestamp(count, new Timestamp(row.getDateColumn(column).getTime()));
                    continue block11;
                }
            }
            throw new IllegalArgumentException("Unsupported JDBC type: " + jdbctype);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int doInsertPostgres(Context context, TableRow row) throws SQLException {
        String table = row.getTable();
        Collection<ColumnInfo> info = DatabaseManager.getColumnInfo(table);
        ArrayList<ColumnInfo> params = new ArrayList<ColumnInfo>();
        String primaryKey = DatabaseManager.getPrimaryKeyColumn(table);
        String sql = insertSQL.get(table);
        boolean firstColumn = true;
        boolean foundPrimaryKey = false;
        if (sql == null) {
            StringBuilder insertBuilder = new StringBuilder("INSERT INTO ").append(table).append(" ( ");
            StringBuilder valuesBuilder = new StringBuilder(") VALUES ( ");
            for (ColumnInfo col : info) {
                if (firstColumn) {
                    firstColumn = false;
                } else {
                    insertBuilder.append(",");
                    valuesBuilder.append(",");
                }
                insertBuilder.append(col.getName());
                if (!foundPrimaryKey && col.isPrimaryKey()) {
                    valuesBuilder.append("getnextid('").append(table).append("')");
                    foundPrimaryKey = true;
                    continue;
                }
                valuesBuilder.append('?');
                params.add(col);
            }
            sql = insertBuilder.append(valuesBuilder.toString()).append(") RETURNING ").append(DatabaseManager.getPrimaryKeyColumn(table)).toString();
            insertSQL.put(table, sql);
        } else {
            for (ColumnInfo col : info) {
                if (!foundPrimaryKey && col.isPrimaryKey()) {
                    foundPrimaryKey = true;
                    continue;
                }
                params.add(col);
            }
        }
        PreparedStatement statement = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running query \"" + sql + "\""));
        }
        ResultSet rs = null;
        try {
            statement = context.getDBConnection().prepareStatement(sql);
            DatabaseManager.loadParameters(statement, params, row);
            rs = statement.executeQuery();
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int doInsertGeneric(Context context, TableRow row) throws SQLException {
        int newID = -1;
        String table = row.getTable();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            if (isOracle) {
                statement = context.getDBConnection().prepareStatement("SELECT " + table + "_seq" + ".nextval FROM dual");
            } else {
                statement = context.getDBConnection().prepareStatement("SELECT getnextid(?) AS result");
                DatabaseManager.loadParameters(statement, new Object[]{table});
            }
            rs = statement.executeQuery();
            rs.next();
            newID = rs.getInt(1);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {}
            }
        }
        if (newID < 0) {
            throw new SQLException("Unable to retrieve sequence ID");
        }
        row.setColumn(DatabaseManager.getPrimaryKeyColumn(table), newID);
        Collection<ColumnInfo> info = DatabaseManager.getColumnInfo(table);
        String sql = insertSQL.get(table);
        if (sql == null) {
            StringBuilder sqlBuilder = new StringBuilder().append("INSERT INTO ").append(table).append(" ( ");
            boolean firstColumn = true;
            for (ColumnInfo col : info) {
                if (firstColumn) {
                    sqlBuilder.append(col.getName());
                    firstColumn = false;
                    continue;
                }
                sqlBuilder.append(",").append(col.getName());
            }
            sqlBuilder.append(") VALUES ( ");
            firstColumn = true;
            for (int i = 0; i < info.size(); ++i) {
                if (firstColumn) {
                    sqlBuilder.append("?");
                    firstColumn = false;
                    continue;
                }
                sqlBuilder.append(",").append("?");
            }
            sqlBuilder.append(")");
            sql = sqlBuilder.toString();
            insertSQL.put(table, sql);
        }
        DatabaseManager.execute(context.getDBConnection(), sql, info, row);
        return newID;
    }

    public static void main(String[] args) {
        String url = ConfigurationManager.getProperty("db.url");
        System.out.println("\nAttempting to connect to database: ");
        System.out.println(" - URL: " + url);
        System.out.println(" - Driver: " + ConfigurationManager.getProperty("db.driver"));
        System.out.println(" - Username: " + ConfigurationManager.getProperty("db.username"));
        System.out.println(" - Password: " + ConfigurationManager.getProperty("db.password"));
        System.out.println(" - Schema: " + ConfigurationManager.getProperty("db.schema"));
        System.out.println("\nTesting connection...");
        try {
            Connection connection = DatabaseManager.getConnection();
            connection.close();
        }
        catch (SQLException sqle) {
            System.err.println("\nError: ");
            System.err.println(" - " + sqle);
            System.err.println("\nPlease see the DSpace documentation for assistance.\n");
            System.exit(1);
        }
        System.out.println("Connected successfully!\n");
    }

    static {
        if ("oracle".equals(ConfigurationManager.getProperty("db.name"))) {
            isOracle = true;
            isPostgres = false;
        } else {
            isOracle = false;
            isPostgres = true;
        }
        dataSource = null;
        sqlOnBorrow = null;
        poolName = "dspacepool";
        DB_SAFE_NAME = Pattern.compile("^[a-zA-Z_1-9.]+$");
        info = new HashMap<String, Map<String, ColumnInfo>>();
    }
}

