/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;

public class DataSourceInit {
    private static Logger log = Logger.getLogger(DataSourceInit.class);
    private static DataSource dataSource = null;

    public static DataSource getDatasource() throws SQLException {
        if (dataSource != null) {
            return dataSource;
        }
        try {
            Class<?> driverClass = Class.forName(ConfigurationManager.getProperty("db.driver"));
            Driver basicDriver = (Driver)driverClass.newInstance();
            DriverManager.registerDriver(basicDriver);
            int maxConnections = ConfigurationManager.getIntProperty("db.maxconnections");
            if (ConfigurationManager.getProperty("db.maxconnections") == null) {
                maxConnections = 30;
            }
            int maxWait = ConfigurationManager.getIntProperty("db.maxwait");
            if (ConfigurationManager.getProperty("db.maxwait") == null) {
                maxWait = 5000;
            }
            int maxIdle = ConfigurationManager.getIntProperty("db.maxidle");
            if (ConfigurationManager.getProperty("db.maxidle") == null) {
                maxIdle = -1;
            }
            boolean useStatementPool = ConfigurationManager.getBooleanProperty("db.statementpool", true);
            GenericObjectPool connectionPool = new GenericObjectPool(null, maxConnections, 1, (long)maxWait, maxIdle, true, false);
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(ConfigurationManager.getProperty("db.url"), ConfigurationManager.getProperty("db.username"), ConfigurationManager.getProperty("db.password"));
            String validationQuery = "SELECT 1";
            if ("oracle".equals(ConfigurationManager.getProperty("db.name"))) {
                validationQuery = "SELECT 1 FROM DUAL";
            }
            GenericKeyedObjectPoolFactory statementFactory = null;
            if (useStatementPool) {
                GenericKeyedObjectPool.Config statementFactoryConfig = new GenericKeyedObjectPool.Config();
                statementFactoryConfig.whenExhaustedAction = (byte)2;
                statementFactory = new GenericKeyedObjectPoolFactory(null, statementFactoryConfig);
            }
            PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, statementFactory, validationQuery, false, false);
            PoolingDataSource poolingDataSource = new PoolingDataSource();
            poolingDataSource.setPool((ObjectPool)connectionPool);
            dataSource = poolingDataSource;
            return poolingDataSource;
        }
        catch (Exception e) {
            log.warn((Object)"Exception initializing DB pool", (Throwable)e);
            throw new SQLException(e.toString(), e);
        }
    }
}

