/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.dspace.app.mediafilter.Brand;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.app.mediafilter.MediaFilterManager;
import org.dspace.core.ConfigurationManager;

public class BrandedPreviewJPEGFilter
extends MediaFilter {
    @Override
    public String getFilteredName(String oldFilename) {
        return oldFilename + ".preview.jpg";
    }

    @Override
    public String getBundleName() {
        return "BRANDED_PREVIEW";
    }

    @Override
    public String getFormatString() {
        return "JPEG";
    }

    @Override
    public String getDescription() {
        return "Generated Branded Preview";
    }

    @Override
    public InputStream getDestinationStream(InputStream source) throws Exception {
        float scaleFactor;
        BufferedImage buf = ImageIO.read(source);
        float xmax = ConfigurationManager.getIntProperty("webui.preview.maxwidth");
        float ymax = ConfigurationManager.getIntProperty("webui.preview.maxheight");
        int brandHeight = ConfigurationManager.getIntProperty("webui.preview.brand.height");
        String brandFont = ConfigurationManager.getProperty("webui.preview.brand.font");
        int brandFontPoint = ConfigurationManager.getIntProperty("webui.preview.brand.fontpoint");
        float xsize = buf.getWidth(null);
        float ysize = buf.getHeight(null);
        if (MediaFilterManager.isVerbose) {
            System.out.println("original size: " + xsize + "," + ysize);
        }
        if (xsize > xmax) {
            scaleFactor = xmax / xsize;
            if (MediaFilterManager.isVerbose) {
                System.out.println("x scale factor: " + scaleFactor);
            }
            xsize *= scaleFactor;
            ysize *= scaleFactor;
            if (MediaFilterManager.isVerbose) {
                System.out.println("new size: " + xsize + "," + ysize);
            }
        }
        if (ysize > ymax) {
            scaleFactor = ymax / ysize;
            xsize *= scaleFactor;
            ysize *= scaleFactor;
        }
        if (MediaFilterManager.isVerbose) {
            System.out.println("created thumbnail size: " + xsize + ", " + ysize);
        }
        BufferedImage branded = new BufferedImage((int)xsize, (int)ysize + brandHeight, 1);
        Graphics2D g2d = branded.createGraphics();
        g2d.drawImage(buf, 0, 0, (int)xsize, (int)ysize, null);
        Brand brand = new Brand((int)xsize, brandHeight, new Font(brandFont, 0, brandFontPoint), 5);
        BufferedImage brandImage = brand.create(ConfigurationManager.getProperty("webui.preview.brand"), ConfigurationManager.getProperty("webui.preview.brand.abbrev"), MediaFilterManager.getCurrentItem() == null ? "" : "hdl:" + MediaFilterManager.getCurrentItem().getHandle());
        g2d.drawImage(brandImage, 0, (int)ysize, (int)xsize, 20, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)branded, "jpeg", baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return bais;
    }
}

