/**
 * $Id: AuthzDoNotCareException.java 3497 2009-02-25 17:39:08Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/providers/exception/AuthzDoNotCareException.java $
 * AuthzDoNotCareException.java - DS2 - Feb 25, 2009 2:23:54 PM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.providers.exception;


/**
 * This exception is just an indicator that the authz provider does not care if the
 * given user has the given permission for the given resource, this will cause the checks
 * to continue down the stack until someone responds with a clear allowed (true) or
 * not allowed (false), if all providers respond with "do not care" then the user is
 * allowed access
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public class AuthzDoNotCareException extends RuntimeException {

    public AuthzDoNotCareException(String message, Throwable cause) {
        super(message, cause);
    }

    public AuthzDoNotCareException(String message) {
        super(message);
    }

}
