/**
 * $Id: UserService.java 3497 2009-02-25 17:39:08Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/services/UserService.java $
 * UserService.java - DSpace2 - Oct 13, 2008 11:26:38 AM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.services;

import java.util.Locale;

import org.dspace.services.mixins.UserAuthenticationService;
import org.dspace.services.mixins.UserAuthorizationService;
import org.dspace.services.mixins.UserLookupService;

/**
 * This is the core user service which is generally responsible for handling everything
 * related to users in the system, this includes authentication, user info lookup,
 * access to the current user for the current thread and some session handling <br/>
 * <br/>
 * Note: this is not using a true mixin model as all user related interfaces are included here in extends
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public interface UserService extends UserLookupService, UserAuthenticationService, UserAuthorizationService {

    public static final String USER_KEY = "user";
    public static final String USER_REF_PREFIX = "/"+USER_KEY+"/";

    /**
     * Finds the current user in the current thread being used to access this method,
     * note that it is possible for a thread to have no current user if this is before
     * authentication or this is being accessed anonymously or being run internal to the system
     * and not as part of a request
     * 
     * @return the internal user id of the current user
     */
    public String getCurrentUserId();

    /**
     * Get the locale for a user
     * 
     * @param userId the internal user id (not username or EID)
     * @return the Locale for this user based on their preferences
     */
    public Locale getUserLocale(String userId);

}
