/**
 * $Id: StorageReadException.java 3442 2009-02-06 15:18:11Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/services/exceptions/StorageReadException.java $
 * StorageReadException.java - DS2 - Feb 4, 2009 5:33:49 PM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.services.exceptions;


/**
 * Indicates a failure has occurred while trying to read from the repository,
 * this is likely to be caused by invalid paths
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public class StorageReadException extends StorageException {

    public StorageReadException(String message, Throwable cause) {
        super(message, cause);
    }

    public StorageReadException(String message) {
        super(message);
    }

}
