/**
 * $Id: StorageMovable.java 3443 2009-02-06 15:38:18Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/services/mixins/StorageMovable.java $
 * StorageMovable.java - DS2 - Feb 6, 2009 10:54:41 AM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.services.mixins;

import org.dspace.services.exceptions.StorageWriteException;

/**
 * Allows storage entities to be moved around and renamed <br/>
 * One of the mixins for the storage service
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public interface StorageMovable extends StorageWriteable {

    /**
     * Moves a storage entity to a new path, will also move all child entities at the same time,
     * this will also allow a storage entity to be renamed
     * 
     * @param reference the unique reference (path + name) of the given entity (e.g. trees/apple/golden_delicious)
     * @param newPath (optional) the path to move this item to OR null if the path is not changing
     * @param newName (optional) the new name for this storage entity OR null if the name is not changing
     * @return the new reference to the storage entity
     * @throws IllegalArgumentException if any of the required arguments are null or invalid
     * @throws StorageInvalidReferenceException if the given reference does not exist
     * @throws StorageInvalidPathException if the newPath does not exist or there is already something with the name/newName at this path
     * @throws StorageWriteException if the move operation fails internally in the storage system
     */
    public String moveEntity(String reference, String newPath, String newName);

}
