/**
 * $Id: StorageSearchable.java 3476 2009-02-12 16:37:41Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/services/mixins/StorageSearchable.java $
 * StorageMovable.java - DS2 - Feb 6, 2009 10:54:41 AM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.services.mixins;

import java.util.List;

import org.dspace.services.StorageService;
import org.dspace.services.exceptions.StorageReadException;
import org.dspace.services.model.StorageEntity;

/**
 * Allows storage entities to be searched for and retrieved efficiently (paging and filtering) <br/>
 * One of the mixins for the storage service
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public interface StorageSearchable extends StorageService {

    /**
     * Get a list of all storage entities according to the given search,
     * searches can limit the number of results returned and also can control sort order
     * 
     * @param search the search object which defines which storage entities should be retrieved
     * @return a list of storage entity objects based on the given search (may be empty but will not be null)
     * @throws IllegalArgumentException if the search is null
     * @throws StorageReadException if there is an internal storage system failure
     */
    public List<StorageEntity> getEntitiesBySearch(StorageSearch search);

}
