/**
 * $Id: StorageVersion.java 3442 2009-02-06 15:18:11Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/services/mixins/StorageVersion.java $
 * StorageVersion.java - DS2 - Feb 6, 2009 2:35:08 PM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.services.mixins;

import java.io.Serializable;
import java.util.Calendar;


/**
 * This represents the version information for a storage entity
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public class StorageVersion implements Serializable {

    private static final long serialVersionUID = 2L;

    private String versionName;
    private String reference;
    private Calendar created;
    private String label;

    public StorageVersion(String versionName, String reference, Calendar created, String label) {
        super();
        this.versionName = versionName;
        this.reference = reference;
        this.created = created;
        this.label = label;
    }

    public String getVersionName() {
        return versionName;
    }

    public String getReference() {
        return reference;
    }

    public Calendar getCreated() {
        return created;
    }

    public String getLabel() {
        return label;
    }

}
