/**
 * $Id: UserAuthenticationService.java 3194 2008-10-14 10:32:57Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/services/mixins/UserAuthenticationService.java $
 * UserAuthenticationService.java - DSpace2 - Oct 13, 2008 11:08:04 AM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.services.mixins;

import org.dspace.providers.exception.AuthenticationException;
import org.dspace.services.model.Evidence;
import org.dspace.services.model.EvidencePassword;
import org.dspace.services.model.EvidenceTrusted;

/**
 * This service authenticates users and is a mixin for the overall user service
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public interface UserAuthenticationService {

    /**
     * Attempt to authenticate and identify a user by the given authentication evidence. 
     * Success produces the authenticated internal user id.
     * 
     * @param evidence the information used to authenticate the user,
     * this will be a {@link EvidencePassword} or {@link EvidenceTrusted} in most cases
     * @return the internal userId of the authenticated user (this must not return null or empty string)
     * @throws AuthenticationException if the evidence is not understood or invalid
     */
    String authenticate(Evidence evidence) throws AuthenticationException;

}
