/**
 * $Id: Evidence.java 3210 2008-10-16 11:15:26Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/services/model/Evidence.java $
 * Evidence.java - DSpace2 - Oct 13, 2008 11:10:16 AM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.services.model;

import java.security.Principal;

/**
 * This is the Evidence interface which all types of evidence must implement,
 * includes support for java security Principal
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public interface Evidence extends Principal {

    /**
     * Defines the set of user EID types that the system is known to be able to handle
     */
    public static enum UserEidType {USERNAME, INTERNAL_ID, EMAIL, ENTERPRISE_ID};

    /**
     * @return the user external/enterprise id (often login id) which this evidence refers to,
     * this may be the internal user id if the internal and EIDs match
     */
    String getUserEid();

    /**
     * @return the type of external/enterprise user id being used here
     */
    UserEidType getUserEidType();

}
