/**
 * $Id: EvidenceTrusted.java 3308 2008-11-19 20:16:31Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/services/model/EvidenceTrusted.java $
 * EvidenceTrusted.java - DSpace2 - Oct 13, 2008 11:34:45 AM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.services.model;

/**
 * This is evidence from a trusted source, no password or keys are required, the user will be
 * authenticated as long as the eid is valid
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public class EvidenceTrusted implements Evidence {

    private String userEid;
    private UserEidType userEidType = UserEidType.USERNAME;

    /* (non-Javadoc)
     * @see java.security.Principal#getName()
     */
    public String getName() {
        return userEid;
    }

    /*
     * (non-Javadoc)
     * @see org.dspace.services.model.Evidence#getUserEid()
     */
    public String getUserEid() {
        return userEid;
    }

    public org.dspace.services.model.Evidence.UserEidType getUserEidType() {
        return userEidType;
    }

    public EvidenceTrusted(String userEid) {
        super();
        this.userEid = userEid;
    }

    public EvidenceTrusted(String userEid,
            org.dspace.services.model.Evidence.UserEidType userEidType) {
        super();
        this.userEid = userEid;
        this.userEidType = userEidType;
    }

    public void setUserEid(String userEid) {
        this.userEid = userEid;
    }

    public void setUserEidType(UserEidType userEidType) {
        this.userEidType = userEidType;
    }

    @Override
    public String toString() {
    	return "trusted:"+userEid+"("+userEidType+")";
    }

}
