/**
 * $Id: IdEidMap.java 3678 2009-04-06 12:45:44Z grahamtriggs $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/services/model/IdEidMap.java $
 * IdEidMap.java - DSpace2 - Nov 17, 2008 3:59:38 PM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.services.model;

import java.io.Serializable;
import java.util.Date;

/**
 * This represents a single mapping from an internal id to an external id
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public class IdEidMap implements Serializable {
	private static final long serialVersionUID = 1L;

    private Integer id;
    private Date createdOn;
    private Date lastModified;
    private String mappedType;
    private String mappedId;
    private String mappedEid;

    public IdEidMap() {} // default constructor needed for reflection

    public IdEidMap(String mappedType, String mappedId, String mappedEid) {
        if (mappedType == null || "".equals(mappedType) 
                || mappedId == null || "".equals(mappedId)
                || mappedEid == null || "".equals(mappedEid)) {
            throw new IllegalArgumentException("None of the inputs can be null or blank: type=" + mappedType + ":id=" + mappedId + ":eid=" + mappedEid);
        }
        this.mappedType = mappedType;
        this.mappedId = mappedId;
        this.mappedEid = mappedEid;
        this.id = null; // default to null
        this.createdOn = new Date();
        this.lastModified = this.createdOn;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getCreatedOn() {
        return new Date(createdOn.getTime());
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = new Date(createdOn.getTime());
    }

    public Date getLastModified() {
        return new Date(lastModified.getTime());
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = new Date(lastModified.getTime());
    }

    public String getMappedType() {
        return mappedType;
    }

    public void setMappedType(String mappedType) {
        this.mappedType = mappedType;
    }

    public String getMappedId() {
        return mappedId;
    }

    public void setMappedId(String mappedId) {
        this.mappedId = mappedId;
    }

    public String getMappedEid() {
        return mappedEid;
    }

    public void setMappedEid(String mappedEid) {
        this.mappedEid = mappedEid;
    }

    @Override
    public boolean equals(Object obj) {
        if (null == obj)
            return false;
        if (!(obj instanceof IdEidMap))
            return false;
        else {
            IdEidMap castObj = (IdEidMap) obj;
            boolean eq = (this.id == null ? castObj.id == null : this.id.equals(castObj.id))
            && (this.mappedType == null ? false : this.mappedType.equals(castObj.mappedType))
            && (this.mappedId == null ? false : this.mappedId.equals(castObj.mappedId))
            && (this.mappedEid == null ? false : this.mappedEid.equals(castObj.mappedEid));
            return eq;
        }
    }

    @Override
    public int hashCode() {
        String hashStr = this.getClass().getName() + ":" + this.id + ":" + this.mappedType + ":" + this.mappedId;
        return hashStr.hashCode();
    }

    @Override
    public String toString() {
        return "idEid("+this.id+")["+this.mappedType+"]:"+this.mappedId+"=>"+this.mappedEid; //+": "+super.toString();
    }

}
