package org.dspace.services.model;

import java.io.Serializable;

/**
 * DSpace object that represents a metadata field, which is defined by a
 * combination of schema, element, and qualifier. Every metadata element belongs
 * in a field.
 * 
 * @author Martin Hald
 * @author mdiggory
 * 
 * @version $Revision: 3036 $
 */
public class MetadataField implements Serializable {

    private static final long serialVersionUID = -3543576596088675101L;
    
    protected String id;
	protected String prefix;
	protected String name;
	protected String description;

    /**
	 * Default Constructor
	 */
	public MetadataField() {
		super();
	}

    /**
     * Full construtor for existing metadata field elements.
     * @param id database ID of field.
     * @param prefix schema to which the field belongs
     * @param name element of the field
     * @param description scope note of the field
     */
    public MetadataField(String id, String prefix, String name, String description)
    {
        this.id = id;
        this.prefix = prefix;
        this.name = name;
        this.description = description;
    }
    
    /**
     * Full construtor for existing metadata field elements.
     * @param prefix schema to which the field belongs
     * @param name element of the field
     * @param description scope note of the field
     */
    public MetadataField(String prefix, String name, String description)
    {
        this.prefix = prefix;
        this.name = name;
        this.description = description;
    }

    /**
	 * Get the element name.
	 * @return element name
	 */
	public String getName() {
	    return name;
	}

	/**
	 * Set the element name.
	 * @param element new value for element
	 */
	public void setName(String element) {
	    this.name = element;
	}

	/**
	 * Get the metadata field id.
	 * @return metadata field id
	 */
	public String getId() {
	    return id;
	}

	/**
	 * Set the Id for the Field
	 * @param id
	 */
    public void setId(String id)
    {
        this.id = id;
    }
    
	/**
	 * Get the schema record key.
	 * @return schema record key
	 */
	public String getPrefix() {
	    return prefix;
	}

	/**
	 * Set the schema record key.
	 * @param schemaID new value for key
	 */
	public void setPrefix(String prefix) {
	    this.prefix = prefix;
	}

	/**
	 * Get the scope note.
	 * @return scope note
	 */
	public String getDescription() {
	    return description;
	}

	/**
	 * Set the scope note.
	 * @param description new value for scope note
	 */
	public void setDescription(String description) {
	    this.description = description;
	}


    @Override
    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof MetadataField)) {
            return false;
        } else {
            MetadataField castObj = (MetadataField) obj;
            boolean eq = (this.name == null ? castObj.name == null : this.name.equals(castObj.name))
            && (this.prefix == null ? castObj.prefix == null : this.prefix.equals(castObj.prefix));
            return eq;
        }
    }
    
    @Override
    public int hashCode() {
        String hashStr = this.getClass().getName() + ":" + this.prefix + ":" + this.name;
        return hashStr.hashCode();
    }

    @Override
    public String toString() {
        return this.prefix + ":" + this.name;
    }

}