package org.dspace.services.model;

import java.io.Serializable;

/**
 * Class representing a schema in DSpace.
 * <p>
 * The schema object exposes a name which can later be used to generate
 * namespace prefixes in RDF or XML, e.g. the core DSpace Dublin Core schema
 * would have a name of <code>'dc'</code>.
 * </p>
 * 
 * @author Martin Hald
 * @author mdiggory
 * @version $Revision: 3036 $
 * @see org.dspace.services.model.MetadataField
 */

public class MetadataSchema implements Serializable {

    private static final long serialVersionUID = -6863700073896291662L;

    protected String id;
	
	protected String namespace;
	
	protected String prefix;

	/**
	 * Default constructor
	 */
	public MetadataSchema() {
		super();
	}

	/**
	 * Object constructor.
	 * 
	 * @param schemaID database key ID number
	 * @param namespace XML namespace URI
	 * @param prefix short name of schema
	 */
	public MetadataSchema(String id, String namespace, String prefix) {
		this.id = id;
		this.namespace = namespace;
		this.prefix = prefix;
	}

	/**
	 * Immutable object constructor for creating a new schema.
	 * @param namespace XML namespace URI
	 * @param prefix short name of schema
	 */
	public MetadataSchema(String namespace, String prefix) {
		this.namespace = namespace;
		this.prefix = prefix;
	}

	/*
	 * Constructor for loading the metadata schema from the database.
	 * 
	 * @param row
	 *            table row object from which to populate this schema.
	 * public MetadataSchema(TableRow row) { if (row != null) { this.schemaID =
	 * row.getIntColumn("metadata_schema_id"); this.namespace =
	 * row.getStringColumn("namespace"); this.name =
	 * row.getStringColumn("short_id"); this.row = row; } }
	 */

	/**
	 * Get the schema namespace.
	 * @return namespace String
	 */
	public String getNamespace() {
		return namespace;
	}

	/**
	 * Set the schema namespace.
	 * @param namespace XML namespace URI
	 */
	public void setNamespace(String namespace) {
		this.namespace = namespace;
	}

	/**
	 * Get the schema prefix.
	 * @return name String
	 */
	public String getPrefix() {
		return prefix;
	}

	/**
	 * Set the schema prefix.
	 * @param name - short name of schema
	 */
	public void setPrefix(String name) {
		this.prefix = name;
	}

	/**
	 * Get the schema record key number.
	 * @return schema record key
	 */
	public String getId() {
		return id;
	}

    public void setId(String id)
    {
        this.id = id;
    }

    @Override
    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof MetadataSchema)) {
            return false;
        } else {
            MetadataSchema castObj = (MetadataSchema) obj;
            boolean eq = (this.prefix == null ? castObj.prefix == null : this.prefix.equals(castObj.prefix))
            && (this.namespace == null ? castObj.namespace == null : this.namespace.equals(castObj.namespace));
            return eq;
        }
    }
    
    @Override
    public int hashCode() {
        String hashStr = this.getClass().getName() + ":" + this.prefix + ":" + this.namespace;
        return hashStr.hashCode();
    }

    @Override
    public String toString() {
        return "schema::id=" + this.id + ":prefix=" + this.prefix + ":namespace="
        + this.namespace;
    }
    
}