/*
 * $URL: $
 * 
 * $Revision: $
 * 
 * $Date: $
 *
 * Copyright (c) 2008, The DSpace Foundation.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * - Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * - Neither the name of the DSpace Foundation nor the names of its 
 * contributors may be used to endorse or promote products derived from 
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
package org.dspace.services.model.metadata;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/**
 * @author mdiggory
 * 
 */
public class DescriptionTemplate
{

    protected List<String> resourceClass;

    protected List<StatementTemplate> statementTemplate;

    protected String id;

    protected Standalone standalone;

    protected BigInteger maxOccurs;

    protected BigInteger minOccurs;

    /**
     * Classes that the resource may be an instance of
     * 
     * Allowed values a list of class URIs
     * 
     * Default no constraint
     * 
     * Conditions if given, the resource must be an instance of one of the given
     * classes.
     * 
     * XML Element Name ResourceClass
     * 
     * @return resource classes
     */
    public List<String> getResourceClass()
    {
        if (resourceClass == null)
        {
            resourceClass = new ArrayList<String>();
        }
        return this.resourceClass;
    }

    /**
     * @return statment templates
     */
    public List<StatementTemplate> getStatementTemplate()
    {
        if (statementTemplate == null)
        {
            statementTemplate = new ArrayList<StatementTemplate>();
        }
        return this.statementTemplate;
    }

    /**
     * Summary A string that can be used in a Value Constraint to reference a
     * description template that applies to the value resource.
     * 
     * Allowed values A valid XML ID string. Default N/A XML Attribute Name: ID
     * 
     * @return The ID of the DescriptionSet
     */
    public String getID()
    {
        return id;
    }

    /**
     * 
     * @param value
     *            TO set as the ID of the Description Set
     */
    public void setID(String value)
    {
        this.id = value;
    }

    /**
     * Summary Whether descriptions matching this template are allowed to occur
     * standalone, i.e. without being the value of a property.
     * 
     * Allowed values "yes" / "no" / "both"
     * 
     * Default "both"
     * 
     * Conditions
     * 
     * If standalone is "yes", a matching description may not be a description
     * of value occurring elsewhere in the DSP.
     * 
     * If standalone is "no", a matching description *must* be a description of
     * value occurring elsewhere in the DSP.
     * 
     * If standalone is "both", both are allowed. If this description template
     * is referred to in a Value Constraint, standalone cannot be "yes".
     * 
     * XML Attribute Name standalone
     * 
     * @return Standalone status
     */
    public Standalone getStandalone()
    {
        return standalone;
    }

    /**
     * 
     * @param value
     */
    public void setStandalone(Standalone value)
    {
        this.standalone = value;
    }

    /**
     * 
     * @return max occures
     */
    public BigInteger getMaxOccurs()
    {
        return maxOccurs;
    }

    /**
     * 
     * @param value
     */
    public void setMaxOccurs(BigInteger value)
    {
        this.maxOccurs = value;
    }

    /**
     * 
     * @return min occurs
     */
    public BigInteger getMinOccurs()
    {
        return minOccurs;
    }

    /**
     * 
     * @param value
     */
    public void setMinOccurs(BigInteger value)
    {
        this.minOccurs = value;
    }

}