/*
 * $URL: $
 * 
 * $Revision: $
 * 
 * $Date: $
 *
 * Copyright (c) 2008, The DSpace Foundation.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * - Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * - Neither the name of the DSpace Foundation nor the names of its 
 * contributors may be used to endorse or promote products derived from 
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
package org.dspace.services.model.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * @author mdiggory
 * 
 */
public class LiteralConstraint
{

    protected List<LiteralOption> literalOption;

    protected Occurrence languageOccurrence;

    protected List<Locale> language;

    protected Occurrence syntaxEncodingSchemeOccurrence;

    protected List<String> syntaxEncodingScheme;

    /**
     * 
     * @return Literal Option
     */
    public List<LiteralOption> getLiteralOption()
    {
        if (literalOption == null)
        {
            literalOption = new ArrayList<LiteralOption>();
        }
        return this.literalOption;
    }

    /**
     * 
     * @return Language Occurance
     */
    public Occurrence getLanguageOccurrence()
    {
        return languageOccurrence;
    }

    /**
     * 
     * @param value
     */
    public void setLanguageOccurrence(Occurrence value)
    {
        this.languageOccurrence = value;
    }

    /**
     * @return Language
     */
    public List<Locale> getLanguage()
    {
        if (language == null)
        {
            language = new ArrayList<Locale>();
        }
        return this.language;
    }

    /**
     * @return Syntax Encoding Scheme
     */
    public Occurrence getSyntaxEncodingSchemeOccurrence()
    {
        return syntaxEncodingSchemeOccurrence;
    }

    /**
     * @param value
     */
    public void setSyntaxEncodingSchemeOccurrence(Occurrence value)
    {
        this.syntaxEncodingSchemeOccurrence = value;
    }

    /**
     * @return Syntax Encoding Scheme
     */
    public List<String> getSyntaxEncodingScheme()
    {
        if (syntaxEncodingScheme == null)
        {
            syntaxEncodingScheme = new ArrayList<String>();
        }
        return this.syntaxEncodingScheme;
    }

}
