/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.dspace.statistics.util.SpiderDetector;

public class ApacheLogRobotsProcessor {
    public static void main(String[] args) throws Exception {
        String logLine;
        BufferedWriter output;
        Set<Object> logSpiders;
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("l", "logfile", true, "type: Input log file");
        options.addOption("s", "spiderfile", true, "type: Spider IP file");
        CommandLine line = parser.parse(options, args);
        String logFileLoc = line.hasOption("l") ? line.getOptionValue("l") : "-";
        String spiderIpPath = line.hasOption("s") ? line.getOptionValue("s") : "-";
        if ("-".equals(spiderIpPath)) {
            logSpiders = new HashSet();
            output = new BufferedWriter(new OutputStreamWriter(System.out));
        } else {
            File spiderIpFile = new File(spiderIpPath);
            logSpiders = spiderIpFile.exists() ? SpiderDetector.readIpAddresses(spiderIpFile) : new HashSet();
            output = new BufferedWriter(new FileWriter(spiderIpFile));
        }
        BufferedReader in = "-".equals(logFileLoc) ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(logFileLoc));
        while ((logLine = in.readLine()) != null) {
            if (!logLine.contains("robots.txt")) continue;
            String ip = logLine.substring(0, logLine.indexOf(45)).trim();
            logSpiders.add(ip);
        }
        in.close();
        for (String string : logSpiders) {
            System.err.println("Adding new ip: " + string);
            output.write(string + "\n");
        }
        ((Writer)output).flush();
        ((Writer)output).close();
    }
}

