/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.storage.bitstore.BitstreamStorageManager;

public abstract class AbstractVersionProvider {
    protected void copyMetadata(Item itemNew, Item nativeItem) {
        DCValue[] md;
        for (DCValue aMd : md = nativeItem.getMetadata("*", "*", "*", "*")) {
            if (aMd.schema.equals("dc") && aMd.element.equals("relation") && aMd.qualifier != null && aMd.qualifier.equals("haspart") || aMd.schema.equals("dc") && aMd.element.equals("relation") && aMd.qualifier != null && aMd.qualifier.equals("ispartof") || aMd.schema.equals("dc") && aMd.element.equals("identifier") || aMd.schema.equals("dc") && aMd.element.equals("relation") && aMd.qualifier != null && aMd.qualifier.equals("isversionof") || aMd.schema.equals("dc") && aMd.element.equals("date") && aMd.qualifier != null && aMd.qualifier.equals("accessioned") || aMd.schema.equals("dc") && aMd.element.equals("date") && aMd.qualifier != null && aMd.qualifier.equals("available") || aMd.schema.equals("dc") && aMd.element.equals("description") && aMd.qualifier != null && aMd.qualifier.equals("provenance")) continue;
            itemNew.addMetadata(aMd.schema, aMd.element, aMd.qualifier, aMd.language, aMd.value);
        }
    }

    protected void createBundlesAndAddBitstreams(Context c, Item itemNew, Item nativeItem) throws SQLException, AuthorizeException {
        for (Bundle nativeBundle : nativeItem.getBundles()) {
            Bundle bundleNew = itemNew.createBundle(nativeBundle.getName());
            for (Bitstream nativeBitstream : nativeBundle.getBitstreams()) {
                Bitstream bitstreamNew = this.createBitstream(c, nativeBitstream);
                bundleNew.addBitstream(bitstreamNew);
                if (nativeBundle.getPrimaryBitstreamID() != nativeBitstream.getID()) continue;
                bundleNew.setPrimaryBitstreamID(bitstreamNew.getID());
            }
        }
    }

    protected Bitstream createBitstream(Context context, Bitstream nativeBitstream) throws AuthorizeException, SQLException {
        int idNew = BitstreamStorageManager.clone(context, nativeBitstream.getID());
        return Bitstream.find(context, idNew);
    }
}

