/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.util.HashSet;
import java.util.Set;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersioningService;

public class VersioningConsumer
implements Consumer {
    private static Set<Item> itemsToProcess;

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void finish(Context ctx) throws Exception {
    }

    @Override
    public void consume(Context ctx, Event event) throws Exception {
        Item previousItem;
        Version latest;
        Version previous;
        VersionHistory history;
        Item item;
        if (itemsToProcess == null) {
            itemsToProcess = new HashSet<Item>();
        }
        int st = event.getSubjectType();
        int et = event.getEventType();
        if (st == 2 && et == 64 && (item = (Item)event.getSubject(ctx)) != null && item.isArchived() && (history = VersioningConsumer.retrieveVersionHistory(ctx, item)) != null && (previous = history.getPrevious(latest = history.getLatestVersion())) != null && (previousItem = previous.getItem()) != null) {
            itemsToProcess.add(previousItem);
            ctx.addEvent(new Event(2, previousItem.getType(), previousItem.getID(), null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Context ctx) throws Exception {
        if (itemsToProcess != null) {
            for (Item item : itemsToProcess) {
                ctx.turnOffAuthorisationSystem();
                try {
                    item.setArchived(false);
                    item.update();
                }
                finally {
                    ctx.restoreAuthSystemState();
                }
            }
            ctx.getDBConnection().commit();
        }
        itemsToProcess = null;
    }

    private static VersionHistory retrieveVersionHistory(Context c, Item item) {
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        return versioningService.findVersionHistory(c, item.getID());
    }
}

