/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions.processingaction;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCDate;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.XmlWorkflowManager;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.processingaction.ProcessingAction;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class SingleUserReviewAction
extends ProcessingAction {
    public static final int MAIN_PAGE = 0;
    public static final int REJECT_PAGE = 1;
    public static final int OUTCOME_REJECT = 1;

    @Override
    public void activate(Context c, XmlWorkflowItem wfItem) {
    }

    @Override
    public ActionResult execute(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        int page = Util.getIntParameter(request, "page");
        switch (page) {
            case 0: {
                return this.processMainPage(c, wfi, step, request);
            }
            case 1: {
                return this.processRejectPage(c, wfi, step, request);
            }
        }
        return new ActionResult(ActionResult.TYPE.TYPE_CANCEL);
    }

    public ActionResult processMainPage(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException {
        if (request.getParameter("submit_approve") != null) {
            this.addApprovedProvenance(c, wfi);
            return new ActionResult(ActionResult.TYPE.TYPE_OUTCOME, 0);
        }
        if (request.getParameter("submit_reject") != null) {
            request.setAttribute("page", (Object)1);
            return new ActionResult(ActionResult.TYPE.TYPE_PAGE);
        }
        if (request.getParameter("submit_decline_task") != null) {
            return new ActionResult(ActionResult.TYPE.TYPE_OUTCOME, 1);
        }
        return new ActionResult(ActionResult.TYPE.TYPE_SUBMISSION_PAGE);
    }

    private void addApprovedProvenance(Context c, XmlWorkflowItem wfi) throws SQLException, AuthorizeException {
        String now = DCDate.getCurrent().toString();
        String usersName = XmlWorkflowManager.getEPersonName(c.getCurrentUser());
        String provDescription = this.getProvenanceStartId() + " Approved for entry into archive by " + usersName + " on " + now + " (GMT) ";
        wfi.getItem().addMetadata("dc", "description", "provenance", "en", provDescription);
        wfi.getItem().update();
    }

    public ActionResult processRejectPage(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        if (request.getParameter("submit_reject") != null) {
            String reason = request.getParameter("reason");
            if (reason == null || 0 == reason.trim().length()) {
                request.setAttribute("page", (Object)1);
                SingleUserReviewAction.addErrorField(request, "reason");
                return new ActionResult(ActionResult.TYPE.TYPE_ERROR);
            }
            XmlWorkflowManager.sendWorkflowItemBackSubmission(c, wfi, c.getCurrentUser(), this.getProvenanceStartId(), reason);
            return new ActionResult(ActionResult.TYPE.TYPE_SUBMISSION_PAGE);
        }
        request.setAttribute("page", (Object)0);
        return new ActionResult(ActionResult.TYPE.TYPE_PAGE);
    }
}

