/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.jdom.Element;

public class GoogleMetadata {
    private static final Logger log = Logger.getLogger(GoogleMetadata.class);
    private static final String GOOGLE_PREFIX = "google.";
    private Item item;
    private String itemURL;
    private static Map<String, String> configuredFields = new HashMap<String, String>();
    private Map<String, String> metadataMappings = new HashMap<String, String>();
    public static final String TITLE = "citation_title";
    public static final String JOURNAL_TITLE = "citation_journal_title";
    public static final String PUBLISHER = "citation_publisher";
    public static final String AUTHORS = "citation_authors";
    public static final String DATE = "citation_date";
    public static final String VOLUME = "citation_volume";
    public static final String ISSUE = "citation_issue";
    public static final String FIRSTPAGE = "citation_firstpage";
    public static final String LASTPAGE = "citation_lastpage";
    public static final String DOI = "citation_doi";
    public static final String PMID = "citation_pmid";
    public static final String ABSTRACT = "citation_abstract_html_url";
    public static final String FULLTEXT = "citation_fulltext_html_url";
    public static final String PDF = "citation_pdf_url";
    public static final String ISSN = "citation_issn";
    public static final String ISBN = "citation_isbn";
    public static final String LANGUAGE = "citation_language";
    public static final String KEYWORDS = "citation_keywords";
    public static final String CONFERENCE = "citation_conference";
    public static final String DISSERTATION_ID = "identifiers.dissertation";
    public static final String DISSERTATION_NAME = "citation_dissertation_name";
    public static final String DISSERTATION_INSTITUTION = "citation_dissertation_institution";
    public static final String PATENT_ID = "identifiers.patent";
    public static final String PATENT_NUMBER = "citation_patent_number";
    public static final String PATENT_COUNTRY = "citation_patent_country";
    public static final String TECH_REPORT_ID = "identifiers.technical_report";
    public static final String TECH_REPORT_NUMBER = "citation_technical_report_number";
    public static final String TECH_REPORT_INSTITUTION = "citation_technical_report_institution";
    private static final int SINGLE = 0;
    private static final int MULTI = 1;
    private static final int ALL_FIELDS_IN_OPTION = 2;

    public static void logConfiguration() {
        log.debug((Object)"Google Metadata Configuration Mapping:");
        for (String name : configuredFields.keySet()) {
            log.debug((Object)("  " + name + " => " + configuredFields.get(name)));
        }
    }

    public GoogleMetadata(Context context, Item item) throws SQLException {
        this.item = item;
        this.itemURL = HandleManager.resolveToURL(context, item.getHandle());
        this.parseItem();
    }

    private boolean addSingleField(String fieldName) {
        String config = configuredFields.get(fieldName);
        if (null == config || config.equals("")) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing " + fieldName));
        }
        if (config.equals("$handle")) {
            if (null != this.itemURL && !this.itemURL.equals("")) {
                this.metadataMappings.put(fieldName, this.itemURL);
                return true;
            }
            return false;
        }
        if (config.equals("$simple-pdf")) {
            String pdf_url = this.getPDFSimpleUrl(this.item);
            if (pdf_url.length() > 0) {
                this.metadataMappings.put(fieldName, pdf_url);
                return true;
            }
            return false;
        }
        DCValue v = this.resolveMetadataField(config);
        if (null != v && null != v.value && !v.value.trim().equals("")) {
            this.metadataMappings.put(fieldName, v.value);
            return true;
        }
        return false;
    }

    private DCValue resolveMetadataField(String configFilter) {
        ArrayList<DCValue> fields = this.resolveMetadata(configFilter, 0);
        if (null != fields && fields.size() > 0) {
            return fields.get(0);
        }
        return null;
    }

    private ArrayList<DCValue> resolveMetadataFields(String configFilter) {
        ArrayList<DCValue> fields = this.resolveMetadata(configFilter, 1);
        if (null != fields && fields.size() > 0) {
            return fields;
        }
        return null;
    }

    private ArrayList<DCValue> resolveMetadata(String configFilter, int returnType) {
        if (null == configFilter || configFilter.trim().equals("") || !configFilter.contains(".")) {
            log.error((Object)("The configuration string [" + configFilter + "] is invalid."));
            return null;
        }
        configFilter = configFilter.trim();
        ArrayList<Object> parsedOptions = new ArrayList();
        parsedOptions = this.parseOptions(configFilter);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Resolved Fields For This Item Per Configuration Filter:");
            for (int i = 0; i < parsedOptions.size(); ++i) {
                ArrayList arrayList = (ArrayList)parsedOptions.get(i);
                log.debug((Object)("Option " + (i + 1) + ":"));
                for (String f : arrayList) {
                    log.debug((Object)("{" + f + "}"));
                }
            }
        }
        for (ArrayList arrayList : parsedOptions) {
            int optionMatches = 0;
            ArrayList<DCValue> resolvedFields = new ArrayList<DCValue>();
            for (String field : arrayList) {
                String[] components = this.parseComponents(field);
                DCValue[] values = this.item.getMetadata(components[0], components[1], components[2], "*");
                if (values.length <= 0) continue;
                for (DCValue v : values) {
                    resolvedFields.add(v);
                    if (returnType != 0 || resolvedFields.isEmpty()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Resolved Field Value For This Item:");
                        for (DCValue r : resolvedFields) {
                            log.debug((Object)("{" + r.value + "}"));
                        }
                    }
                    return resolvedFields;
                }
            }
            if (resolvedFields.isEmpty()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resolved Field Values For This Item:");
                for (DCValue v : resolvedFields) {
                    log.debug((Object)("{" + v.value + "}"));
                }
            }
            if (!(2 == returnType ? resolvedFields.size() == optionMatches : 1 == returnType)) continue;
            return resolvedFields;
        }
        return null;
    }

    private ArrayList<ArrayList<String>> parseOptions(String configFilter) {
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<ArrayList<String>> parsedOptions = new ArrayList<ArrayList<String>>();
        if (null == configFilter || configFilter.equals("")) {
            return null;
        }
        if (configFilter.contains("|")) {
            String[] configOptions;
            for (String option : configOptions = configFilter.split("\\|")) {
                options.add(option.trim());
            }
        } else {
            options = new ArrayList();
            options.add(configFilter);
        }
        for (String option : options) {
            ArrayList<String> fields;
            ArrayList<String> parsedFields = new ArrayList<String>();
            if (option.contains(",")) {
                fields = this.parseFields(option);
            } else {
                fields = new ArrayList();
                fields.add(option);
            }
            for (String field : fields) {
                if (field.contains("*")) {
                    ArrayList<String> wc = this.parseWildcard(field);
                    for (String wcField : wc) {
                        if (parsedFields.contains(wcField)) continue;
                        parsedFields.add(wcField);
                    }
                    continue;
                }
                if (parsedFields.contains(field)) continue;
                parsedFields.add(field);
            }
            parsedOptions.add(parsedFields);
        }
        if (null != parsedOptions) {
            return parsedOptions;
        }
        return null;
    }

    private ArrayList<String> parseFields(String configString) {
        ArrayList<String> fields = new ArrayList<String>();
        for (String field : configString.split("\\,")) {
            fields.add(field.trim());
        }
        return fields;
    }

    private String[] parseComponents(String field) {
        int index = 0;
        String[] components = new String[3];
        for (String c : field.split("\\.")) {
            components[index] = c.trim();
            ++index;
        }
        return components;
    }

    private ArrayList<String> parseWildcard(String field) {
        if (!field.contains("*")) {
            return null;
        }
        String[] components = this.parseComponents(field);
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].trim().equals("*")) continue;
            components[i] = "*";
        }
        DCValue[] allMD = this.item.getMetadata(components[0], components[1], components[2], "*");
        ArrayList<String> expandedDC = new ArrayList<String>();
        for (DCValue v : allMD) {
            if (expandedDC.contains(this.buildFieldName(v))) continue;
            expandedDC.add(this.buildFieldName(v));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Field Names From Expanded Wildcard \"" + field + "\""));
            for (String v : expandedDC) {
                log.debug((Object)("    " + v));
            }
        }
        return expandedDC;
    }

    private String buildFieldName(DCValue v) {
        StringBuilder name = new StringBuilder();
        name.append(v.schema + "." + v.element);
        if (null != v.qualifier) {
            name.append("." + v.qualifier);
        }
        return name.toString();
    }

    private void parseItem() {
        this.addSingleField(TITLE);
        this.addAggregateValues(AUTHORS, ";");
        this.addSingleField(DATE);
        this.addSingleField(ISSN);
        this.addSingleField(ISBN);
        this.addSingleField(JOURNAL_TITLE);
        this.addSingleField(VOLUME);
        this.addSingleField(ISSUE);
        this.addSingleField(FIRSTPAGE);
        this.addSingleField(LASTPAGE);
        this.addSingleField(DOI);
        this.addSingleField(PMID);
        this.addSingleField(ABSTRACT);
        this.addSingleField(FULLTEXT);
        this.addSingleField(PDF);
        this.addSingleField(LANGUAGE);
        this.addAggregateValues(KEYWORDS, ";");
        this.addSingleField(CONFERENCE);
        if (this.itemIsDissertation()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ITEM TYPE:  DISSERTATION");
            }
            this.addSingleField(DISSERTATION_NAME);
            this.addSingleField(DISSERTATION_INSTITUTION);
        }
        if (this.itemIsPatent()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ITEM TYPE:  PATENT");
            }
            this.addSingleField(PATENT_NUMBER);
            String countryConfig = configuredFields.get(PATENT_COUNTRY);
            if (null != countryConfig && !countryConfig.trim().equals("")) {
                this.metadataMappings.put(PATENT_COUNTRY, countryConfig.trim());
            }
            this.addSingleField(PUBLISHER);
        }
        if (this.itemIsTechReport()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ITEM TYPE:  TECH REPORT");
            }
            this.addSingleField(TECH_REPORT_NUMBER);
            this.addSingleField(TECH_REPORT_INSTITUTION);
        }
        if (!this.itemIsDissertation() && !this.itemIsTechReport()) {
            this.addSingleField(PUBLISHER);
        }
    }

    public Set<Map.Entry<String, String>> getMappings() {
        return new HashSet<Map.Entry<String, String>>(this.metadataMappings.entrySet());
    }

    public List<Element> disseminateList() {
        ArrayList<Element> metas = new ArrayList<Element>();
        for (Map.Entry<String, String> m : this.getMappings()) {
            Element e = new Element("meta");
            e.setNamespace(null);
            e.setAttribute("name", m.getKey());
            e.setAttribute("content", m.getValue());
            metas.add(e);
        }
        return metas;
    }

    public String getTitle() {
        return this.metadataMappings.get(TITLE);
    }

    public String getJournalTitle() {
        return this.metadataMappings.get(JOURNAL_TITLE);
    }

    public String getPublisher() {
        return this.metadataMappings.get(PUBLISHER);
    }

    public String getAuthors() {
        return this.metadataMappings.get(AUTHORS);
    }

    public String getDate() {
        return this.metadataMappings.get(DATE);
    }

    public String getVolume() {
        return this.metadataMappings.get(VOLUME);
    }

    public String getIssue() {
        return this.metadataMappings.get(ISSUE);
    }

    public String getFirstpage() {
        return this.metadataMappings.get(FIRSTPAGE);
    }

    public String getLastpage() {
        return this.metadataMappings.get(LASTPAGE);
    }

    public String getDOI() {
        return this.metadataMappings.get(DOI);
    }

    public String getPmid() {
        return this.metadataMappings.get(PMID);
    }

    public String getAbstractHTMLURL() {
        return this.metadataMappings.get(ABSTRACT);
    }

    public String getFulltextHTMLURL() {
        return this.metadataMappings.get(FULLTEXT);
    }

    public String getPDFURL() {
        return this.metadataMappings.get(PDF);
    }

    public String getISSN() {
        return this.metadataMappings.get(ISSN);
    }

    public String getISBN() {
        return this.metadataMappings.get(ISBN);
    }

    public String getLanguage() {
        return this.metadataMappings.get(LANGUAGE);
    }

    public String getKeywords() {
        return this.metadataMappings.get(KEYWORDS);
    }

    public String getConference() {
        return this.metadataMappings.get(CONFERENCE);
    }

    public String getDissertationName() {
        return this.metadataMappings.get(DISSERTATION_NAME);
    }

    public String getDissertationInstitution() {
        return this.metadataMappings.get(DISSERTATION_INSTITUTION);
    }

    public String getPatentNumber() {
        return this.metadataMappings.get(PATENT_NUMBER);
    }

    public String getPatentCountry() {
        return this.metadataMappings.get(PATENT_COUNTRY);
    }

    public String getTechnicalReportNumber() {
        return this.metadataMappings.get(TECH_REPORT_NUMBER);
    }

    public String getTechnicalReportInstitution() {
        return this.metadataMappings.get(TECH_REPORT_INSTITUTION);
    }

    private String getPDFSimpleUrl(Item item) {
        try {
            Bitstream[] bitstreams;
            Bundle[] contentBundles = item.getBundles("ORIGINAL");
            if (contentBundles.length > 0 && (bitstreams = contentBundles[0].getBitstreams()).length == 1 && bitstreams[0].getFormat().getMIMEType().equals("application/pdf")) {
                StringBuilder path = new StringBuilder();
                path.append(ConfigurationManager.getProperty("dspace.url"));
                if (item.getHandle() != null) {
                    path.append("/bitstream/");
                    path.append(item.getHandle());
                    path.append("/");
                    path.append(bitstreams[0].getSequenceID());
                } else {
                    path.append("/retrieve/");
                    path.append(bitstreams[0].getID());
                }
                path.append("/");
                path.append(Util.encodeBitstreamName(bitstreams[0].getName(), "UTF-8"));
                return path.toString();
            }
        }
        catch (UnsupportedEncodingException ex) {
            log.debug((Object)ex.getMessage());
        }
        catch (SQLException ex) {
            log.debug((Object)ex.getMessage());
        }
        return "";
    }

    private void addAggregateValues(String FIELD, String delim) {
        String authorConfig = configuredFields.get(FIELD);
        ArrayList<DCValue> fields = this.resolveMetadataFields(authorConfig);
        if (null != fields && !fields.isEmpty()) {
            StringBuilder fieldMetadata = new StringBuilder();
            int count = 0;
            for (DCValue field : fields) {
                fieldMetadata.append(field.value);
                if (count >= fields.size() - 1) continue;
                fieldMetadata.append(delim + " ");
                ++count;
            }
            this.metadataMappings.put(FIELD, fieldMetadata.toString());
        }
    }

    private boolean itemIsDissertation() {
        String dConfig = configuredFields.get(DISSERTATION_ID);
        if (null == dConfig || dConfig.trim().equals("")) {
            return false;
        }
        return this.identifyItemType(dConfig);
    }

    private boolean itemIsPatent() {
        String dConfig = configuredFields.get(PATENT_ID);
        if (null == dConfig || dConfig.trim().equals("")) {
            return false;
        }
        return this.identifyItemType(dConfig);
    }

    private boolean itemIsTechReport() {
        String dConfig = configuredFields.get(TECH_REPORT_ID);
        if (null == dConfig || dConfig.trim().equals("")) {
            return false;
        }
        return this.identifyItemType(dConfig);
    }

    private boolean identifyItemType(String dConfig) {
        ArrayList<ArrayList<String>> options = this.parseOptions(dConfig);
        HashMap mdPairs = new HashMap();
        for (ArrayList<String> option : options) {
            String pair = option.get(0);
            String[] parsedPair = pair.split("\\:");
            if (2 == parsedPair.length) {
                if (mdPairs.containsKey(parsedPair[0].trim())) {
                    ((ArrayList)mdPairs.get(parsedPair[0].trim())).add(parsedPair[1]);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Registering Type Identifier:  " + parsedPair[0] + " => " + parsedPair[1]));
                    continue;
                }
                ArrayList<String> newField = new ArrayList<String>();
                newField.add(parsedPair[1].trim());
                mdPairs.put(parsedPair[0].trim(), newField);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Registering Type Identifier:  " + parsedPair[0] + " => " + parsedPair[1]));
                continue;
            }
            log.error((Object)"Malformed field identifier name/value pair");
        }
        StringBuilder sb = new StringBuilder();
        for (String value : mdPairs.keySet()) {
            sb.append(value + " | ");
        }
        ArrayList<DCValue> presentMD = this.resolveMetadataFields(sb.toString());
        if (null != presentMD && presentMD.size() != 0) {
            for (DCValue v : presentMD) {
                String fieldName = this.buildFieldName(v);
                if (!mdPairs.containsKey(fieldName)) continue;
                for (String configValue : (ArrayList)mdPairs.get(fieldName)) {
                    if (!configValue.equals(v.value)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        File loadedFile = null;
        URL url = null;
        InputStream is = null;
        String googleConfigFile = ConfigurationManager.getProperty("google-metadata.config");
        log.info((Object)("Using [" + googleConfigFile + "] for Google Metadata configuration"));
        loadedFile = new File(googleConfigFile);
        try {
            url = loadedFile.toURL();
        }
        catch (MalformedURLException mux) {
            log.error((Object)("Can't find Google Metadata configuration file: " + googleConfigFile), (Throwable)mux);
        }
        Properties properties = new Properties();
        try {
            is = url.openStream();
            properties.load(is);
        }
        catch (IOException iox) {
            log.error((Object)("Could not read Google Metadata configuration file: " + googleConfigFile), (Throwable)iox);
        }
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = ((String)propertyNames.nextElement()).trim();
            if (!key.startsWith(GOOGLE_PREFIX)) continue;
            String name = key.substring(GOOGLE_PREFIX.length());
            String field = properties.getProperty(key);
            if (null == name || name.equals("") || null == field || field.equals("")) continue;
            configuredFields.put(name.trim(), field.trim());
        }
        if (log.isDebugEnabled()) {
            GoogleMetadata.logConfiguration();
        }
    }
}

