/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.utils.DSpace;

public class InitializeDatabase {
    private static Logger log = Logger.getLogger(InitializeDatabase.class);

    public static void main(String[] argv) {
        if (argv.length != 1) {
            log.warn((Object)"Schema file not specified");
            System.exit(1);
        }
        log.info((Object)"Initializing Database");
        try {
            if ("clean-database.sql".equals(argv[0])) {
                DatabaseManager.loadSql(InitializeDatabase.getScript(argv[0]));
            } else {
                DatabaseManager.loadSql(InitializeDatabase.getScript(argv[0]));
            }
            System.exit(0);
        }
        catch (Exception e) {
            log.fatal((Object)"Caught exception:", (Throwable)e);
            System.exit(1);
        }
    }

    private static FileReader getScript(String name) throws FileNotFoundException, IOException {
        String dbName = new DSpace().getConfigurationService().getProperty("db.name");
        File myFile = null;
        if (dbName != null && (myFile = new File("etc/" + dbName + "/" + name)).exists()) {
            return new FileReader(myFile.getCanonicalPath());
        }
        myFile = new File("etc/" + name);
        if (myFile.exists()) {
            return new FileReader(myFile.getCanonicalPath());
        }
        return new FileReader(name);
    }
}

