/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.checker;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.dspace.checker.BitstreamDispatcher;
import org.dspace.checker.BitstreamInfoDAO;
import org.dspace.checker.CheckerCommand;
import org.dspace.checker.HandleDispatcher;
import org.dspace.checker.LimitedCountDispatcher;
import org.dspace.checker.LimitedDurationDispatcher;
import org.dspace.checker.ListDispatcher;
import org.dspace.checker.ResultsLogger;
import org.dspace.checker.ResultsPruner;
import org.dspace.checker.SimpleDispatcher;
import org.dspace.core.Utils;

public final class ChecksumChecker {
    private static final Logger LOG = Logger.getLogger(ChecksumChecker.class);

    private ChecksumChecker() {
    }

    public static void main(String[] args) {
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        Options options = new Options();
        options.addOption("l", "looping", false, "Loop once through bitstreams");
        options.addOption("L", "continuous", false, "Loop continuously through bitstreams");
        options.addOption("h", "help", false, "Help");
        options.addOption("d", "duration", true, "Checking duration");
        options.addOption("c", "count", true, "Check count");
        options.addOption("a", "handle", true, "Specify a handle to check");
        options.addOption("v", "verbose", false, "Report all processing");
        OptionBuilder.withArgName((String)"bitstream-ids");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Space separated list of bitstream ids");
        Option useBitstreamIds = OptionBuilder.create((char)'b');
        options.addOption(useBitstreamIds);
        options.addOption("p", "prune", false, "Prune configuration file");
        OptionBuilder.withArgName((String)"prune");
        OptionBuilder.hasOptionalArgs((int)1);
        OptionBuilder.withDescription((String)"Prune old results (optionally using specified properties file for configuration)");
        options.addOption(OptionBuilder.create((char)'p'));
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException e) {
            LOG.fatal((Object)e);
            System.exit(1);
        }
        if (line.hasOption('h')) {
            ChecksumChecker.printHelp(options);
        }
        if (line.hasOption('p')) {
            ResultsPruner rp = null;
            try {
                rp = line.getOptionValue('p') != null ? ResultsPruner.getPruner(line.getOptionValue('p')) : ResultsPruner.getDefaultPruner();
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)"File not found", (Throwable)e);
                System.exit(1);
            }
            int count = rp.prune();
            System.out.println("Pruned " + count + " old results from the database.");
        }
        Date processStart = Calendar.getInstance().getTime();
        BitstreamDispatcher dispatcher = null;
        if (line.hasOption('l')) {
            dispatcher = new SimpleDispatcher(new BitstreamInfoDAO(), processStart, false);
        } else if (line.hasOption('L')) {
            dispatcher = new SimpleDispatcher(new BitstreamInfoDAO(), processStart, true);
        } else if (line.hasOption('b')) {
            String[] ids = line.getOptionValues('b');
            ArrayList<Integer> idList = new ArrayList<Integer>(ids.length);
            for (int i = 0; i < ids.length; ++i) {
                try {
                    idList.add(Integer.valueOf(ids[i]));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    System.err.println("The following argument: " + ids[i] + " is not an integer");
                    System.exit(0);
                }
            }
            dispatcher = new ListDispatcher(idList);
        } else if (line.hasOption('a')) {
            dispatcher = new HandleDispatcher(new BitstreamInfoDAO(), line.getOptionValue('a'));
        } else if (line.hasOption('d')) {
            try {
                dispatcher = new LimitedDurationDispatcher(new SimpleDispatcher(new BitstreamInfoDAO(), processStart, true), new Date(System.currentTimeMillis() + Utils.parseDuration(line.getOptionValue('d'))));
            }
            catch (Exception e) {
                LOG.fatal((Object)("Couldn't parse " + line.getOptionValue('d') + " as a duration: "), (Throwable)e);
                System.exit(0);
            }
        } else if (line.hasOption('c')) {
            int count = Integer.valueOf(line.getOptionValue('c'));
            dispatcher = new LimitedCountDispatcher(new SimpleDispatcher(new BitstreamInfoDAO(), processStart, false), count);
        } else {
            dispatcher = new LimitedCountDispatcher(new SimpleDispatcher(new BitstreamInfoDAO(), processStart, false), 1);
        }
        ResultsLogger logger = new ResultsLogger(processStart);
        CheckerCommand checker = new CheckerCommand();
        if (line.hasOption('v')) {
            checker.setReportVerbose(true);
        }
        checker.setProcessStartDate(processStart);
        checker.setDispatcher(dispatcher);
        checker.setCollector(logger);
        checker.process();
        System.exit(0);
    }

    private static void printHelp(Options options) {
        HelpFormatter myhelp = new HelpFormatter();
        myhelp.printHelp("Checksum Checker\n", options);
        System.out.println("\nSpecify a duration for checker process, using s(seconds),m(minutes), or h(hours): ChecksumChecker -d 30s OR ChecksumChecker -d 30m OR ChecksumChecker -d 2h");
        System.out.println("\nSpecify bitstream IDs: ChecksumChecker -b 13 15 17 20");
        System.out.println("\nLoop once through all bitstreams: ChecksumChecker -l");
        System.out.println("\nLoop continuously through all bitstreams: ChecksumChecker -L");
        System.out.println("\nCheck a defined number of bitstreams: ChecksumChecker -c 10");
        System.out.println("\nReport all processing (verbose)(default reports only errors): ChecksumChecker -v");
        System.out.println("\nDefault (no arguments) is equivalent to '-c 1'");
        System.exit(0);
    }
}

