/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.FileAppender;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class DailyFileAppender
extends FileAppender {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private String mstrFileName;
    private Date mstrDate = new Date(System.currentTimeMillis());
    private String mstrDatePattern = "yyyy-MM-dd";
    private boolean mMonthOnly = false;
    private SimpleDateFormat mobjSDF;
    private boolean mWithHostName = false;
    private int mMaxLogs = 0;
    private static boolean deletingFiles = false;

    public void activateOptions() {
        this.setFileName();
        this.cleanupOldFiles();
        super.activateOptions();
    }

    public String getDatePattern() {
        return this.mstrDatePattern;
    }

    public String getFile() {
        return this.mstrFileName;
    }

    public boolean getWithHost() {
        return this.mWithHostName;
    }

    public int getMaxLogs() {
        return this.mMaxLogs;
    }

    public void setDatePattern(String pstrPattern) {
        this.mstrDatePattern = this.checkPattern(pstrPattern);
        this.mMonthOnly = !this.mstrDatePattern.contains("dd") && !this.mstrDatePattern.contains("DD");
    }

    public void setFile(String file) {
        String val;
        this.mstrFileName = val = file.trim();
    }

    public void setWithHost(boolean wh) {
        this.mWithHostName = wh;
    }

    public void setMaxLogs(int ml) {
        this.mMaxLogs = ml;
    }

    protected void subAppend(LoggingEvent pobjEvent) {
        Date dtNow = new Date(System.currentTimeMillis());
        boolean rollover = false;
        if (this.mMonthOnly) {
            Calendar now = Calendar.getInstance();
            Calendar cur = Calendar.getInstance();
            now.setTime(dtNow);
            cur.setTime(this.mstrDate);
            rollover = now.get(1) != cur.get(1) || now.get(2) != cur.get(2);
        } else {
            boolean bl = rollover = !DateUtils.isSameDay((Date)dtNow, (Date)this.mstrDate);
        }
        if (rollover) {
            try {
                this.rollOver(dtNow);
            }
            catch (IOException IOEx) {
                LogLog.error((String)"rollOver() failed!", (Throwable)IOEx);
            }
        }
        super.subAppend(pobjEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkPattern(String pstrPattern) {
        String strRet = null;
        SimpleDateFormat objFmt = new SimpleDateFormat(DATE_PATTERN);
        try {
            this.mobjSDF = new SimpleDateFormat(pstrPattern);
            strRet = pstrPattern;
        }
        catch (NullPointerException NPExIgnore) {
            LogLog.error((String)("Invalid DatePattern " + pstrPattern), (Throwable)NPExIgnore);
            this.mobjSDF = objFmt;
            strRet = DATE_PATTERN;
        }
        catch (IllegalArgumentException IlArgExIgnore) {
            LogLog.error((String)("Invalid DatePattern " + pstrPattern), (Throwable)IlArgExIgnore);
            this.mobjSDF = objFmt;
            strRet = DATE_PATTERN;
        }
        finally {
            objFmt = null;
        }
        return strRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupOldFiles() {
        if (this.mMaxLogs > 0 && !deletingFiles) {
            deletingFiles = true;
            String hostFileExt = null;
            try {
                hostFileExt = "." + InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                LogLog.error((String)"Unable to retrieve host name");
            }
            try {
                File[] logsToKeep = new File[this.mMaxLogs];
                File logMaster = new File(this.mstrFileName);
                File logDir = logMaster.getParentFile();
                if (logDir.isDirectory()) {
                    File[] logArr;
                    for (File curLog : logArr = logDir.listFiles()) {
                        LogLog.debug((String)("Comparing '" + curLog.getAbsolutePath() + "' to '" + this.mstrFileName + "'"));
                        String name = curLog.getAbsolutePath();
                        if (this.mWithHostName && (hostFileExt == null || !name.endsWith(hostFileExt)) || !name.contains(this.mstrFileName)) continue;
                        for (int i = 0; curLog != null && i < logsToKeep.length; ++i) {
                            if (logsToKeep[i] == null) {
                                logsToKeep[i] = curLog;
                                curLog = null;
                                continue;
                            }
                            if (logsToKeep[i].getName().compareTo(curLog.getName()) >= 0) continue;
                            File temp = logsToKeep[i];
                            logsToKeep[i] = curLog;
                            curLog = temp;
                        }
                        if (curLog == null) continue;
                        LogLog.debug((String)("Deleting log " + curLog.getName()));
                        if (!curLog.delete()) continue;
                        LogLog.error((String)"Unable to delete log file");
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                deletingFiles = false;
            }
        }
    }

    private void rollOver(Date dtNow) throws IOException {
        this.mstrDate = dtNow;
        this.setFileName();
        this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
        this.cleanupOldFiles();
    }

    private void setFileName() {
        this.fileName = this.mstrFileName + "." + this.mobjSDF.format(this.mstrDate);
        if (this.mWithHostName) {
            try {
                this.fileName = this.fileName + "." + InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                LogLog.error((String)"Unable to retrieve host name");
            }
        }
    }
}

