/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class DIMDisseminationCrosswalk
implements DisseminationCrosswalk {
    public static final String DIM_XSD = "null";
    public static final Namespace DIM_NS = Namespace.getNamespace((String)"dim", (String)"http://www.dspace.org/xmlns/dspace/dim");
    private static final Namespace[] namespaces = new Namespace[]{DIM_NS};

    @Override
    public Namespace[] getNamespaces() {
        return (Namespace[])ArrayUtils.clone((Object[])namespaces);
    }

    @Override
    public String getSchemaLocation() {
        return DIM_NS.getURI() + " " + DIM_XSD;
    }

    @Override
    public Element disseminateElement(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() != 2) {
            throw new CrosswalkObjectNotSupported("DIMDisseminationCrosswalk can only crosswalk an Item.");
        }
        Item item = (Item)dso;
        DCValue[] dc = item.getMetadata("*", "*", "*", "*");
        Element dim = new Element("dim", DIM_NS);
        for (int i = 0; i < dc.length; ++i) {
            Element field = new Element("field", DIM_NS);
            field.setAttribute("mdschema", dc[i].schema);
            field.setAttribute("element", dc[i].element);
            if (dc[i].qualifier != null) {
                field.setAttribute("qualifier", dc[i].qualifier);
            }
            if (dc[i].language != null) {
                field.setAttribute("lang", dc[i].language);
            }
            if (dc[i].value != null) {
                field.setText(dc[i].value);
            }
            dim.addContent((Content)field);
        }
        return dim;
    }

    @Override
    public List<Element> disseminateList(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        ArrayList<Element> result = new ArrayList<Element>(1);
        result.add(this.disseminateElement(dso));
        return result;
    }

    @Override
    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() == 2;
    }

    @Override
    public boolean preferList() {
        return false;
    }
}

