/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.search;

import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.PorterStemFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.util.Version;
import org.dspace.core.ConfigurationManager;
import org.dspace.search.DSTokenizer;

public class DSAnalyzer
extends StopwordAnalyzerBase {
    protected final Version matchVersion;
    protected static final String[] STOP_WORDS = new String[]{"a", "am", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "the", "to", "was"};
    protected final Set stopSet;

    public DSAnalyzer(Version matchVersion) {
        super(matchVersion, StopFilter.makeStopSet((Version)matchVersion, (String[])STOP_WORDS));
        this.stopSet = StopFilter.makeStopSet((Version)matchVersion, (String[])STOP_WORDS);
        this.matchVersion = matchVersion;
    }

    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        DSTokenizer source = new DSTokenizer(this.matchVersion, reader);
        StandardFilter result = new StandardFilter(this.matchVersion, (TokenStream)source);
        result = new LowerCaseFilter(this.matchVersion, (TokenStream)result);
        result = new StopFilter(this.matchVersion, (TokenStream)result, this.stopSet);
        result = new PorterStemFilter((TokenStream)result);
        return new ReusableAnalyzerBase.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }

    public int getPositionIncrementGap(String fieldName) {
        if ("default".equalsIgnoreCase(fieldName) || !ConfigurationManager.getBooleanProperty("search.boundedfields", false)) {
            return super.getPositionIncrementGap(fieldName);
        }
        return 10;
    }
}

