/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.IdentifierProvider;
import org.dspace.identifier.IdentifierService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class IdentifierServiceImpl
implements IdentifierService {
    private List<IdentifierProvider> providers;
    private static Logger log = Logger.getLogger(IdentifierServiceImpl.class);

    @Autowired
    @Required
    public void setProviders(List<IdentifierProvider> providers) {
        this.providers = providers;
        for (IdentifierProvider p : providers) {
            p.setParentService(this);
        }
    }

    @Override
    public void reserve(Context context, DSpaceObject dso) throws AuthorizeException, SQLException, IdentifierException {
        for (IdentifierProvider service : this.providers) {
            service.mint(context, dso);
        }
        dso.update();
    }

    @Override
    public void reserve(Context context, DSpaceObject dso, String identifier) throws AuthorizeException, SQLException, IdentifierException {
        for (IdentifierProvider service : this.providers) {
            if (!service.supports(identifier)) continue;
            service.reserve(context, dso, identifier);
        }
        dso.update();
    }

    @Override
    public void register(Context context, DSpaceObject dso) throws AuthorizeException, SQLException, IdentifierException {
        for (IdentifierProvider service : this.providers) {
            service.register(context, dso);
        }
        dso.update();
    }

    @Override
    public void register(Context context, DSpaceObject object, String identifier) throws AuthorizeException, SQLException, IdentifierException {
        for (IdentifierProvider service : this.providers) {
            service.register(context, object, identifier);
        }
        object.update();
    }

    @Override
    public String lookup(Context context, DSpaceObject dso, Class<? extends Identifier> identifier) {
        for (IdentifierProvider service : this.providers) {
            if (!service.supports(identifier)) continue;
            try {
                String result = service.lookup(context, dso);
                if (result == null) continue;
                return result;
            }
            catch (IdentifierException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public DSpaceObject resolve(Context context, String identifier) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        for (IdentifierProvider service : this.providers) {
            if (!service.supports(identifier)) continue;
            try {
                DSpaceObject result = service.resolve(context, identifier, new String[0]);
                if (result == null) continue;
                return result;
            }
            catch (IdentifierException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void delete(Context context, DSpaceObject dso) throws AuthorizeException, SQLException, IdentifierException {
        for (IdentifierProvider service : this.providers) {
            try {
                service.delete(context, dso);
            }
            catch (IdentifierException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void delete(Context context, DSpaceObject dso, String identifier) throws AuthorizeException, SQLException, IdentifierException {
        for (IdentifierProvider service : this.providers) {
            try {
                if (!service.supports(identifier)) continue;
                service.delete(context, dso, identifier);
            }
            catch (IdentifierException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

