/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.storedcomponents;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.XmlWorkflowManager;
import org.dspace.xmlworkflow.storedcomponents.WorkflowItemRole;

public class XmlWorkflowItem
implements InProgressSubmission {
    private static Logger log = Logger.getLogger(XmlWorkflowItem.class);
    private Collection collection;
    private Item item;
    private TableRow wfRow;
    private Context ourContext;

    public static XmlWorkflowItem create(Context context) throws AuthorizeException, IOException, SQLException {
        TableRow row = DatabaseManager.create(context, "cwf_workflowitem");
        return new XmlWorkflowItem(context, row);
    }

    XmlWorkflowItem(Context context, TableRow row) throws SQLException {
        this.ourContext = context;
        this.wfRow = row;
        this.item = Item.find(context, this.wfRow.getIntColumn("item_id"));
        this.collection = Collection.find(context, this.wfRow.getIntColumn("collection_id"));
        context.cache(this, row.getIntColumn("workflowitem_id"));
    }

    public static XmlWorkflowItem find(Context context, int id) throws SQLException, AuthorizeException, IOException {
        XmlWorkflowItem fromCache = (XmlWorkflowItem)context.fromCache(XmlWorkflowItem.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "cwf_workflowitem", id);
        if (row == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_workflow_item", "not_found,workflowitem_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_workflow_item", "workflowitem_id=" + id));
        }
        return new XmlWorkflowItem(context, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlWorkflowItem[] findAll(Context c) throws SQLException, AuthorizeException, IOException, WorkflowConfigurationException {
        ArrayList<XmlWorkflowItem> wfItems = new ArrayList<XmlWorkflowItem>();
        TableRowIterator tri = DatabaseManager.queryTable(c, "cwf_workflowitem", "SELECT * FROM cwf_workflowitem", new Object[0]);
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                XmlWorkflowItem wi = new XmlWorkflowItem(c, row);
                wfItems.add(wi);
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        XmlWorkflowItem[] wfArray = new XmlWorkflowItem[wfItems.size()];
        wfArray = wfItems.toArray(wfArray);
        return wfArray;
    }

    public static XmlWorkflowItem[] findAll(Context c, int page, int pagesize) throws SQLException, AuthorizeException, IOException, WorkflowConfigurationException {
        return XmlWorkflowItem.findAllInCollection(c, page, pagesize, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlWorkflowItem[] findAllInCollection(Context c, int page, int pagesize, int collectionId) throws SQLException, AuthorizeException, IOException, WorkflowConfigurationException {
        ArrayList<XmlWorkflowItem> wfItems = new ArrayList<XmlWorkflowItem>();
        StringBuffer query = new StringBuffer();
        query.append("SELECT * FROM cwf_workflowitem ");
        if (collectionId != -1) {
            query.append("WHERE collection_id=").append(collectionId);
        }
        int offset = (page - 1) * pagesize;
        if ("oracle".equals(ConfigurationManager.getProperty("db.name"))) {
            if (pagesize > 0 || offset > 0) {
                query.insert(0, "SELECT /*+ FIRST_ROWS(n) */ rec.*, ROWNUM rnum  FROM (");
                query.append(") ");
            }
            if (pagesize > 0) {
                query.append("rec WHERE rownum<=? ");
                if (offset > 0) {
                    pagesize += offset;
                }
            }
            if (offset > 0) {
                query.insert(0, "SELECT * FROM (");
                query.append(") WHERE rnum>?");
            }
        } else {
            if (pagesize > 0) {
                query.append(" LIMIT ? ");
            }
            if (offset > 0) {
                query.append(" OFFSET ? ");
            }
        }
        String queryString = query.toString();
        Object[] paramArr = new Object[]{};
        if (pagesize > 0 && offset > 0) {
            paramArr = new Object[]{pagesize, offset};
        } else if (pagesize > 0) {
            paramArr = new Object[]{pagesize};
        } else if (offset > 0) {
            paramArr = new Object[]{offset};
        }
        TableRowIterator tri = DatabaseManager.query(c, queryString, paramArr);
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                XmlWorkflowItem wi = new XmlWorkflowItem(c, row);
                wfItems.add(wi);
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        XmlWorkflowItem[] wfArray = new XmlWorkflowItem[wfItems.size()];
        wfArray = wfItems.toArray(wfArray);
        return wfArray;
    }

    public static int countAll(Context c) throws SQLException, AuthorizeException, IOException, WorkflowConfigurationException {
        return XmlWorkflowItem.countAllInCollection(c, -1);
    }

    public static int countAllInCollection(Context c, int collId) throws SQLException, AuthorizeException, IOException, WorkflowConfigurationException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT count(*) AS count FROM cwf_workflowitem ");
        if (collId != -1) {
            query.append(" WHERE collection_id= ").append(collId);
        }
        TableRow tr = DatabaseManager.querySingle(c, query.toString(), new Object[0]);
        return new Long(tr.getLongColumn("count")).intValue();
    }

    public static XmlWorkflowItem[] findByEPerson(Context context, EPerson ep) throws SQLException, AuthorizeException, IOException, WorkflowConfigurationException {
        ArrayList<XmlWorkflowItem> wfItems = new ArrayList<XmlWorkflowItem>();
        TableRowIterator tri = DatabaseManager.queryTable(context, "cwf_workflowitem", "SELECT cwf_workflowitem.* FROM cwf_workflowitem, item WHERE cwf_workflowitem.item_id=item.item_id AND item.submitter_id= ? ORDER BY cwf_workflowitem.workflowitem_id", ep.getID());
        while (tri.hasNext()) {
            TableRow row = tri.next();
            XmlWorkflowItem wi = (XmlWorkflowItem)context.fromCache(XmlWorkflowItem.class, row.getIntColumn("workflowitem_id"));
            if (wi == null) {
                wi = new XmlWorkflowItem(context, row);
            }
            wfItems.add(wi);
        }
        tri.close();
        XmlWorkflowItem[] wfArray = new XmlWorkflowItem[wfItems.size()];
        wfArray = wfItems.toArray(wfArray);
        return wfArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlWorkflowItem[] findByCollection(Context context, Collection c) throws SQLException, AuthorizeException, IOException {
        ArrayList<XmlWorkflowItem> wsItems = new ArrayList<XmlWorkflowItem>();
        TableRowIterator tri = DatabaseManager.queryTable(context, "cwf_workflowitem", "SELECT cwf_workflowitem.* FROM cwf_workflowitem WHERE cwf_workflowitem.collection_id= ? ", c.getID());
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                XmlWorkflowItem wi = (XmlWorkflowItem)context.fromCache(XmlWorkflowItem.class, row.getIntColumn("workflowitem_id"));
                if (wi == null) {
                    wi = new XmlWorkflowItem(context, row);
                }
                wsItems.add(wi);
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        XmlWorkflowItem[] wsArray = new XmlWorkflowItem[wsItems.size()];
        wsArray = wsItems.toArray(wsArray);
        return wsArray;
    }

    public static XmlWorkflowItem findByItem(Context context, Item item) throws SQLException {
        TableRow row = DatabaseManager.findByUnique(context, "cwf_workflowitem", "item_id", item.getID());
        XmlWorkflowItem wi = null;
        if (row != null && (wi = (XmlWorkflowItem)context.fromCache(XmlWorkflowItem.class, row.getIntColumn("workflowitem_id"))) == null) {
            wi = new XmlWorkflowItem(context, row);
        }
        return wi;
    }

    @Override
    public void update() throws SQLException, AuthorizeException {
        log.info((Object)LogManager.getHeader(this.ourContext, "update_workflow_item", "workflowitem_id=" + this.getID()));
        this.item.update();
        DatabaseManager.update(this.ourContext, this.wfRow);
    }

    @Override
    public int getID() {
        return this.wfRow.getIntColumn("workflowitem_id");
    }

    @Override
    public Collection getCollection() {
        return this.collection;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
        this.wfRow.setColumn("collection_id", collection.getID());
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
        this.wfRow.setColumn("item_id", item.getID());
    }

    @Override
    public EPerson getSubmitter() throws SQLException {
        return this.item.getSubmitter();
    }

    @Override
    public boolean hasMultipleFiles() {
        return this.wfRow.getBooleanColumn("multiple_files");
    }

    @Override
    public void setMultipleFiles(boolean b) {
        this.wfRow.setColumn("multiple_files", b);
    }

    @Override
    public boolean hasMultipleTitles() {
        return this.wfRow.getBooleanColumn("multiple_titles");
    }

    @Override
    public void setMultipleTitles(boolean b) {
        this.wfRow.setColumn("multiple_titles", b);
    }

    @Override
    public boolean isPublishedBefore() {
        return this.wfRow.getBooleanColumn("published_before");
    }

    @Override
    public void setPublishedBefore(boolean b) {
        this.wfRow.setColumn("published_before", b);
    }

    @Override
    public void deleteWrapper() throws SQLException, IOException, AuthorizeException {
        WorkflowItemRole[] roles;
        this.ourContext.removeCached(this, this.getID());
        for (WorkflowItemRole role : roles = WorkflowItemRole.findAllForItem(this.ourContext, this.getID())) {
            role.delete();
        }
        XmlWorkflowManager.deleteAllTasks(this.ourContext, this);
        DatabaseManager.delete(this.ourContext, this.wfRow);
    }
}

