/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemimport;

import gr.ekt.transformationengine.core.DataLoader;
import gr.ekt.transformationengine.core.TransformationEngine;
import gr.ekt.transformationengine.exceptions.UnimplementedAbstractMethod;
import gr.ekt.transformationengine.exceptions.UnknownClassifierException;
import gr.ekt.transformationengine.exceptions.UnknownInputFileType;
import gr.ekt.transformationengine.exceptions.UnsupportedComparatorMode;
import gr.ekt.transformationengine.exceptions.UnsupportedCriterion;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.dspace.app.itemimport.DataLoaderService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.FormatIdentifier;
import org.dspace.content.InstallItem;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.handle.HandleManager;
import org.dspace.search.DSIndexer;
import org.dspace.utils.DSpace;
import org.dspace.workflow.WorkflowManager;
import org.dspace.xmlworkflow.XmlWorkflowManager;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ItemImport {
    private static final Logger log = Logger.getLogger(ItemImport.class);
    private static boolean useWorkflow = false;
    private static boolean useWorkflowSendEmail = false;
    private static boolean isTest = false;
    private static boolean isResume = false;
    private static boolean isQuiet = false;
    private static boolean template = false;
    private static PrintWriter mapOut = null;
    private static FilenameFilter metadataFileFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String n) {
            return n.startsWith("metadata_");
        }
    };
    private static FilenameFilter directoryFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String n) {
            File item = new File(dir.getAbsolutePath() + File.separatorChar + n);
            return item.isDirectory();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        DSIndexer.setBatchProcessingMode(true);
        Date startTime = new Date();
        int status = 0;
        try {
            PosixParser parser = new PosixParser();
            Options options = new Options();
            options.addOption("a", "add", false, "add items to DSpace");
            options.addOption("b", "add-bte", false, "add items to DSpace via Biblio-Transformation-Engine (BTE)");
            options.addOption("r", "replace", false, "replace items in mapfile");
            options.addOption("d", "delete", false, "delete items listed in mapfile");
            options.addOption("i", "inputtype", true, "input type in case of BTE import");
            options.addOption("s", "source", true, "source of items (directory)");
            options.addOption("z", "zip", true, "name of zip file");
            options.addOption("c", "collection", true, "destination collection(s) Handle or database ID");
            options.addOption("m", "mapfile", true, "mapfile items in mapfile");
            options.addOption("e", "eperson", true, "email of eperson doing importing");
            options.addOption("w", "workflow", false, "send submission through collection's workflow");
            options.addOption("n", "notify", false, "if sending submissions through the workflow, send notification emails");
            options.addOption("t", "test", false, "test run - do not actually import items");
            options.addOption("p", "template", false, "apply template");
            options.addOption("R", "resume", false, "resume a failed import (add only)");
            options.addOption("q", "quiet", false, "don't display metadata");
            options.addOption("h", "help", false, "help");
            CommandLine line = parser.parse(options, argv);
            String command = null;
            String bteInputType = null;
            String sourcedir = null;
            String mapfile = null;
            String eperson = null;
            String[] collections = null;
            if (line.hasOption('h')) {
                HelpFormatter myhelp = new HelpFormatter();
                myhelp.printHelp("ItemImport\n", options);
                System.out.println("\nadding items:    ItemImport -a -e eperson -c collection -s sourcedir -m mapfile");
                System.out.println("\nadding items from zip file:    ItemImport -a -e eperson -c collection -s sourcedir -z filename.zip -m mapfile");
                System.out.println("replacing items: ItemImport -r -e eperson -c collection -s sourcedir -m mapfile");
                System.out.println("deleting items:  ItemImport -d -e eperson -m mapfile");
                System.out.println("If multiple collections are specified, the first collection will be the one that owns the item.");
                System.exit(0);
            }
            if (line.hasOption('a')) {
                command = "add";
            }
            if (line.hasOption('r')) {
                command = "replace";
            }
            if (line.hasOption('d')) {
                command = "delete";
            }
            if (line.hasOption('b')) {
                command = "add-bte";
            }
            if (line.hasOption('i')) {
                bteInputType = line.getOptionValue('i');
            }
            if (line.hasOption('w')) {
                useWorkflow = true;
                if (line.hasOption('n')) {
                    useWorkflowSendEmail = true;
                }
            }
            if (line.hasOption('t')) {
                isTest = true;
                System.out.println("**Test Run** - not actually importing items.");
            }
            if (line.hasOption('p')) {
                template = true;
            }
            if (line.hasOption('s')) {
                sourcedir = line.getOptionValue('s');
            }
            if (line.hasOption('m')) {
                mapfile = line.getOptionValue('m');
            }
            if (line.hasOption('e')) {
                eperson = line.getOptionValue('e');
            }
            if (line.hasOption('c')) {
                collections = line.getOptionValues('c');
            }
            if (line.hasOption('R')) {
                isResume = true;
                System.out.println("**Resume import** - attempting to import items not already imported");
            }
            if (line.hasOption('q')) {
                isQuiet = true;
            }
            boolean zip = false;
            String zipfilename = "";
            String ziptempdir = ConfigurationManager.getProperty("org.dspace.app.itemexport.work.dir");
            if (line.hasOption('z')) {
                zip = true;
                zipfilename = sourcedir + System.getProperty("file.separator") + line.getOptionValue('z');
            }
            if (command == null) {
                System.out.println("Error - must run with either add, replace, or remove (run with -h flag for details)");
                System.exit(1);
            } else if ("add".equals(command) || "replace".equals(command)) {
                if (sourcedir == null) {
                    System.out.println("Error - a source directory containing items must be set");
                    System.out.println(" (run with -h flag for details)");
                    System.exit(1);
                }
                if (mapfile == null) {
                    System.out.println("Error - a map file to hold importing results must be specified");
                    System.out.println(" (run with -h flag for details)");
                    System.exit(1);
                }
                if (eperson == null) {
                    System.out.println("Error - an eperson to do the importing must be specified");
                    System.out.println(" (run with -h flag for details)");
                    System.exit(1);
                }
                if (collections == null) {
                    System.out.println("Error - at least one destination collection must be specified");
                    System.out.println(" (run with -h flag for details)");
                    System.exit(1);
                }
            } else if ("add-bte".equals(command)) {
                if (sourcedir == null) {
                    System.out.println("Error - a source file containing items must be set");
                    System.out.println(" (run with -h flag for details)");
                    System.exit(1);
                }
                if (mapfile == null) {
                    System.out.println("Error - a map file to hold importing results must be specified");
                    System.out.println(" (run with -h flag for details)");
                    System.exit(1);
                }
                if (eperson == null) {
                    System.out.println("Error - an eperson to do the importing must be specified");
                    System.out.println(" (run with -h flag for details)");
                    System.exit(1);
                }
                if (collections == null) {
                    System.out.println("Error - at least one destination collection must be specified");
                    System.out.println(" (run with -h flag for details)");
                    System.exit(1);
                }
                if (bteInputType == null) {
                    System.out.println("Error - an input type (tsv, csv, ris, endnote, bibtex or any other type you have specified in BTE Spring XML configuration file) must be specified");
                    System.out.println(" (run with -h flag for details)");
                    System.exit(1);
                }
            } else if ("delete".equals(command)) {
                if (eperson == null) {
                    System.out.println("Error - an eperson to do the importing must be specified");
                    System.exit(1);
                }
                if (mapfile == null) {
                    System.out.println("Error - a map file must be specified");
                    System.exit(1);
                }
            }
            if (isResume && !"add".equals(command)) {
                System.out.println("Error - resume option only works with --add command");
                System.exit(1);
            }
            File myFile = new File(mapfile);
            if (!isResume && "add".equals(command) && myFile.exists()) {
                System.out.println("Error - the mapfile " + mapfile + " already exists.");
                System.out.println("Either delete it or use --resume if attempting to resume an aborted import.");
                System.exit(1);
            }
            if (zip) {
                File tempdir;
                File zipfile = new File(sourcedir);
                if (!zipfile.canRead()) {
                    System.out.println("Zip file '" + sourcedir + "' does not exist, or is not readable.");
                    System.exit(1);
                }
                if (ziptempdir == null) {
                    System.out.println("Unable to unzip import file as the key 'org.dspace.app.itemexport.work.dir' is not set in dspace.cfg");
                    System.exit(1);
                }
                if (!(zipfile = new File(ziptempdir)).isDirectory()) {
                    System.out.println("'" + ConfigurationManager.getProperty("org.dspace.app.itemexport.work.dir") + "' as defined by the key 'org.dspace.app.itemexport.work.dir' in dspace.cfg " + "is not a valid directory");
                    System.exit(1);
                }
                if (!(tempdir = new File(ziptempdir)).exists() && !tempdir.mkdirs()) {
                    log.error((Object)"Unable to create temporary directory");
                }
                sourcedir = ziptempdir + System.getProperty("file.separator") + line.getOptionValue("z");
                ziptempdir = ziptempdir + System.getProperty("file.separator") + line.getOptionValue("z") + System.getProperty("file.separator");
            }
            ItemImport myloader = new ItemImport();
            Context c = new Context();
            EPerson myEPerson = null;
            myEPerson = eperson.indexOf(64) != -1 ? EPerson.findByEmail(c, eperson) : EPerson.find(c, Integer.parseInt(eperson));
            if (myEPerson == null) {
                System.out.println("Error, eperson cannot be found: " + eperson);
                System.exit(1);
            }
            c.setCurrentUser(myEPerson);
            Collection[] mycollections = null;
            if (!"delete".equals(command)) {
                System.out.println("Destination collections:");
                mycollections = new Collection[collections.length];
                for (int i = 0; i < collections.length; ++i) {
                    if (collections[i].indexOf(47) != -1) {
                        mycollections[i] = (Collection)HandleManager.resolveToObject(c, collections[i]);
                        if (mycollections[i] == null || mycollections[i].getType() != 3) {
                            mycollections[i] = null;
                        }
                    } else if (collections[i] != null) {
                        mycollections[i] = Collection.find(c, Integer.parseInt(collections[i]));
                    }
                    if (mycollections[i] == null) {
                        throw new IllegalArgumentException("Cannot resolve " + collections[i] + " to collection");
                    }
                    String owningPrefix = "";
                    if (i == 0) {
                        owningPrefix = "Owning ";
                    }
                    System.out.println(owningPrefix + " Collection: " + mycollections[i].getMetadata("name"));
                }
            }
            try {
                if (zip) {
                    ZipFile zf = new ZipFile(zipfilename);
                    Enumeration<? extends ZipEntry> entries = zf.entries();
                    while (entries.hasMoreElements()) {
                        int len;
                        File dir;
                        ZipEntry entry = entries.nextElement();
                        if (entry.isDirectory()) {
                            if (new File(ziptempdir + entry.getName()).mkdir()) continue;
                            log.error((Object)"Unable to create contents directory");
                            continue;
                        }
                        System.out.println("Extracting file: " + entry.getName());
                        int index = entry.getName().lastIndexOf(47);
                        if (index == -1) {
                            index = entry.getName().lastIndexOf(92);
                        }
                        if (index > 0 && !(dir = new File(ziptempdir + entry.getName().substring(0, index))).mkdirs()) {
                            log.error((Object)"Unable to create directory");
                        }
                        byte[] buffer = new byte[1024];
                        InputStream in = zf.getInputStream(entry);
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(ziptempdir + entry.getName()));
                        while ((len = in.read(buffer)) >= 0) {
                            out.write(buffer, 0, len);
                        }
                        in.close();
                        out.close();
                    }
                }
                c.turnOffAuthorisationSystem();
                if ("add".equals(command)) {
                    myloader.addItems(c, mycollections, sourcedir, mapfile, template);
                } else if ("replace".equals(command)) {
                    myloader.replaceItems(c, mycollections, sourcedir, mapfile, template);
                } else if ("delete".equals(command)) {
                    myloader.deleteItems(c, mapfile);
                } else if ("add-bte".equals(command)) {
                    myloader.addBTEItems(c, mycollections, sourcedir, mapfile, template, bteInputType);
                }
                c.complete();
            }
            catch (Exception e) {
                if (mapOut != null) {
                    mapOut.close();
                }
                mapOut = null;
                c.abort();
                e.printStackTrace();
                System.out.println(e);
                status = 1;
            }
            try {
                if (zip) {
                    System.gc();
                    System.out.println("Deleting temporary zip directory: " + ziptempdir);
                    ItemImport.deleteDirectory(new File(ziptempdir));
                }
            }
            catch (Exception ex) {
                System.out.println("Unable to delete temporary zip archive location: " + ziptempdir);
            }
            if (mapOut != null) {
                mapOut.close();
            }
            if (isTest) {
                System.out.println("***End of Test Run***");
            }
        }
        finally {
            DSIndexer.setBatchProcessingMode(false);
            Date endTime = new Date();
            System.out.println("Started: " + startTime.getTime());
            System.out.println("Ended: " + endTime.getTime());
            System.out.println("Elapsed time: " + (endTime.getTime() - startTime.getTime()) / 1000L + " secs (" + (endTime.getTime() - startTime.getTime()) + " msecs)");
        }
        System.exit(status);
    }

    private void addBTEItems(Context c, Collection[] mycollections, String sourceDir, String mapFile, boolean template, String inputType) throws Exception {
        TransformationEngine te = (TransformationEngine)new DSpace().getSingletonService(TransformationEngine.class);
        DataLoaderService dls = (DataLoaderService)new DSpace().getSingletonService(DataLoaderService.class);
        DataLoader dataLoader = dls.getDataLoaders().get(inputType);
        if (dataLoader != null) {
            System.out.println("INFO: Dataloader " + dataLoader.toString() + " will be used for the import!");
            dataLoader.setFileName(sourceDir);
            te.setDataLoader(dataLoader);
            try {
                te.transform();
            }
            catch (UnknownClassifierException e) {
                e.printStackTrace();
            }
            catch (UnknownInputFileType e) {
                e.printStackTrace();
            }
            catch (UnimplementedAbstractMethod e) {
                e.printStackTrace();
            }
            catch (UnsupportedComparatorMode e) {
                e.printStackTrace();
            }
            catch (UnsupportedCriterion e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Error: The key used in -i parameter must match a valid DataLoader in the BTE Spring XML configuration file!");
            return;
        }
        ItemImport myloader = new ItemImport();
        myloader.addItems(c, mycollections, "./bte_output_dspace", mapFile, template);
        ItemImport.deleteDirectory(new File("./bte_output_dspace"));
    }

    private void addItems(Context c, Collection[] mycollections, String sourceDir, String mapFile, boolean template) throws Exception {
        File d;
        Map<Object, Object> skipItems = new HashMap();
        System.out.println("Adding items from directory: " + sourceDir);
        System.out.println("Generating mapfile: " + mapFile);
        File outFile = null;
        if (!isTest) {
            if (isResume) {
                skipItems = this.readMapFile(mapFile);
            }
            if ((mapOut = new PrintWriter(new FileWriter(outFile = new File(mapFile), isResume))) == null) {
                throw new Exception("can't open mapfile: " + mapFile);
            }
        }
        if ((d = new File(sourceDir)) == null || !d.isDirectory()) {
            System.out.println("Error, cannot open source directory " + sourceDir);
            System.exit(1);
        }
        Object[] dircontents = d.list(directoryFilter);
        Arrays.sort(dircontents);
        for (int i = 0; i < dircontents.length; ++i) {
            if (skipItems.containsKey(dircontents[i])) {
                System.out.println("Skipping import of " + (String)dircontents[i]);
                continue;
            }
            this.addItem(c, mycollections, sourceDir, (String)dircontents[i], mapOut, template);
            System.out.println(i + " " + (String)dircontents[i]);
            c.clearCache();
        }
    }

    private void replaceItems(Context c, Collection[] mycollections, String sourceDir, String mapFile, boolean template) throws Exception {
        File d = new File(sourceDir);
        if (d == null || !d.isDirectory()) {
            System.out.println("Error, cannot open source directory " + sourceDir);
            System.exit(1);
        }
        Map<String, String> myHash = this.readMapFile(mapFile);
        for (Map.Entry<String, String> mapEntry : myHash.entrySet()) {
            String newItemName = mapEntry.getKey();
            String oldHandle = mapEntry.getValue();
            Item oldItem = null;
            if (oldHandle.indexOf(47) != -1) {
                System.out.println("\tReplacing:  " + oldHandle);
                oldItem = (Item)HandleManager.resolveToObject(c, oldHandle);
            } else {
                oldItem = Item.find(c, Integer.parseInt(oldHandle));
            }
            File handleFile = new File(sourceDir + File.separatorChar + newItemName + File.separatorChar + "handle");
            PrintWriter handleOut = new PrintWriter(new FileWriter(handleFile, true));
            if (handleOut == null) {
                throw new Exception("can't open handle file: " + handleFile.getCanonicalPath());
            }
            handleOut.println(oldHandle);
            handleOut.close();
            this.deleteItem(c, oldItem);
            this.addItem(c, mycollections, sourceDir, newItemName, null, template);
            c.clearCache();
        }
    }

    private void deleteItems(Context c, String mapFile) throws Exception {
        System.out.println("Deleting items listed in mapfile: " + mapFile);
        Map<String, String> myhash = this.readMapFile(mapFile);
        Iterator<String> i = myhash.keySet().iterator();
        while (i.hasNext()) {
            String itemID = myhash.get(i.next());
            if (itemID.indexOf(47) != -1) {
                String myhandle = itemID;
                System.out.println("Deleting item " + myhandle);
                this.deleteItem(c, myhandle);
            } else {
                Item myitem = Item.find(c, Integer.parseInt(itemID));
                System.out.println("Deleting item " + itemID);
                this.deleteItem(c, myitem);
            }
            c.clearCache();
        }
    }

    private Item addItem(Context c, Collection[] mycollections, String path, String itemname, PrintWriter mapOut, boolean template) throws Exception {
        String mapOutput = null;
        System.out.println("Adding item from directory " + itemname);
        Item myitem = null;
        WorkspaceItem wi = null;
        if (!isTest) {
            wi = WorkspaceItem.create(c, mycollections[0], template);
            myitem = wi.getItem();
        }
        this.loadMetadata(c, myitem, path + File.separatorChar + itemname + File.separatorChar);
        List<String> options = this.processContentsFile(c, myitem, path + File.separatorChar + itemname, "contents");
        if (useWorkflow) {
            if (!isTest) {
                if (ConfigurationManager.getProperty("workflow", "workflow.framework").equals("xmlworkflow")) {
                    if (useWorkflowSendEmail) {
                        XmlWorkflowManager.start(c, wi);
                    } else {
                        XmlWorkflowManager.startWithoutNotify(c, wi);
                    }
                } else if (useWorkflowSendEmail) {
                    WorkflowManager.start(c, wi);
                } else {
                    WorkflowManager.startWithoutNotify(c, wi);
                }
                mapOutput = itemname + " " + myitem.getID();
            }
        } else {
            String myhandle = this.processHandleFile(c, myitem, path + File.separatorChar + itemname, "handle");
            if (!isTest) {
                InstallItem.installItem(c, wi, myhandle);
                myhandle = HandleManager.findHandle(c, myitem);
                mapOutput = itemname + " " + myhandle;
            }
            if (options.size() > 0) {
                System.out.println("Processing options");
                this.processOptions(c, myitem, options);
            }
        }
        if (mycollections.length > 1) {
            for (int i = 1; i < mycollections.length; ++i) {
                if (isTest) continue;
                mycollections[i].addItem(myitem);
            }
        }
        if (mapOut != null) {
            mapOut.println(mapOutput);
        }
        c.commit();
        return myitem;
    }

    private void deleteItem(Context c, Item myitem) throws Exception {
        if (!isTest) {
            Collection[] collections = myitem.getCollections();
            for (int i = 0; i < collections.length; ++i) {
                collections[i].removeItem(myitem);
            }
        }
    }

    private void deleteItem(Context c, String myhandle) throws Exception {
        Item myitem = (Item)HandleManager.resolveToObject(c, myhandle);
        if (myitem == null) {
            System.out.println("Error - cannot locate item - already deleted?");
        } else {
            this.deleteItem(c, myitem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> readMapFile(String filename) throws Exception {
        HashMap<String, String> myHash = new HashMap<String, String>();
        BufferedReader is = null;
        try {
            String line;
            is = new BufferedReader(new FileReader(filename));
            while ((line = is.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                if (!st.hasMoreTokens()) {
                    throw new Exception("Bad mapfile line:\n" + line);
                }
                String myFile = st.nextToken();
                if (!st.hasMoreTokens()) {
                    throw new Exception("Bad mapfile line:\n" + line);
                }
                String myHandle = st.nextToken();
                myHash.put(myFile, myHandle);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return myHash;
    }

    private void loadMetadata(Context c, Item myitem, String path) throws SQLException, IOException, ParserConfigurationException, SAXException, TransformerException, AuthorizeException {
        this.loadDublinCore(c, myitem, path + "dublin_core.xml");
        File folder = new File(path);
        File[] file = folder.listFiles(metadataFileFilter);
        for (int i = 0; i < file.length; ++i) {
            this.loadDublinCore(c, myitem, file[i].getAbsolutePath());
        }
    }

    private void loadDublinCore(Context c, Item myitem, String filename) throws SQLException, IOException, ParserConfigurationException, SAXException, TransformerException, AuthorizeException {
        Document document = ItemImport.loadXML(filename);
        NodeList metadata = XPathAPI.selectNodeList((Node)document, (String)"/dublin_core");
        Node schemaAttr = metadata.item(0).getAttributes().getNamedItem("schema");
        String schema = schemaAttr == null ? "dc" : schemaAttr.getNodeValue();
        NodeList dcNodes = XPathAPI.selectNodeList((Node)document, (String)"/dublin_core/dcvalue");
        if (!isQuiet) {
            System.out.println("\tLoading dublin core from " + filename);
        }
        for (int i = 0; i < dcNodes.getLength(); ++i) {
            Node n = dcNodes.item(i);
            this.addDCValue(c, myitem, schema, n);
        }
    }

    private void addDCValue(Context c, Item i, String schema, Node n) throws TransformerException, SQLException, AuthorizeException {
        String value = this.getStringValue(n);
        if (value == null) {
            value = "";
        }
        String element = this.getAttributeValue(n, "element");
        String qualifier = this.getAttributeValue(n, "qualifier");
        String language = this.getAttributeValue(n, "language");
        if (language != null) {
            language = language.trim();
        }
        if (!isQuiet) {
            System.out.println("\tSchema: " + schema + " Element: " + element + " Qualifier: " + qualifier + " Value: " + value);
        }
        if ("none".equals(qualifier) || "".equals(qualifier)) {
            qualifier = null;
        }
        if (StringUtils.isEmpty((String)language)) {
            language = ConfigurationManager.getProperty("default.language");
        }
        if (language == null) {
            language = "en";
        }
        if (!isTest) {
            i.addMetadata(schema, element, qualifier, language, value);
        } else {
            MetadataSchema foundSchema = MetadataSchema.find(c, schema);
            if (foundSchema == null) {
                System.out.println("ERROR: schema '" + schema + "' was not found in the registry.");
                return;
            }
            int schemaID = foundSchema.getSchemaID();
            MetadataField foundField = MetadataField.findByElement(c, schemaID, element, qualifier);
            if (foundField == null) {
                System.out.println("ERROR: Metadata field: '" + schema + "." + element + "." + qualifier + "' was not found in the registry.");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processHandleFile(Context c, Item i, String path, String filename) {
        File file = new File(path + File.separatorChar + filename);
        String result = null;
        System.out.println("Processing handle file: " + filename);
        if (file.exists()) {
            BufferedReader is = null;
            try {
                is = new BufferedReader(new FileReader(file));
                result = is.readLine();
                System.out.println("read handle: '" + result + "'");
            }
            catch (FileNotFoundException e) {
                System.out.println("It appears there is no handle file -- generating one");
            }
            catch (IOException e) {
                System.out.println("It appears there is no handle file -- generating one");
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e1) {
                        System.err.println("Non-critical problem releasing resources.");
                    }
                }
            }
        } else {
            System.out.println("It appears there is no handle file -- generating one");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> processContentsFile(Context c, Item i, String path, String filename) throws SQLException, IOException, AuthorizeException {
        File contentsFile = new File(path + File.separatorChar + filename);
        String line = "";
        ArrayList<String> options = new ArrayList<String>();
        System.out.println("\tProcessing contents file: " + contentsFile);
        if (contentsFile.exists()) {
            BufferedReader is = null;
            try {
                is = new BufferedReader(new FileReader(contentsFile));
                while ((line = is.readLine()) != null) {
                    if ("".equals(line.trim())) continue;
                    if (line.trim().startsWith("-r ")) {
                        String sRegistrationLine = line.trim();
                        int iAssetstore = -1;
                        String sFilePath = null;
                        String sBundle = null;
                        StringTokenizer tokenizer = new StringTokenizer(sRegistrationLine);
                        while (tokenizer.hasMoreTokens()) {
                            String sToken = tokenizer.nextToken();
                            if ("-r".equals(sToken)) continue;
                            if ("-s".equals(sToken) && tokenizer.hasMoreTokens()) {
                                try {
                                    iAssetstore = Integer.parseInt(tokenizer.nextToken());
                                }
                                catch (NumberFormatException numberFormatException) {}
                                continue;
                            }
                            if ("-f".equals(sToken) && tokenizer.hasMoreTokens()) {
                                sFilePath = tokenizer.nextToken();
                                continue;
                            }
                            if (!sToken.startsWith("bundle:")) continue;
                            sBundle = sToken.substring(7);
                        }
                        if (iAssetstore == -1 || sFilePath == null) {
                            System.out.println("\tERROR: invalid contents file line");
                            System.out.println("\t\tSkipping line: " + sRegistrationLine);
                            continue;
                        }
                        this.registerBitstream(c, i, iAssetstore, sFilePath, sBundle);
                        System.out.println("\tRegistering Bitstream: " + sFilePath + "\tAssetstore: " + iAssetstore + "\tBundle: " + sBundle + "\tDescription: " + sBundle);
                        continue;
                    }
                    int bitstreamEndIndex = line.indexOf(9);
                    if (bitstreamEndIndex == -1) {
                        this.processContentFileEntry(c, i, path, line, null, false);
                        System.out.println("\tBitstream: " + line);
                        continue;
                    }
                    String bitstreamName = line.substring(0, bitstreamEndIndex);
                    boolean bundleExists = false;
                    boolean permissionsExist = false;
                    boolean descriptionExists = false;
                    String bundleMarker = "\tbundle:";
                    int bMarkerIndex = line.indexOf(bundleMarker);
                    int bEndIndex = 0;
                    if (bMarkerIndex > 0) {
                        bEndIndex = line.indexOf("\t", bMarkerIndex + 1);
                        if (bEndIndex == -1) {
                            bEndIndex = line.length();
                        }
                        bundleExists = true;
                    }
                    String permissionsMarker = "\tpermissions:";
                    int pMarkerIndex = line.indexOf(permissionsMarker);
                    int pEndIndex = 0;
                    if (pMarkerIndex > 0) {
                        pEndIndex = line.indexOf("\t", pMarkerIndex + 1);
                        if (pEndIndex == -1) {
                            pEndIndex = line.length();
                        }
                        permissionsExist = true;
                    }
                    String descriptionMarker = "\tdescription:";
                    int dMarkerIndex = line.indexOf(descriptionMarker);
                    int dEndIndex = 0;
                    if (dMarkerIndex > 0) {
                        dEndIndex = line.indexOf("\t", dMarkerIndex + 1);
                        if (dEndIndex == -1) {
                            dEndIndex = line.length();
                        }
                        descriptionExists = true;
                    }
                    String primaryBitstreamMarker = "\tprimary:true";
                    boolean primary = false;
                    String primaryStr = "";
                    if (line.contains(primaryBitstreamMarker)) {
                        primary = true;
                        primaryStr = "\t **Setting as primary bitstream**";
                    }
                    if (bundleExists) {
                        String bundleName = line.substring(bMarkerIndex + bundleMarker.length(), bEndIndex).trim();
                        this.processContentFileEntry(c, i, path, bitstreamName, bundleName, primary);
                        System.out.println("\tBitstream: " + bitstreamName + "\tBundle: " + bundleName + primaryStr);
                    } else {
                        this.processContentFileEntry(c, i, path, bitstreamName, null, primary);
                        System.out.println("\tBitstream: " + bitstreamName + primaryStr);
                    }
                    if (!permissionsExist && !descriptionExists) continue;
                    String extraInfo = bitstreamName;
                    if (permissionsExist) {
                        extraInfo = extraInfo + line.substring(pMarkerIndex, pEndIndex);
                    }
                    if (descriptionExists) {
                        extraInfo = extraInfo + line.substring(dMarkerIndex, dEndIndex);
                    }
                    options.add(extraInfo);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        } else {
            String[] dirListing;
            for (String fileName : dirListing = new File(path).list()) {
                if ("dublin_core.xml".equals(fileName) || fileName.equals("handle") || fileName.startsWith("metadata_")) continue;
                throw new FileNotFoundException("No contents file found");
            }
            System.out.println("No contents file found - but only metadata files found. Assuming metadata only.");
        }
        return options;
    }

    private void processContentFileEntry(Context c, Item i, String path, String fileName, String bundleName, boolean primary) throws SQLException, IOException, AuthorizeException {
        String fullpath = path + File.separatorChar + fileName;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fullpath));
        Bitstream bs = null;
        String newBundleName = bundleName;
        if (bundleName == null) {
            newBundleName = "license.txt".equals(fileName) ? "LICENSE" : "ORIGINAL";
        }
        if (!isTest) {
            Bundle[] bundles = i.getBundles(newBundleName);
            Bundle targetBundle = null;
            targetBundle = bundles.length < 1 ? i.createBundle(newBundleName) : bundles[0];
            bs = targetBundle.createBitstream(bis);
            bs.setName(fileName);
            BitstreamFormat bf = FormatIdentifier.guessFormat(c, bs);
            bs.setFormat(bf);
            if (primary) {
                targetBundle.setPrimaryBitstreamID(bs.getID());
                targetBundle.update();
            }
            bs.update();
        }
        bis.close();
    }

    private void registerBitstream(Context c, Item i, int assetstore, String bitstreamPath, String bundleName) throws SQLException, IOException, AuthorizeException {
        Bitstream bs = null;
        String newBundleName = bundleName;
        if (bundleName == null) {
            newBundleName = bitstreamPath.endsWith("license.txt") ? "LICENSE" : "ORIGINAL";
        }
        if (!isTest) {
            Bundle[] bundles = i.getBundles(newBundleName);
            Bundle targetBundle = null;
            targetBundle = bundles.length < 1 ? i.createBundle(newBundleName) : bundles[0];
            bs = targetBundle.registerBitstream(assetstore, bitstreamPath);
            int iLastSlash = bitstreamPath.lastIndexOf(47);
            bs.setName(bitstreamPath.substring(iLastSlash + 1));
            BitstreamFormat bf = FormatIdentifier.guessFormat(c, bs);
            bs.setFormat(bf);
            bs.update();
        }
    }

    private void processOptions(Context c, Item myItem, List<String> options) throws SQLException, AuthorizeException {
        for (String line : options) {
            System.out.println("\tprocessing " + line);
            boolean permissionsExist = false;
            boolean descriptionExists = false;
            String permissionsMarker = "\tpermissions:";
            int pMarkerIndex = line.indexOf(permissionsMarker);
            int pEndIndex = 0;
            if (pMarkerIndex > 0) {
                pEndIndex = line.indexOf("\t", pMarkerIndex + 1);
                if (pEndIndex == -1) {
                    pEndIndex = line.length();
                }
                permissionsExist = true;
            }
            String descriptionMarker = "\tdescription:";
            int dMarkerIndex = line.indexOf(descriptionMarker);
            int dEndIndex = 0;
            if (dMarkerIndex > 0) {
                dEndIndex = line.indexOf("\t", dMarkerIndex + 1);
                if (dEndIndex == -1) {
                    dEndIndex = line.length();
                }
                descriptionExists = true;
            }
            int bsEndIndex = line.indexOf("\t");
            String bitstreamName = line.substring(0, bsEndIndex);
            int actionID = -1;
            String groupName = "";
            Group myGroup = null;
            if (permissionsExist) {
                String thisPermission = line.substring(pMarkerIndex + permissionsMarker.length(), pEndIndex);
                int pTypeIndex = thisPermission.indexOf(45);
                int groupIndex = thisPermission.indexOf(39, pTypeIndex);
                int groupEndIndex = thisPermission.indexOf(39, groupIndex + 1);
                if (groupIndex == -1) {
                    groupIndex = thisPermission.indexOf(32, pTypeIndex);
                    groupEndIndex = thisPermission.length();
                }
                groupName = thisPermission.substring(groupIndex + 1, groupEndIndex);
                if (thisPermission.toLowerCase().charAt(pTypeIndex + 1) == 'r') {
                    actionID = 0;
                } else if (thisPermission.toLowerCase().charAt(pTypeIndex + 1) == 'w') {
                    actionID = 1;
                }
                try {
                    myGroup = Group.findByName(c, groupName);
                }
                catch (SQLException sqle) {
                    System.out.println("SQL Exception finding group name: " + groupName);
                }
            }
            String thisDescription = "";
            if (descriptionExists) {
                thisDescription = line.substring(dMarkerIndex + descriptionMarker.length(), dEndIndex).trim();
            }
            Bitstream bs = null;
            boolean notfound = true;
            if (!isTest) {
                Bitstream[] bitstreams = myItem.getNonInternalBitstreams();
                for (int j = 0; j < bitstreams.length && notfound; ++j) {
                    if (!bitstreams[j].getName().equals(bitstreamName)) continue;
                    bs = bitstreams[j];
                    notfound = false;
                }
            }
            if (notfound && !isTest) {
                System.out.println("\tdefault permissions set for " + bitstreamName);
                continue;
            }
            if (isTest) continue;
            if (permissionsExist) {
                if (myGroup == null) {
                    System.out.println("\t" + groupName + " not found, permissions set to default");
                } else if (actionID == -1) {
                    System.out.println("\tinvalid permissions flag, permissions set to default");
                } else {
                    System.out.println("\tSetting special permissions for " + bitstreamName);
                    this.setPermission(c, myGroup, actionID, bs);
                }
            }
            if (!descriptionExists) continue;
            System.out.println("\tSetting description for " + bitstreamName);
            bs.setDescription(thisDescription);
            bs.update();
        }
    }

    private void setPermission(Context c, Group g, int actionID, Bitstream bs) throws SQLException, AuthorizeException {
        if (!isTest) {
            AuthorizeManager.removeAllPolicies(c, bs);
            ResourcePolicy rp = ResourcePolicy.create(c);
            rp.setResource(bs);
            rp.setAction(actionID);
            rp.setGroup(g);
            rp.update();
        } else if (actionID == 0) {
            System.out.println("\t\tpermissions: READ for " + g.getName());
        } else if (actionID == 1) {
            System.out.println("\t\tpermissions: WRITE for " + g.getName());
        }
    }

    private String getAttributeValue(Node n, String name) {
        NamedNodeMap nm = n.getAttributes();
        for (int i = 0; i < nm.getLength(); ++i) {
            Node node = nm.item(i);
            if (!name.equals(node.getNodeName())) continue;
            return node.getNodeValue();
        }
        return "";
    }

    private String getStringValue(Node node) {
        Node first;
        String value = node.getNodeValue();
        if (node.hasChildNodes() && (first = node.getFirstChild()).getNodeType() == 3) {
            return first.getNodeValue();
        }
        return value;
    }

    private static Document loadXML(String filename) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder.parse(new File(filename));
    }

    private static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    ItemImport.deleteDirectory(files[i]);
                    continue;
                }
                if (files[i].delete()) continue;
                log.error((Object)("Unable to delete file: " + files[i].getName()));
            }
        }
        boolean pathDeleted = path.delete();
        return pathDeleted;
    }
}

