/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.eperson.EPerson;

public class AuthenticationManager {
    private static AuthenticationMethod[] methodStack = (AuthenticationMethod[])PluginManager.getPluginSequence("authentication", AuthenticationMethod.class);

    public static int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) {
        return AuthenticationManager.authenticateInternal(context, username, password, realm, request, false);
    }

    public static int authenticateImplicit(Context context, String username, String password, String realm, HttpServletRequest request) {
        return AuthenticationManager.authenticateInternal(context, username, password, realm, request, true);
    }

    private static int authenticateInternal(Context context, String username, String password, String realm, HttpServletRequest request, boolean implicitOnly) {
        int bestRet = 5;
        for (int i = 0; i < methodStack.length; ++i) {
            if (implicitOnly && !methodStack[i].isImplicit()) continue;
            int ret = 0;
            try {
                ret = methodStack[i].authenticate(context, username, password, realm, request);
            }
            catch (SQLException e) {
                ret = 4;
            }
            if (ret == 1) {
                return ret;
            }
            if (ret >= bestRet) continue;
            bestRet = ret;
        }
        return bestRet;
    }

    public static boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        for (int i = 0; i < methodStack.length; ++i) {
            if (!methodStack[i].canSelfRegister(context, request, username)) continue;
            return true;
        }
        return false;
    }

    public static boolean allowSetPassword(Context context, HttpServletRequest request, String username) throws SQLException {
        for (int i = 0; i < methodStack.length; ++i) {
            if (!methodStack[i].allowSetPassword(context, request, username)) continue;
            return true;
        }
        return false;
    }

    public static void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
        for (AuthenticationMethod method : methodStack) {
            method.initEPerson(context, request, eperson);
        }
    }

    public static int[] getSpecialGroups(Context context, HttpServletRequest request) throws SQLException {
        ArrayList<int[]> gll = new ArrayList<int[]>();
        int totalLen = 0;
        for (int i = 0; i < methodStack.length; ++i) {
            int[] gl = methodStack[i].getSpecialGroups(context, request);
            if (gl.length <= 0) continue;
            gll.add(gl);
            totalLen += gl.length;
        }
        if (totalLen == 0) {
            return new int[0];
        }
        if (gll.size() == 1) {
            return (int[])gll.get(0);
        }
        int[] result = new int[totalLen];
        int k = 0;
        for (int i = 0; i < gll.size(); ++i) {
            int[] gl;
            for (int aGl : gl = (int[])gll.get(i)) {
                result[k++] = aGl;
            }
        }
        return result;
    }

    public static Iterator<AuthenticationMethod> authenticationMethodIterator() {
        return Arrays.asList(methodStack).iterator();
    }
}

