/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;

public class Email {
    private String content = "";
    private String subject = "";
    private List<Object> arguments = new ArrayList<Object>(50);
    private List<String> recipients = new ArrayList<String>(50);
    private String replyTo = null;
    private List<FileAttachment> attachments = new ArrayList<FileAttachment>(10);
    private String charset = null;
    private static final Logger log = Logger.getLogger(Email.class);

    public void addRecipient(String email) {
        this.recipients.add(email);
    }

    public void setContent(String cnt) {
        this.content = cnt;
        this.arguments = new ArrayList<Object>();
    }

    public void setSubject(String s) {
        this.subject = s;
    }

    public void setReplyTo(String email) {
        this.replyTo = email;
    }

    public void addArgument(Object arg) {
        this.arguments.add(arg);
    }

    public void addAttachment(File f, String name) {
        this.attachments.add(new FileAttachment(f, name));
    }

    public void setCharset(String cs) {
        this.charset = cs;
    }

    public void reset() {
        this.arguments = new ArrayList<Object>(50);
        this.recipients = new ArrayList<String>(50);
        this.attachments = new ArrayList<FileAttachment>(10);
        this.replyTo = null;
        this.charset = null;
    }

    public void send() throws MessagingException {
        Session session;
        String server = ConfigurationManager.getProperty("mail.server");
        String from = ConfigurationManager.getProperty("mail.from.address");
        boolean disabled = ConfigurationManager.getBooleanProperty("mail.server.disabled", false);
        if (disabled) {
            log.info((Object)("message not sent due to mail.server.disabled: " + this.subject));
            return;
        }
        Properties props = System.getProperties();
        props.put("mail.smtp.host", server);
        String portNo = ConfigurationManager.getProperty("mail.server.port");
        if (portNo == null) {
            portNo = "25";
        }
        props.put("mail.smtp.port", portNo.trim());
        if (this.charset == null) {
            this.charset = ConfigurationManager.getProperty("mail.charset");
        }
        String username = ConfigurationManager.getProperty("mail.server.username");
        String password = ConfigurationManager.getProperty("mail.server.password");
        if (username != null) {
            props.put("mail.smtp.auth", "true");
            SMTPAuthenticator smtpAuthenticator = new SMTPAuthenticator(username, password);
            session = Session.getInstance((Properties)props, (Authenticator)smtpAuthenticator);
        } else {
            session = Session.getDefaultInstance((Properties)props);
        }
        String extras = ConfigurationManager.getProperty("mail.extraproperties");
        if (extras != null && !"".equals(extras.trim())) {
            String[] arguments;
            for (String argument : arguments = extras.split(",")) {
                String key = argument.substring(0, argument.indexOf(61)).trim();
                String value = argument.substring(argument.indexOf(61) + 1).trim();
                props.put(key, value);
            }
        }
        MimeMessage message = new MimeMessage(session);
        Iterator<String> i = this.recipients.iterator();
        while (i.hasNext()) {
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(i.next()));
        }
        Object[] args = this.arguments.toArray();
        String fullMessage = MessageFormat.format(this.content, args);
        Date date = new Date();
        message.setSentDate(date);
        message.setFrom((Address)new InternetAddress(from));
        String fullSubject = MessageFormat.format(this.subject, args);
        if (this.charset != null) {
            message.setSubject(fullSubject, this.charset);
        } else {
            message.setSubject(fullSubject);
        }
        if (this.attachments.isEmpty()) {
            if (this.charset != null) {
                message.setText(fullMessage, this.charset);
            } else {
                message.setText(fullMessage);
            }
        } else {
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setText(fullMessage);
            multipart.addBodyPart((BodyPart)messageBodyPart);
            for (FileAttachment f : this.attachments) {
                messageBodyPart = new MimeBodyPart();
                messageBodyPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(f.file)));
                messageBodyPart.setFileName(f.name);
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
            message.setContent((Multipart)multipart);
        }
        if (this.replyTo != null) {
            Address[] replyToAddr = new Address[]{new InternetAddress(this.replyTo)};
            message.setReplyTo(replyToAddr);
        }
        Transport.send((Message)message);
    }

    public static void main(String[] args) {
        String to = ConfigurationManager.getProperty("mail.admin");
        String subject = "DSpace test email";
        String server = ConfigurationManager.getProperty("mail.server");
        String url = ConfigurationManager.getProperty("dspace.url");
        Email e = new Email();
        e.setSubject(subject);
        e.addRecipient(to);
        e.content = "This is a test email sent from DSpace: " + url;
        System.out.println("\nAbout to send test email:");
        System.out.println(" - To: " + to);
        System.out.println(" - Subject: " + subject);
        System.out.println(" - Server: " + server);
        try {
            e.send();
        }
        catch (MessagingException me) {
            System.err.println("\nError sending email:");
            System.err.println(" - Error: " + (Object)((Object)me));
            System.err.println("\nPlease see the DSpace documentation for assistance.\n");
            System.err.println("\n");
            System.exit(1);
        }
        System.out.println("\nEmail sent successfully!\n");
    }

    private static class SMTPAuthenticator
    extends Authenticator {
        private String name;
        private String password;

        public SMTPAuthenticator(String n, String p) {
            this.name = n;
            this.password = p;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.name, this.password);
        }
    }

    private static class FileAttachment {
        File file;
        String name;

        public FileAttachment(File f, String n) {
            this.file = f;
            this.name = n;
        }
    }
}

