/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeConfiguration;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.browse.BrowseException;
import org.dspace.browse.IndexBrowse;
import org.dspace.browse.ItemCountException;
import org.dspace.browse.ItemCounter;
import org.dspace.content.Bitstream;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.LicenseManager;
import org.dspace.core.LogManager;
import org.dspace.eperson.Group;
import org.dspace.event.Event;
import org.dspace.handle.HandleManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.workflow.WorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.CollectionRole;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class Collection
extends DSpaceObject {
    private static Logger log = Logger.getLogger(Collection.class);
    private Context ourContext;
    private TableRow collectionRow;
    private Bitstream logo;
    private Item template;
    private String handle;
    private boolean modified;
    private boolean modifiedMetadata;
    private Group[] workflowGroup;
    private Group submitters;
    private Group admins;

    Collection(Context context, TableRow row) throws SQLException {
        this.ourContext = context;
        this.collectionRow = row;
        this.logo = this.collectionRow.isColumnNull("logo_bitstream_id") ? null : Bitstream.find(this.ourContext, this.collectionRow.getIntColumn("logo_bitstream_id"));
        this.template = this.collectionRow.isColumnNull("template_item_id") ? null : Item.find(this.ourContext, this.collectionRow.getIntColumn("template_item_id"));
        this.workflowGroup = new Group[3];
        this.workflowGroup[0] = this.groupFromColumn("workflow_step_1");
        this.workflowGroup[1] = this.groupFromColumn("workflow_step_2");
        this.workflowGroup[2] = this.groupFromColumn("workflow_step_3");
        this.submitters = this.groupFromColumn("submitter");
        this.admins = this.groupFromColumn("admin");
        this.handle = HandleManager.findHandle(context, this);
        context.cache(this, row.getIntColumn("collection_id"));
        this.modified = false;
        this.modifiedMetadata = false;
        this.clearDetails();
    }

    public static Collection find(Context context, int id) throws SQLException {
        Collection fromCache = (Collection)context.fromCache(Collection.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "collection", id);
        if (row == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_collection", "not_found,collection_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_collection", "collection_id=" + id));
        }
        return new Collection(context, row);
    }

    static Collection create(Context context) throws SQLException, AuthorizeException {
        return Collection.create(context, null);
    }

    static Collection create(Context context, String handle) throws SQLException, AuthorizeException {
        TableRow row = DatabaseManager.create(context, "collection");
        Collection c = new Collection(context, row);
        try {
            c.handle = handle == null ? HandleManager.createHandle(context, c) : HandleManager.createHandle(context, c, handle);
        }
        catch (IllegalStateException ie) {
            try {
                if (c != null) {
                    c.delete();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw ie;
        }
        Group anonymousGroup = Group.find(context, 0);
        ResourcePolicy myPolicy = ResourcePolicy.create(context);
        myPolicy.setResource(c);
        myPolicy.setAction(0);
        myPolicy.setGroup(anonymousGroup);
        myPolicy.update();
        myPolicy = ResourcePolicy.create(context);
        myPolicy.setResource(c);
        myPolicy.setAction(10);
        myPolicy.setGroup(anonymousGroup);
        myPolicy.update();
        myPolicy = ResourcePolicy.create(context);
        myPolicy.setResource(c);
        myPolicy.setAction(9);
        myPolicy.setGroup(anonymousGroup);
        myPolicy.update();
        context.addEvent(new Event(1, 3, c.getID(), c.handle));
        log.info((Object)(LogManager.getHeader(context, "create_collection", "collection_id=" + row.getIntColumn("collection_id")) + ",handle=" + c.handle));
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection[] findAll(Context context) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(context, "collection", "SELECT * FROM collection ORDER BY name", new Object[0]);
        ArrayList<Collection> collections = new ArrayList<Collection>();
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                Collection fromCache = (Collection)context.fromCache(Collection.class, row.getIntColumn("collection_id"));
                if (fromCache != null) {
                    collections.add(fromCache);
                    continue;
                }
                collections.add(new Collection(context, row));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        Collection[] collectionArray = new Collection[collections.size()];
        collectionArray = collections.toArray(collectionArray);
        return collectionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection[] findAll(Context context, Integer limit, Integer offset) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(context, "collection", "SELECT * FROM collection ORDER BY name limit ? offset ?", limit, offset);
        ArrayList<Collection> collections = new ArrayList<Collection>();
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                Collection fromCache = (Collection)context.fromCache(Collection.class, row.getIntColumn("collection_id"));
                if (fromCache != null) {
                    collections.add(fromCache);
                    continue;
                }
                collections.add(new Collection(context, row));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        Collection[] collectionArray = new Collection[collections.size()];
        collectionArray = collections.toArray(collectionArray);
        return collectionArray;
    }

    public ItemIterator getItems() throws SQLException {
        String myQuery = "SELECT item.* FROM item, collection2item WHERE item.item_id=collection2item.item_id AND collection2item.collection_id= ? AND item.in_archive='1'";
        TableRowIterator rows = DatabaseManager.queryTable(this.ourContext, "item", myQuery, this.getID());
        return new ItemIterator(this.ourContext, rows);
    }

    public ItemIterator getItems(Integer limit, Integer offset) throws SQLException {
        String myQuery = "SELECT item.* FROM item, collection2item WHERE item.item_id=collection2item.item_id AND collection2item.collection_id= ? AND item.in_archive='1' limit ? offset ?";
        TableRowIterator rows = DatabaseManager.queryTable(this.ourContext, "item", myQuery, this.getID(), limit, offset);
        return new ItemIterator(this.ourContext, rows);
    }

    public ItemIterator getAllItems() throws SQLException {
        String myQuery = "SELECT item.* FROM item, collection2item WHERE item.item_id=collection2item.item_id AND collection2item.collection_id= ? ";
        TableRowIterator rows = DatabaseManager.queryTable(this.ourContext, "item", myQuery, this.getID());
        return new ItemIterator(this.ourContext, rows);
    }

    @Override
    public int getID() {
        return this.collectionRow.getIntColumn("collection_id");
    }

    @Override
    public String getHandle() {
        if (this.handle == null) {
            try {
                this.handle = HandleManager.findHandle(this.ourContext, this);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.handle;
    }

    public String getMetadata(String field) {
        String metadata = this.collectionRow.getStringColumn(field);
        return metadata == null ? "" : metadata;
    }

    public void setMetadata(String field, String value) throws MissingResourceException {
        if (field.trim().equals("name") && (value == null || value.trim().equals(""))) {
            try {
                value = I18nUtil.getMessage("org.dspace.workflow.WorkflowManager.untitled");
            }
            catch (MissingResourceException e) {
                value = "Untitled";
            }
        }
        if (value == null) {
            this.collectionRow.setColumnNull(field);
        } else {
            this.collectionRow.setColumn(field, value.trim());
        }
        this.modifiedMetadata = true;
        this.addDetails(field);
    }

    @Override
    public String getName() {
        return this.getMetadata("name");
    }

    public Bitstream getLogo() {
        return this.logo;
    }

    public Bitstream setLogo(InputStream is) throws AuthorizeException, IOException, SQLException {
        if (is != null || !AuthorizeManager.authorizeActionBoolean(this.ourContext, this, 2)) {
            this.canEdit(true);
        }
        if (!this.collectionRow.isColumnNull("logo_bitstream_id")) {
            this.logo.delete();
        }
        if (is == null) {
            this.collectionRow.setColumnNull("logo_bitstream_id");
            this.logo = null;
            log.info((Object)LogManager.getHeader(this.ourContext, "remove_logo", "collection_id=" + this.getID()));
        } else {
            Bitstream newLogo = Bitstream.create(this.ourContext, is);
            this.collectionRow.setColumn("logo_bitstream_id", newLogo.getID());
            this.logo = newLogo;
            List<ResourcePolicy> policies = AuthorizeManager.getPoliciesActionFilter(this.ourContext, this, 0);
            AuthorizeManager.addPolicies(this.ourContext, policies, newLogo);
            log.info((Object)LogManager.getHeader(this.ourContext, "set_logo", "collection_id=" + this.getID() + "logo_bitstream_id=" + newLogo.getID()));
        }
        this.modified = true;
        return this.logo;
    }

    public Group createWorkflowGroup(int step) throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeManageWorkflowsGroup(this.ourContext, this);
        if (this.workflowGroup[step - 1] == null) {
            this.ourContext.turnOffAuthorisationSystem();
            Group g = Group.create(this.ourContext);
            this.ourContext.restoreAuthSystemState();
            g.setName("COLLECTION_" + this.getID() + "_WORKFLOW_STEP_" + step);
            g.update();
            this.setWorkflowGroup(step, g);
            AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)this, 3, g);
        }
        return this.workflowGroup[step - 1];
    }

    public void setWorkflowGroup(int step, Group g) {
        this.workflowGroup[step - 1] = g;
        if (g == null) {
            this.collectionRow.setColumnNull("workflow_step_" + step);
        } else {
            this.collectionRow.setColumn("workflow_step_" + step, g.getID());
        }
        this.modified = true;
    }

    public Group getWorkflowGroup(int step) {
        return this.workflowGroup[step - 1];
    }

    public Group createSubmitters() throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeManageSubmittersGroup(this.ourContext, this);
        if (this.submitters == null) {
            this.ourContext.turnOffAuthorisationSystem();
            this.submitters = Group.create(this.ourContext);
            this.ourContext.restoreAuthSystemState();
            this.submitters.setName("COLLECTION_" + this.getID() + "_SUBMIT");
            this.submitters.update();
        }
        this.collectionRow.setColumn("submitter", this.submitters.getID());
        AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)this, 3, this.submitters);
        this.modified = true;
        return this.submitters;
    }

    public void removeSubmitters() throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeManageSubmittersGroup(this.ourContext, this);
        if (this.submitters == null) {
            return;
        }
        this.collectionRow.setColumnNull("submitter");
        this.submitters = null;
        this.modified = true;
    }

    public Group getSubmitters() {
        return this.submitters;
    }

    public Group createAdministrators() throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeManageAdminGroup(this.ourContext, this);
        if (this.admins == null) {
            this.ourContext.turnOffAuthorisationSystem();
            this.admins = Group.create(this.ourContext);
            this.ourContext.restoreAuthSystemState();
            this.admins.setName("COLLECTION_" + this.getID() + "_ADMIN");
            this.admins.update();
        }
        AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)this, 11, this.admins);
        this.collectionRow.setColumn("admin", this.admins.getID());
        this.modified = true;
        return this.admins;
    }

    public void removeAdministrators() throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeRemoveAdminGroup(this.ourContext, this);
        if (this.admins == null) {
            return;
        }
        this.collectionRow.setColumnNull("admin");
        this.admins = null;
        this.modified = true;
    }

    public Group getAdministrators() {
        return this.admins;
    }

    public String getLicense() {
        String license = this.getMetadata("license");
        if (license == null || license.trim().equals("")) {
            license = LicenseManager.getDefaultSubmissionLicense();
        }
        return license;
    }

    public String getLicenseCollection() {
        return this.getMetadata("license");
    }

    public boolean hasCustomLicense() {
        String license = this.getMetadata("license");
        return license != null && !license.trim().equals("");
    }

    public void setLicense(String license) {
        this.setMetadata("license", license);
    }

    public Item getTemplateItem() throws SQLException {
        return this.template;
    }

    public void createTemplateItem() throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeManageTemplateItem(this.ourContext, this);
        if (this.template == null) {
            this.template = Item.create(this.ourContext);
            this.collectionRow.setColumn("template_item_id", this.template.getID());
            log.info((Object)LogManager.getHeader(this.ourContext, "create_template_item", "collection_id=" + this.getID() + ",template_item_id=" + this.template.getID()));
        }
        this.modified = true;
    }

    public void removeTemplateItem() throws SQLException, AuthorizeException, IOException {
        AuthorizeUtil.authorizeManageTemplateItem(this.ourContext, this);
        this.collectionRow.setColumnNull("template_item_id");
        DatabaseManager.update(this.ourContext, this.collectionRow);
        if (this.template != null) {
            log.info((Object)LogManager.getHeader(this.ourContext, "remove_template_item", "collection_id=" + this.getID() + ",template_item_id=" + this.template.getID()));
            this.ourContext.turnOffAuthorisationSystem();
            this.template.delete();
            this.ourContext.restoreAuthSystemState();
            this.template = null;
        }
        this.ourContext.addEvent(new Event(2, 3, this.getID(), "remove_template_item"));
    }

    public void addItem(Item item) throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        log.info((Object)LogManager.getHeader(this.ourContext, "add_item", "collection_id=" + this.getID() + ",item_id=" + item.getID()));
        TableRow row = DatabaseManager.row("collection2item");
        row.setColumn("collection_id", this.getID());
        row.setColumn("item_id", item.getID());
        DatabaseManager.insert(this.ourContext, row);
        this.ourContext.addEvent(new Event(8, 3, this.getID(), 2, item.getID(), item.getHandle()));
    }

    public void removeItem(Item item) throws SQLException, AuthorizeException, IOException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 4);
        TableRow row = DatabaseManager.querySingle(this.ourContext, "SELECT COUNT(DISTINCT collection_id) AS num FROM collection2item WHERE item_id= ? ", item.getID());
        DatabaseManager.setConstraintDeferred(this.ourContext, "coll2item_item_fk");
        if (row.getLongColumn("num") == 1L) {
            item.delete();
        }
        log.info((Object)LogManager.getHeader(this.ourContext, "remove_item", "collection_id=" + this.getID() + ",item_id=" + item.getID()));
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM collection2item WHERE collection_id= ? AND item_id= ? ", this.getID(), item.getID());
        DatabaseManager.setConstraintImmediate(this.ourContext, "coll2item_item_fk");
        this.ourContext.addEvent(new Event(16, 3, this.getID(), 2, item.getID(), item.getHandle()));
    }

    @Override
    public void update() throws SQLException, AuthorizeException {
        this.canEdit(true);
        log.info((Object)LogManager.getHeader(this.ourContext, "update_collection", "collection_id=" + this.getID()));
        DatabaseManager.update(this.ourContext, this.collectionRow);
        if (this.modified) {
            this.ourContext.addEvent(new Event(2, 3, this.getID(), null));
            this.modified = false;
        }
        if (this.modifiedMetadata) {
            this.ourContext.addEvent(new Event(4, 3, this.getID(), this.getDetails()));
            this.modifiedMetadata = false;
            this.clearDetails();
        }
    }

    public boolean canEditBoolean() throws SQLException {
        return this.canEditBoolean(true);
    }

    public boolean canEditBoolean(boolean useInheritance) throws SQLException {
        try {
            this.canEdit(useInheritance);
            return true;
        }
        catch (AuthorizeException e) {
            return false;
        }
    }

    public void canEdit() throws AuthorizeException, SQLException {
        this.canEdit(true);
    }

    public void canEdit(boolean useInheritance) throws AuthorizeException, SQLException {
        Community[] parents = this.getCommunities();
        for (int i = 0; i < parents.length; ++i) {
            if (AuthorizeManager.authorizeActionBoolean(this.ourContext, parents[i], 1, useInheritance)) {
                return;
            }
            if (!AuthorizeManager.authorizeActionBoolean(this.ourContext, parents[i], 3, useInheritance)) continue;
            return;
        }
        AuthorizeManager.authorizeAction(this.ourContext, this, 1, useInheritance);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    void delete() throws SQLException, AuthorizeException, IOException {
        Collection.log.info((Object)LogManager.getHeader(this.ourContext, "delete_collection", "collection_id=" + this.getID()));
        this.ourContext.addEvent(new Event(32, 3, this.getID(), this.getHandle()));
        this.ourContext.removeCached(this, this.getID());
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM subscription WHERE collection_id= ? ", new Object[]{this.getID()});
        this.removeTemplateItem();
        items = this.getAllItems();
lbl8:
        // 2 sources

        try {
            while (items.hasNext()) {
                block23: {
                    item = items.next();
                    ib = new IndexBrowse(this.ourContext);
                    if (!item.isOwningCollection(this)) break block23;
                    collections = item.getCollections();
                    for (i = 0; i < collections.length; ++i) {
                        ib.itemRemoved(item);
                        collections[i].removeItem(item);
                    }
                    ** GOTO lbl8
                }
                ib.indexItem(item);
                this.removeItem(item);
            }
        }
        catch (BrowseException e) {
            Collection.log.error((Object)"caught exception: ", (Throwable)e);
            throw new IOException(e.getMessage(), e);
        }
        finally {
            if (items != null) {
                items.close();
            }
        }
        this.setLogo(null);
        AuthorizeManager.removeAllPolicies(this.ourContext, this);
        if (ConfigurationManager.getProperty("workflow", "workflow.framework").equals("xmlworkflow")) {
            xmlWfarray = XmlWorkflowItem.findByCollection(this.ourContext, this);
            for (InProgressSubmission aXmlWfarray : xmlWfarray) {
                myItem = aXmlWfarray.getItem();
                aXmlWfarray.deleteWrapper();
                myItem.delete();
            }
        } else {
            wfarray = WorkflowItem.findByCollection(this.ourContext, this);
            for (InProgressSubmission aWfarray : wfarray) {
                myItem = aWfarray.getItem();
                aWfarray.deleteWrapper();
                myItem.delete();
            }
        }
        wsarray = WorkspaceItem.findByCollection(this.ourContext, this);
        for (InProgressSubmission aWsarray : wsarray) {
            aWsarray.deleteAll();
        }
        try {
            ic = new ItemCounter(this.ourContext);
            ic.remove(this);
        }
        catch (ItemCountException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        HandleManager.unbindHandle(this.ourContext, this);
        if (ConfigurationManager.getProperty("workflow", "workflow.framework").equals("xmlworkflow")) {
            for (CollectionRole collectionRole : CollectionRole.findByCollection(this.ourContext, this.getID())) {
                collectionRole.delete();
            }
        }
        DatabaseManager.delete(this.ourContext, this.collectionRow);
        g = null;
        g = this.getWorkflowGroup(1);
        if (g != null) {
            g.delete();
        }
        if ((g = this.getWorkflowGroup(2)) != null) {
            g.delete();
        }
        if ((g = this.getWorkflowGroup(3)) != null) {
            g.delete();
        }
        if ((g = this.getAdministrators()) != null) {
            g.delete();
        }
        if ((g = this.getSubmitters()) != null) {
            g.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Community[] getCommunities() throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "community", "SELECT community.* FROM community, community2collection WHERE community.community_id=community2collection.community_id AND community2collection.collection_id= ? ", this.getID());
        ArrayList<Community> communities = new ArrayList<Community>();
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                Community owner = (Community)this.ourContext.fromCache(Community.class, row.getIntColumn("community_id"));
                if (owner == null) {
                    owner = new Community(this.ourContext, row);
                }
                communities.add(owner);
                Community[] parents = owner.getAllParents();
                communities.addAll(Arrays.asList(parents));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        Community[] communityArray = new Community[communities.size()];
        communityArray = communities.toArray(communityArray);
        return communityArray;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Collection otherCollection = (Collection)other;
        return this.getID() == otherCollection.getID();
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.collectionRow != null ? this.collectionRow.hashCode() : 0);
        return hash;
    }

    private Group groupFromColumn(String col) throws SQLException {
        if (this.collectionRow.isColumnNull(col)) {
            return null;
        }
        return Group.find(this.ourContext, this.collectionRow.getIntColumn(col));
    }

    @Override
    public int getType() {
        return 3;
    }

    public static Collection[] findAuthorized(Context context, Community comm, int actionID) throws SQLException {
        ArrayList<Collection> myResults = new ArrayList<Collection>();
        Collection[] myCollections = null;
        myCollections = comm != null ? comm.getCollections() : Collection.findAll(context);
        for (int i = 0; i < myCollections.length; ++i) {
            if (!AuthorizeManager.authorizeActionBoolean(context, myCollections[i], actionID)) continue;
            myResults.add(myCollections[i]);
        }
        myCollections = new Collection[myResults.size()];
        myCollections = myResults.toArray(myCollections);
        return myCollections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countItems() throws SQLException {
        int itemcount = 0;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            String query = "SELECT count(*) FROM collection2item, item WHERE collection2item.collection_id =  ? AND collection2item.item_id = item.item_id AND in_archive ='1' AND item.withdrawn='0' ";
            statement = this.ourContext.getDBConnection().prepareStatement(query);
            statement.setInt(1, this.getID());
            rs = statement.executeQuery();
            if (rs != null) {
                rs.next();
                itemcount = rs.getInt(1);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {}
            }
        }
        return itemcount;
    }

    @Override
    public DSpaceObject getAdminObject(int action) throws SQLException {
        DSpaceObject adminObject = null;
        Community community = null;
        Community[] communities = this.getCommunities();
        if (communities != null && communities.length > 0) {
            community = communities[0];
        }
        switch (action) {
            case 4: {
                if (AuthorizeConfiguration.canCollectionAdminPerformItemDeletion()) {
                    adminObject = this;
                    break;
                }
                if (!AuthorizeConfiguration.canCommunityAdminPerformItemDeletion()) break;
                adminObject = community;
                break;
            }
            case 2: {
                if (!AuthorizeConfiguration.canCommunityAdminPerformSubelementDeletion()) break;
                adminObject = community;
                break;
            }
            default: {
                adminObject = this;
            }
        }
        return adminObject;
    }

    @Override
    public DSpaceObject getParentObject() throws SQLException {
        Community[] communities = this.getCommunities();
        if (communities != null && communities.length > 0 && communities[0] != null) {
            return communities[0];
        }
        return null;
    }

    @Override
    public void updateLastModified() {
        this.ourContext.addEvent(new Event(2, 3, this.getID(), null));
    }
}

