/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.DataLoadingSpec;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.RecordSet;
import gr.ekt.bte.dataloader.FileDataLoader;
import gr.ekt.bte.exceptions.MalformedSourceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.util.XMLUtils;
import org.dspace.submit.lookup.PubmedUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PubmedFileDataLoader
extends FileDataLoader {
    Map<String, String> fieldMap;

    public PubmedFileDataLoader() {
    }

    public PubmedFileDataLoader(String filename) {
        super(filename);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RecordSet getRecords() throws MalformedSourceException {
        RecordSet recordSet = new RecordSet();
        try {
            FileInputStream inputStream = new FileInputStream(new File(this.filename));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document inDoc = builder.parse(inputStream);
            Element xmlRoot = inDoc.getDocumentElement();
            List<Element> pubArticles = XMLUtils.getElementList(xmlRoot, "PubmedArticle");
            for (Element xmlArticle : pubArticles) {
                Record record = null;
                try {
                    record = PubmedUtils.convertCrossRefDomToRecord(xmlArticle);
                    recordSet.addRecord(this.convertFields(record));
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                    return recordSet;
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return recordSet;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return recordSet;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return recordSet;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return recordSet;
    }

    public RecordSet getRecords(DataLoadingSpec spec) throws MalformedSourceException {
        return this.getRecords();
    }

    public Record convertFields(Record publication) {
        for (String fieldName : this.fieldMap.keySet()) {
            String md = null;
            if (this.fieldMap != null) {
                md = this.fieldMap.get(fieldName);
            }
            if (StringUtils.isBlank(md)) continue;
            md = md.trim();
            if (!publication.isMutable()) continue;
            List values = publication.getValues(fieldName);
            publication.makeMutable().removeField(fieldName);
            publication.makeMutable().addField(md, values);
        }
        return publication;
    }

    public void setFieldMap(Map<String, String> fieldMap) {
        this.fieldMap = fieldMap;
    }
}

