/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.StringValue;
import gr.ekt.bte.core.Value;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.util.XMLUtils;
import org.dspace.submit.util.SubmissionLookupPublication;
import org.w3c.dom.Element;

public class PubmedUtils {
    public static Record convertCrossRefDomToRecord(Element pubArticle) {
        Element journal;
        List<Element> authorsElement;
        String summary;
        Element abstractElement;
        String title;
        String pubblicationModel;
        String status;
        List<Element> identifiers;
        SubmissionLookupPublication record = new SubmissionLookupPublication("");
        HashMap<String, String> mounthToNum = new HashMap<String, String>();
        mounthToNum.put("Jan", "01");
        mounthToNum.put("Feb", "02");
        mounthToNum.put("Mar", "03");
        mounthToNum.put("Apr", "04");
        mounthToNum.put("May", "05");
        mounthToNum.put("Jun", "06");
        mounthToNum.put("Jul", "07");
        mounthToNum.put("Aug", "08");
        mounthToNum.put("Sep", "09");
        mounthToNum.put("Oct", "10");
        mounthToNum.put("Nov", "11");
        mounthToNum.put("Dec", "12");
        Element medline = XMLUtils.getSingleElement(pubArticle, "MedlineCitation");
        Element article = XMLUtils.getSingleElement(medline, "Article");
        Element pubmed = XMLUtils.getSingleElement(pubArticle, "PubmedData");
        Element identifierList = XMLUtils.getSingleElement(pubmed, "ArticleIdList");
        if (identifierList != null && (identifiers = XMLUtils.getElementList(identifierList, "ArticleId")) != null) {
            for (Element id : identifiers) {
                String doi;
                if ("pubmed".equals(id.getAttribute("IdType"))) {
                    String pubmedID = id.getTextContent().trim();
                    if (pubmedID == null) continue;
                    record.addValue("pubmedID", (Value)new StringValue(pubmedID));
                    continue;
                }
                if (!"doi".equals(id.getAttribute("IdType")) || (doi = id.getTextContent().trim()) == null) continue;
                record.addValue("doi", (Value)new StringValue(doi));
            }
        }
        if ((status = XMLUtils.getElementValue(pubmed, "PublicationStatus")) != null) {
            record.addValue("status", (Value)new StringValue(status));
        }
        if ((pubblicationModel = XMLUtils.getElementAttribute(medline, "Article", "PubModel")) != null) {
            record.addValue("pubblicationModel", (Value)new StringValue(pubblicationModel));
        }
        if ((title = XMLUtils.getElementValue(article, "ArticleTitle")) != null) {
            record.addValue("title", (Value)new StringValue(title));
        }
        if ((abstractElement = XMLUtils.getSingleElement(medline, "Abstract")) == null) {
            abstractElement = XMLUtils.getSingleElement(medline, "OtherAbstract");
        }
        if (abstractElement != null && (summary = XMLUtils.getElementValue(abstractElement, "AbstractText")) != null) {
            record.addValue("summary", (Value)new StringValue(summary));
        }
        LinkedList<String[]> authors = new LinkedList<String[]>();
        Element authorList = XMLUtils.getSingleElement(article, "AuthorList");
        if (authorList != null && (authorsElement = XMLUtils.getElementList(authorList, "Author")) != null) {
            for (Element author : authorsElement) {
                if (!StringUtils.isBlank((String)XMLUtils.getElementValue(author, "CollectiveName"))) continue;
                authors.add(new String[]{XMLUtils.getElementValue(author, "ForeName"), XMLUtils.getElementValue(author, "LastName")});
            }
        }
        if (authors.size() > 0) {
            LinkedList<StringValue> values = new LinkedList<StringValue>();
            for (String[] sArray : authors) {
                values.add(new StringValue(sArray[1] + ", " + sArray[0]));
            }
            record.addField("authors", values);
        }
        if ((journal = XMLUtils.getSingleElement(article, "Journal")) != null) {
            Element paginationElement;
            LinkedList<StringValue> values;
            LinkedList<StringValue> values2;
            String language;
            Element journalIssueElement;
            String journalTitle;
            List<Element> jnumbers = XMLUtils.getElementList(journal, "ISSN");
            if (jnumbers != null) {
                for (Element jnumber : jnumbers) {
                    if ("Print".equals(jnumber.getAttribute("IssnType"))) {
                        String issn = jnumber.getTextContent().trim();
                        if (issn == null) continue;
                        record.addValue("issn", (Value)new StringValue(issn));
                        continue;
                    }
                    String eissn = jnumber.getTextContent().trim();
                    if (eissn == null) continue;
                    record.addValue("eissn", (Value)new StringValue(eissn));
                }
            }
            if ((journalTitle = XMLUtils.getElementValue(journal, "Title")) != null) {
                record.addValue("journalTitle", (Value)new StringValue(journalTitle));
            }
            if ((journalIssueElement = XMLUtils.getSingleElement(journal, "JournalIssue")) != null) {
                String issue;
                String volume = XMLUtils.getElementValue(journalIssueElement, "Volume");
                if (volume != null) {
                    record.addValue("volume", (Value)new StringValue(volume));
                }
                if ((issue = XMLUtils.getElementValue(journalIssueElement, "Issue")) != null) {
                    record.addValue("issue", (Value)new StringValue(issue));
                }
                Element pubDataElement = XMLUtils.getSingleElement(journalIssueElement, "PubDate");
                String year = null;
                if (pubDataElement != null) {
                    year = XMLUtils.getElementValue(pubDataElement, "Year");
                    String mounth = XMLUtils.getElementValue(pubDataElement, "Month");
                    String day = XMLUtils.getElementValue(pubDataElement, "Day");
                    if (StringUtils.isNotBlank((String)mounth) && mounthToNum.containsKey(mounth)) {
                        year = year + "-" + (String)mounthToNum.get(mounth);
                        if (StringUtils.isNotBlank((String)day)) {
                            year = year + "-" + (day.length() == 1 ? "0" + day : day);
                        }
                    }
                }
                if (year != null) {
                    record.addValue("year", (Value)new StringValue(year));
                }
            }
            if ((language = XMLUtils.getElementValue(article, "Language")) != null) {
                record.addValue("language", (Value)new StringValue(language));
            }
            LinkedList<String> type = new LinkedList<String>();
            Element publicationTypeList = XMLUtils.getSingleElement(article, "PublicationTypeList");
            if (publicationTypeList != null) {
                List<Element> publicationTypes = XMLUtils.getElementList(publicationTypeList, "PublicationType");
                for (Element publicationType : publicationTypes) {
                    type.add(publicationType.getTextContent().trim());
                }
            }
            if (type.size() > 0) {
                LinkedList<StringValue> values3 = new LinkedList<StringValue>();
                for (String s : type) {
                    values3.add(new StringValue(s));
                }
                record.addField("type", values3);
            }
            LinkedList<String> primaryKeywords = new LinkedList<String>();
            LinkedList<String> secondaryKeywords = new LinkedList<String>();
            Element keywordsList = XMLUtils.getSingleElement(medline, "KeywordList");
            if (keywordsList != null) {
                List<Element> keywords = XMLUtils.getElementList(keywordsList, "Keyword");
                for (Element keyword : keywords) {
                    if ("Y".equals(keyword.getAttribute("MajorTopicYN"))) {
                        primaryKeywords.add(keyword.getTextContent().trim());
                        continue;
                    }
                    secondaryKeywords.add(keyword.getTextContent().trim());
                }
            }
            if (primaryKeywords.size() > 0) {
                values2 = new LinkedList<StringValue>();
                for (String s : primaryKeywords) {
                    values2.add(new StringValue(s));
                }
                record.addField("primaryKeywords", values2);
            }
            if (secondaryKeywords.size() > 0) {
                values2 = new LinkedList();
                for (String s : secondaryKeywords) {
                    values2.add(new StringValue(s));
                }
                record.addField("secondaryKeywords", values2);
            }
            LinkedList<String> primaryMeshHeadings = new LinkedList<String>();
            LinkedList<String> secondaryMeshHeadings = new LinkedList<String>();
            Element meshHeadingsList = XMLUtils.getSingleElement(medline, "MeshHeadingList");
            if (meshHeadingsList != null) {
                List<Element> meshHeadings = XMLUtils.getElementList(meshHeadingsList, "MeshHeading");
                for (Element meshHeading : meshHeadings) {
                    if ("Y".equals(XMLUtils.getElementAttribute(meshHeading, "DescriptorName", "MajorTopicYN"))) {
                        primaryMeshHeadings.add(XMLUtils.getElementValue(meshHeading, "DescriptorName"));
                        continue;
                    }
                    secondaryMeshHeadings.add(XMLUtils.getElementValue(meshHeading, "DescriptorName"));
                }
            }
            if (primaryMeshHeadings.size() > 0) {
                values = new LinkedList<StringValue>();
                for (String s : primaryMeshHeadings) {
                    values.add(new StringValue(s));
                }
                record.addField("primaryMeshHeadings", values);
            }
            if (secondaryMeshHeadings.size() > 0) {
                values = new LinkedList();
                for (String s : secondaryMeshHeadings) {
                    values.add(new StringValue(s));
                }
                record.addField("secondaryMeshHeadings", values);
            }
            if ((paginationElement = XMLUtils.getSingleElement(article, "Pagination")) != null) {
                String startPage = XMLUtils.getElementValue(paginationElement, "StartPage");
                String endPage = XMLUtils.getElementValue(paginationElement, "EndPage");
                if (StringUtils.isBlank((String)startPage)) {
                    startPage = XMLUtils.getElementValue(paginationElement, "MedlinePgn");
                }
                if (startPage != null) {
                    record.addValue("startPage", (Value)new StringValue(startPage));
                }
                if (endPage != null) {
                    record.addValue("endPage", (Value)new StringValue(endPage));
                }
            }
        }
        return record;
    }
}

