/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.DataOutputSpec;
import gr.ekt.bte.core.OutputGenerator;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.RecordSet;
import gr.ekt.bte.core.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dspace.submit.util.ItemSubmissionLookupDTO;

public class SubmissionLookupOutputGenerator
implements OutputGenerator {
    private List<ItemSubmissionLookupDTO> dtoList;
    private static final String DOI_FIELD = "doi";
    private static final String NOT_FOUND_DOI = "NOT-FOUND-DOI";

    public List<String> generateOutput(RecordSet records) {
        this.dtoList = new ArrayList<ItemSubmissionLookupDTO>();
        HashMap record_sets = new HashMap();
        int counter = 0;
        for (Record rec : records) {
            String current_doi = NOT_FOUND_DOI;
            List values = rec.getValues(DOI_FIELD);
            current_doi = values != null && values.size() > 0 ? ((Value)values.get(0)).getAsString() : "NOT-FOUND-DOI_" + counter;
            if (record_sets.keySet().contains(current_doi)) {
                ((List)record_sets.get(current_doi)).add(rec);
            } else {
                ArrayList<Record> publication = new ArrayList<Record>();
                publication.add(rec);
                record_sets.put(current_doi, publication);
            }
            ++counter;
        }
        for (Map.Entry entry : record_sets.entrySet()) {
            ItemSubmissionLookupDTO dto = new ItemSubmissionLookupDTO((List)entry.getValue());
            this.dtoList.add(dto);
        }
        return new ArrayList<String>();
    }

    public List<String> generateOutput(RecordSet records, DataOutputSpec spec) {
        return this.generateOutput(records);
    }

    public List<ItemSubmissionLookupDTO> getDtoList() {
        return this.dtoList;
    }

    public void setDtoList(List<ItemSubmissionLookupDTO> items) {
        this.dtoList = items;
    }
}

