/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.xmlworkflow.RoleMembers;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.WorkflowFactory;
import org.dspace.xmlworkflow.XmlWorkflowManager;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.storedcomponents.InProgressUser;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class WorkflowRequirementsManager {
    public static final String WORKFLOW_SCHEMA = "workflow";

    public static void addClaimedUser(Context c, XmlWorkflowItem wfi, Step step, EPerson user) throws SQLException, AuthorizeException, IOException {
        PoolTask task = PoolTask.findByWorkflowIdAndEPerson(c, wfi.getID(), user.getID());
        if (task != null && task.getEpersonID() >= 0) {
            XmlWorkflowManager.deletePooledTask(c, wfi, task);
        }
        InProgressUser ipu = InProgressUser.create(c);
        ipu.setWorkflowItemID(wfi.getID());
        ipu.setUserID(user.getID());
        ipu.setFinished(false);
        ipu.update();
        int totalUsers = InProgressUser.getNumberOfInProgressUsers(c, wfi.getID()) + InProgressUser.getNumberOfFinishedUsers(c, wfi.getID());
        if (totalUsers == step.getRequiredUsers()) {
            XmlWorkflowManager.deleteAllPooledTasks(c, wfi);
        }
        wfi.update();
    }

    public static void removeClaimedUser(Context c, XmlWorkflowItem wfi, EPerson user, String stepID) throws SQLException, IOException, WorkflowConfigurationException, AuthorizeException {
        int totalUsers = InProgressUser.getNumberOfInProgressUsers(c, wfi.getID()) + InProgressUser.getNumberOfFinishedUsers(c, wfi.getID());
        InProgressUser.findByWorkflowItemAndEPerson(c, wfi.getID(), user.getID()).delete();
        Workflow workflow = WorkflowFactory.getWorkflow(wfi.getCollection());
        Step step = workflow.getStep(stepID);
        if (totalUsers == step.getRequiredUsers()) {
            List<InProgressUser> toIgnore = InProgressUser.findByWorkflowItem(c, wfi.getID());
            RoleMembers roleMembers = step.getRole().getMembers(c, wfi);
            for (InProgressUser ipu : toIgnore) {
                roleMembers.removeEperson(ipu.getUserID());
            }
            step.getUserSelectionMethod().getProcessingAction().regenerateTasks(c, wfi, roleMembers);
        } else {
            RoleMembers role = step.getRole().getMembers(c, wfi);
            ArrayList<EPerson> epersons = role.getEPersons();
            for (EPerson eperson : epersons) {
                if (eperson.getID() != user.getID()) continue;
                RoleMembers memberToRegenerateTasksFor = new RoleMembers();
                memberToRegenerateTasksFor.addEPerson(user);
                step.getUserSelectionMethod().getProcessingAction().regenerateTasks(c, wfi, memberToRegenerateTasksFor);
                break;
            }
        }
        wfi.getItem().update();
    }

    public static void addFinishedUser(Context c, XmlWorkflowItem wfi, EPerson user) throws AuthorizeException, SQLException {
        InProgressUser ipu = InProgressUser.findByWorkflowItemAndEPerson(c, wfi.getID(), user.getID());
        ipu.setFinished(true);
        ipu.update();
    }

    public static void clearInProgressUsers(Context c, XmlWorkflowItem wfi) throws AuthorizeException, SQLException {
        List<InProgressUser> ipus = InProgressUser.findByWorkflowItem(c, wfi.getID());
        for (InProgressUser ipu : ipus) {
            ipu.delete();
        }
    }
}

