/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sherpa.submit;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.sherpa.SHERPAResponse;
import org.dspace.app.sherpa.SHERPAService;
import org.dspace.app.sherpa.submit.ISSNItemExtractor;
import org.dspace.app.sherpa.submit.SHERPASubmitConfigurationService;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class SHERPASubmitService {
    private SHERPAService sherpaService;
    private SHERPASubmitConfigurationService configuration;
    private static Logger log = Logger.getLogger(SHERPASubmitService.class);

    public void setConfiguration(SHERPASubmitConfigurationService configuration) {
        this.configuration = configuration;
    }

    public void setSherpaService(SHERPAService sherpaService) {
        this.sherpaService = sherpaService;
    }

    public SHERPAResponse searchRelatedJournals(Context context, Item item) {
        Set<String> issns = this.getISSNs(context, item);
        if (issns == null || issns.size() == 0) {
            return null;
        }
        return this.sherpaService.searchByJournalISSN(StringUtils.join(issns, (String)","));
    }

    private Set<String> getISSNs(Context context, Item item) {
        LinkedHashSet<String> issns = new LinkedHashSet<String>();
        if (this.configuration.getIssnItemExtractors() == null) {
            log.warn((Object)LogManager.getHeader(context, "searchRelatedJournals", "no issnItemExtractors defined"));
            return null;
        }
        for (ISSNItemExtractor extractor : this.configuration.getIssnItemExtractors()) {
            List<String> eIssns = extractor.getISSNs(context, item);
            if (eIssns == null) continue;
            for (String eIssn : eIssns) {
                issns.add(eIssn.trim());
            }
        }
        return issns;
    }

    public boolean hasISSNs(Context context, Item item) {
        Set<String> issns = this.getISSNs(context, item);
        return issns != null && issns.size() != 0;
    }
}

